/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.mobs.tracker;

import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.events.MythicMobDeathEvent;
import io.lumine.mythic.bukkit.events.MythicMobDespawnEvent;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.mobs.tracker.DamageRecord;
import io.lumine.mythic.core.mobs.tracker.DamageSnapshot;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class DamageRecordManager {
    private final MythicBukkit plugin;
    private HashMap<UUID, DamageRecord> activeRecords = new HashMap();

    public DamageRecordManager(MythicBukkit plugin) {
        this.plugin = plugin;
        Events.subscribe(EntityDamageByEntityEvent.class, EventPriority.MONITOR).filter(e -> !(e.getEntity() instanceof Player) || !(e.getDamager() instanceof Player)).filter(event -> event.getDamager() instanceof Player).handler(this::handleNewSnapshot);
        Events.subscribe(MythicMobDeathEvent.class).filter(e -> e.getMobType().getDamageLeaderboard()).handler(e -> Schedulers.async().runLater(() -> this.activeRecords.remove(e.getEntity().getUniqueId()), 100L));
        Events.subscribe(MythicMobDespawnEvent.class).filter(e -> e.getMobType().getDamageLeaderboard()).handler(e -> Schedulers.async().runLater(() -> this.activeRecords.remove(e.getEntity().getUniqueId()), 100L));
    }

    public void handleNewSnapshot(EntityDamageByEntityEvent event) {
        Player player = (Player)event.getDamager();
        Entity damagedEntity = event.getEntity();
        Optional<ActiveMob> maybeMob = this.plugin.getMobManager().getActiveMob(damagedEntity.getUniqueId());
        if (maybeMob.isEmpty()) {
            return;
        }
        ActiveMob am = maybeMob.get();
        if (!am.getType().getDamageLeaderboard().booleanValue()) {
            return;
        }
        DamageSnapshot snapshot = DamageSnapshot.create(damagedEntity.getUniqueId(), player.getUniqueId(), event.getDamage());
        this.addRecord(damagedEntity.getUniqueId(), snapshot);
    }

    public DamageRecord getRecord(UUID entity) {
        return this.activeRecords.getOrDefault(entity, null);
    }

    private void addRecord(UUID entity, DamageSnapshot snapshot) {
        if (this.activeRecords.containsKey(entity)) {
            this.activeRecords.get(entity).registerSnapshot(snapshot);
        } else {
            DamageRecord damageRecord = new DamageRecord(this, entity);
            damageRecord.registerSnapshot(snapshot);
            this.activeRecords.put(entity, damageRecord);
        }
    }

    public HashMap<UUID, DamageRecord> getActiveRecords() {
        return this.activeRecords;
    }
}

