/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.items;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.lumine.mythic.api.adapters.AbstractAttributeModifier;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractItemFlag;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.adapters.AbstractItemStackRarity;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.api.packs.Pack;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillTrigger;
import io.lumine.mythic.api.skills.placeholders.PlaceholderColor;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.bukkit.adapters.item.ItemComponentBukkitItemStack;
import io.lumine.mythic.bukkit.events.MythicApplyEnchantEvent;
import io.lumine.mythic.bukkit.events.MythicMobItemGenerateEvent;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.items.ItemFactory;
import io.lumine.mythic.bukkit.utils.menu.Icon;
import io.lumine.mythic.bukkit.utils.menu.IconBuilder;
import io.lumine.mythic.bukkit.utils.menu.MenuData;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.bukkit.utils.serialize.Chroma;
import io.lumine.mythic.bukkit.utils.text.Text;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.config.ConfigExecutor;
import io.lumine.mythic.core.config.MythicConfigImpl;
import io.lumine.mythic.core.config.MythicLineConfigImpl;
import io.lumine.mythic.core.drops.DropMetadataImpl;
import io.lumine.mythic.core.drops.EquipSlot;
import io.lumine.mythic.core.items.LegacyItemConverter;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.menus.items.ItemEditorMenuContext;
import io.lumine.mythic.core.menus.items.ItemMenuContext;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.SkillString;
import io.lumine.mythic.core.utils.MythicUtil;
import io.lumine.mythic.core.utils.Patterns;
import io.lumine.mythic.core.utils.jnbt.ByteTag;
import io.lumine.mythic.core.utils.jnbt.CompoundTag;
import io.lumine.mythic.core.utils.jnbt.CompoundTagBuilder;
import io.lumine.mythic.core.utils.jnbt.DoubleTag;
import io.lumine.mythic.core.utils.jnbt.FloatTag;
import io.lumine.mythic.core.utils.jnbt.IntTag;
import io.lumine.mythic.core.utils.jnbt.ListTag;
import io.lumine.mythic.core.utils.jnbt.StringTag;
import io.lumine.mythic.core.utils.jnbt.Tag;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockState;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class MythicItem
implements Comparable<MythicItem>,
MenuData<ItemMenuContext> {
    private final MythicConfig config;
    private AbstractItemStack cachedBaseItem;
    private ItemStack cachedMenuItem;
    private boolean imported = false;
    private final String internalName;
    private final Pack pack;
    private final File file;
    private String group = "OTHER";
    private String displayName;
    private String strMaterial;
    private Material material;
    private int customModelData;
    @Deprecated
    private byte data;
    private int amount = 1;
    private PlaceholderInt durability;
    private PlaceholderInt maxDurability;
    private int maxStackSize;
    private Boolean fireResistant;
    private AbstractItemStackRarity rarity;
    private PlaceholderInt maxEnchantments;
    private Boolean preventEnchanting;
    private Boolean preventAnvilWith;
    private Boolean preventCraftingWith;
    private Boolean preventSmithingWith;
    private PlaceholderColor dropColor;
    private PlaceholderColor color;
    private DyeColor shieldColor;
    private PlaceholderString armorTrim;
    private String player;
    private String skinURL;
    private String skinTexture;
    private UUID skinUUID;
    private Optional<String> loreTemplate = Optional.empty();
    private List<PlaceholderString> lore;
    private Map<Enchantment, PlaceholderInt> enchantments = Maps.newConcurrentMap();
    private PlaceholderString bookAuthor;
    private PlaceholderString bookTitle;
    private List<PlaceholderString> bookPages;
    private List<String> potionEffects;
    private List<String> bannerLayers;
    private List<String> fireworkColors;
    private List<String> fireworkFadeColors;
    private Map<String, Tag> itemNBT = new HashMap<String, Tag>();
    private final List<AbstractAttributeModifier> itemAttributes = new ArrayList<AbstractAttributeModifier>();
    private final Map<String, Tag> itemOptions = new HashMap<String, Tag>();
    private final List<String> hideOptions = new ArrayList<String>();
    private final List<String> placeOptions = new ArrayList<String>();
    private final List<String> breakOptions = new ArrayList<String>();
    private boolean unbreakable;
    private boolean hideFlags;
    private String mythicTypeOverride;
    private Boolean appendType = true;
    private boolean preventStacking = false;
    private int itemVersion = 0;
    private boolean preserveStatRatioOnUpdate = true;
    private String dropGlowColor = null;
    private Chroma dropBeamColor = null;
    private boolean dropGlow = false;
    private boolean dropBeam = false;
    private final Map<SkillTrigger<?>, Queue<SkillMechanic>> dropSkills = new HashMap();

    private static MythicBukkit getPlugin() {
        return MythicBukkit.inst();
    }

    public MythicItem(Pack pack, File file, String internalName) {
        this.pack = pack;
        this.file = file;
        this.internalName = internalName;
        this.config = new MythicConfigImpl(internalName, file);
        this.config.load();
        this.config.set("Material", "STONE");
        this.config.set("Model", 0);
        this.config.set("Display", internalName);
        this.config.save();
        this.loadItem();
    }

    public MythicItem(Pack pack, File file, String internalName, MythicConfig mc) {
        this.pack = pack;
        this.config = mc;
        this.file = file;
        this.internalName = internalName;
        this.loadItem();
    }

    public void loadItem() {
        List<String> canBreak;
        List<String> canPlaceOn;
        List<String> hideOptions;
        double mmoPvEDamage;
        this.itemNBT.clear();
        this.itemOptions.clear();
        this.hideOptions.clear();
        this.placeOptions.clear();
        this.breakOptions.clear();
        this.mythicTypeOverride = this.internalName;
        this.data = (byte)this.config.getInteger("Data", 0);
        this.durability = this.config.getPlaceholderInt(new String[]{"Options.Durability", "Durability"}, String.valueOf(this.data));
        this.maxDurability = this.config.getPlaceholderInt(new String[]{"Options.MaxDurability", "MaxDurability", "CustomDurability.Durability"}, "0");
        if (this.config.isSet("ItemStack")) {
            ItemStack is = this.config.getItemStack("ItemStack", null);
            if (is != null) {
                this.cachedBaseItem = BukkitAdapter.adapt(is);
                try {
                    this.displayName = is.getItemMeta().getDisplayName();
                    this.lore = new ArrayList<PlaceholderString>();
                    for (String s2 : is.getItemMeta().getLore()) {
                        this.lore.add(PlaceholderString.of(s2));
                    }
                    this.imported = true;
                }
                catch (Exception ex) {
                    MythicLogger.errorItemConfig(this, this.config, "Couldn't get name/lore of ItemStack");
                }
            } else {
                MythicLogger.errorItemConfig(this, this.config, "Failed to load imported Bukkit ItemStack");
                this.cachedBaseItem = BukkitAdapter.adapt(Material.STONE);
            }
        } else {
            this.strMaterial = this.config.getString(new String[]{"Id", "Material"}, ConfigExecutor.getItemDefaultMaterial(), new String[0]).toUpperCase();
            this.setupMaterial(this.strMaterial);
        }
        this.group = this.config.getString(new String[]{"Group", "ItemType", "Options.Group", "Options.ItemType"}, "OTHER", new String[0]);
        this.amount = this.config.getInteger("Amount", 1);
        this.displayName = SkillString.parseMessageSpecialChars(this.config.getString("Display"));
        if (this.config.isList("Lore")) {
            this.lore = this.config.getPlaceholderStringList("Lore");
        } else if (this.config.isConfigurationSection("Lore")) {
            this.loreTemplate = Optional.ofNullable(this.config.getString("Lore.Template", null));
        }
        this.bookAuthor = this.config.getPlaceholderString("Author", "Unknown");
        this.bookTitle = this.config.getPlaceholderString("Title", "Unknown");
        if (this.config.isList("Pages")) {
            this.bookPages = this.config.getPlaceholderStringList("Pages");
        }
        this.potionEffects = this.config.getStringList("PotionEffects");
        this.bannerLayers = this.config.getStringList("BannerLayers");
        this.fireworkColors = this.config.getStringList("Firework.Colors");
        this.fireworkFadeColors = this.config.getStringList("Firework.FadeColors");
        if (this.material == Material.SHIELD) {
            try {
                this.shieldColor = DyeColor.valueOf((String)this.config.getString("Options.Color", null));
            }
            catch (Throwable is) {}
        } else {
            this.color = this.config.getPlaceholderColor("Options.Color", null);
        }
        try {
            this.shieldColor = DyeColor.valueOf((String)this.config.getString("Options.Color", null));
        }
        catch (Throwable is) {
            // empty catch block
        }
        this.armorTrim = this.config.getPlaceholderString("Options.Trim", null);
        this.player = this.config.getString("Options.Player");
        this.skinURL = this.config.getString("Options.SkinURL");
        this.skinTexture = this.config.getString("Options.SkinTexture");
        if (this.skinTexture != null) {
            this.skinUUID = MythicUtil.getUUIDFromString(this.skinTexture);
        } else if (this.skinURL != null) {
            this.skinUUID = MythicUtil.getUUIDFromString(this.skinURL);
        }
        this.unbreakable = this.config.getBoolean("Options.Indestructible", false);
        this.unbreakable = this.config.getBoolean("Options.Indestructable", this.unbreakable);
        this.unbreakable = this.config.getBoolean("Options.Unbreakable", this.unbreakable);
        this.hideFlags = this.config.getBoolean("Options.HideFlags", false);
        this.appendType = this.config.getBoolean("Options.AppendType", true);
        this.customModelData = this.config.getInteger("Model", -1);
        this.customModelData = this.config.getInteger("Options.Model", this.customModelData);
        this.customModelData = this.config.getInteger("Options.CustomModelData", this.customModelData);
        this.customModelData = this.config.getInteger("CustomModelData", this.customModelData);
        this.maxEnchantments = PlaceholderInt.of(this.config.getString("Options.MaxEnchants", "-1"));
        this.preventEnchanting = this.config.getBoolean("Options.PreventEnchanting", false);
        this.preventCraftingWith = this.config.getBoolean("Options.PreventCrafting", this.customModelData > 0);
        this.preventAnvilWith = this.config.getBoolean("Options.PreventAnvil", this.customModelData > 0);
        this.preventSmithingWith = this.config.getBoolean("Options.PreventSmithing", this.customModelData > 0);
        this.itemVersion = this.config.getInteger("ItemUpdater.Version", 0);
        this.preserveStatRatioOnUpdate = this.config.getBoolean("ItemUpdater.PreserveStatRatio", true);
        this.dropGlowColor = this.config.getString("Options.DropGlowColor", null);
        this.dropBeamColor = this.config.getColor("Options.DropBeamColor", null);
        if (this.dropGlowColor != null) {
            this.dropGlow = true;
        }
        if (this.dropBeamColor != null) {
            this.dropBeam = true;
        }
        List<String> dropSkills = this.config.getStringList("DropSkills");
        for (String s2 : dropSkills) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Loading mechanic line: {0}", s2);
            s2 = MythicLineConfigImpl.unparseBlock(s2);
            SkillMechanic ms = MythicItem.getPlugin().getSkillManager().getMechanic(s2);
            if (ms != null) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Base skill found.", new Object[0]);
                if (!this.dropSkills.containsKey(ms.getTrigger())) {
                    this.dropSkills.put(ms.getTrigger(), new LinkedList());
                }
                this.dropSkills.get(ms.getTrigger()).add(ms);
                continue;
            }
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Base skill was not found.", new Object[0]);
        }
        if (this.preventEnchanting.booleanValue()) {
            this.itemOptions.put("PreventEnchanting", new ByteTag(1));
        }
        if (this.preventAnvilWith.booleanValue()) {
            this.itemOptions.put("PreventAnvil", new ByteTag(1));
        }
        if (this.preventCraftingWith.booleanValue()) {
            this.itemOptions.put("PreventCrafting", new ByteTag(1));
        }
        if (this.preventSmithingWith.booleanValue()) {
            this.itemOptions.put("PreventSmithing", new ByteTag(1));
        }
        if ((mmoPvEDamage = this.config.getDouble("MMOItemsStats.PvEDamage", -1.0)) > -1.0) {
            this.itemOptions.put("MMOITEMS_PVE_DAMAGE", new DoubleTag(mmoPvEDamage));
        }
        if ((hideOptions = this.config.getStringList("Hide")) != null) {
            for (String hide : hideOptions) {
                String f = "HIDE_" + hide.toUpperCase();
                this.hideOptions.add(f);
            }
        }
        if ((canPlaceOn = this.config.getStringList("CanPlaceOn")) != null) {
            this.placeOptions.addAll(canPlaceOn);
        }
        if ((canBreak = this.config.getStringList("CanBreak")) != null) {
            this.breakOptions.addAll(canBreak);
        }
        this.maxStackSize = this.config.getInt("Options.StackSize", -1);
        if (this.config.getString("Options.FireResistant") != null) {
            this.fireResistant = this.config.getBoolean("Options.FireResistant");
        }
        this.preventStacking = this.config.getBoolean("Options.PreventStacking", false);
        if (this.config.isSet("NBT")) {
            try {
                this.itemNBT = this.parseNBTNode("NBT");
            }
            catch (Exception ex) {
                MythicLogger.errorItemConfig(this, this.config, "NBT tags are configured incorrectly.");
                MythicLogger.handleMinorError(ex);
            }
        }
        if (this.config.isSet("Attributes")) {
            try {
                UUID tagUUID = MythicUtil.getUUIDFromString(this.internalName);
                for (String slot : this.config.getKeys("Attributes")) {
                    for (String attr : this.config.getKeys("Attributes." + slot)) {
                        String value;
                        String configuration = this.config.getString("Attributes." + slot + "." + attr);
                        String[] fields = configuration.split(" ");
                        String rawValue = fields[0];
                        AbstractAttributeModifier.Operation operation = null;
                        String attributeKey = MythicBukkit.inst().getItemManager().getItemAttribute(attr);
                        if (fields.length > 1) {
                            operation = AbstractAttributeModifier.Operation.parse(fields[1]);
                        }
                        if ((value = rawValue).endsWith("%")) {
                            value = String.valueOf(Double.parseDouble(configuration.substring(0, configuration.length() - 1)) / 100.0);
                            if (operation == null) {
                                operation = AbstractAttributeModifier.Operation.ADD_SCALAR;
                            }
                        }
                        if (operation == null) {
                            operation = attributeKey.equals("generic.attackSpeed") || attributeKey.equals("generic.attack_speed") || attributeKey.equals("generic.movementSpeed") || attributeKey.equals("generic.movement_speed") ? AbstractAttributeModifier.Operation.ADD_SCALAR : AbstractAttributeModifier.Operation.ADD;
                        }
                        this.itemAttributes.add(new AbstractAttributeModifier(attributeKey, tagUUID, PlaceholderDouble.of(value), operation, EquipSlot.of(slot.toUpperCase(Locale.ROOT))));
                    }
                }
            }
            catch (Exception ex) {
                MythicLogger.errorItemConfig(this, this.config, "Attributes are configured incorrectly.");
                ex.printStackTrace();
            }
        }
        MythicItem.getPlugin().getClock().queuePostReload(() -> {
            List<String> enchantmentsIn = this.config.getStringList("Enchantments");
            for (String in : enchantmentsIn) {
                if (this.addEnchantment(in)) continue;
                MythicLogger.errorItemConfig(this, this.config, "Invalid enchantment configured: " + in);
            }
            this.buildItemCache();
        });
    }

    private Map<String, Tag> parseNBTNode(String node) {
        MythicConfig config = this.config;
        ConcurrentMap tags = Maps.newConcurrentMap();
        for (String baseKey : config.getKeys(node)) {
            String innerNode = node + "." + baseKey;
            if (config.isConfigurationSection(innerNode)) {
                tags.put(baseKey, CompoundTag.create(tag -> tag.putAll(this.parseNBTNode(innerNode))));
                continue;
            }
            if (config.isList(innerNode)) {
                tags.put(baseKey, new ListTag(StringTag.class, config.getStringList(innerNode).stream().map(StringTag::new).toList()));
                continue;
            }
            Tag nbtValue = this.getNbtValue(config.getString(innerNode));
            tags.put(baseKey, nbtValue);
        }
        return tags;
    }

    private Tag getNbtValue(String string) {
        if (string.startsWith("int/")) {
            return new IntTag(Integer.parseInt(string.substring(4)));
        }
        if (string.startsWith("float/")) {
            return new FloatTag(Float.parseFloat(string.substring(6)));
        }
        if (string.startsWith("double/")) {
            return new DoubleTag(Double.parseDouble(string.substring(7)));
        }
        if (string.startsWith("byte/")) {
            return new ByteTag(Byte.parseByte(string.substring(5)));
        }
        if (string.startsWith("bool/")) {
            return new ByteTag(Boolean.parseBoolean(string.substring(5)) ? (byte)1 : 0);
        }
        if (string.startsWith("boolean/")) {
            return new ByteTag(Boolean.parseBoolean(string.substring(8)) ? (byte)1 : 0);
        }
        return new StringTag(string);
    }

    public void buildItemCache() {
        this.cachedMenuItem = BukkitAdapter.adapt(this.generateItemStack(1));
        String displayName = this.displayName == null ? "<gray>(No Display Name)" : this.displayName;
        String materialName = this.material == null ? "<gray>Material Not Set" : this.material.toString();
        this.cachedMenuItem = ItemFactory.of(this.cachedMenuItem).hideAttributes().name("<green><bold>" + this.internalName).clearLore().lore("<red> ").lore("<yellow>" + materialName + " <gray>(Model: <aqua>" + this.customModelData + "<gray>)").lore("<red> ").lore(displayName).lore(this.getLore()).lore("<red> ").lore("<rainbow>\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583").lore("<red> ").lore("<gray>\u22b3 <yellow>Left-Click to get Item").lore("<gray>\u22b3 <yellow>Right-Click to Edit").build();
    }

    @Deprecated
    public ItemStack getCachedBaseItem() {
        return BukkitAdapter.adapt(this.cachedBaseItem);
    }

    @Deprecated
    public String getMaterialName() {
        return this.strMaterial;
    }

    public boolean setMaterial(String material) {
        if (this.setupMaterial(material)) {
            if (this.config.isSet("Id")) {
                this.config.setSave("Id", material);
            } else {
                this.config.setSave("Material", material);
            }
            this.buildItemCache();
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean setupMaterial(String material) {
        this.strMaterial = material;
        try {
            if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_15)) {
                this.material = Material.AIR;
                try {
                    Material material2 = this.material = this.data == 0 ? Material.valueOf((String)this.strMaterial) : LegacyItemConverter.getMaterial(this.strMaterial, this.data);
                    if (this.material != null || this.data <= 0) return true;
                    this.material = Material.valueOf((String)this.strMaterial);
                    return true;
                }
                catch (Exception ex) {
                    this.material = LegacyItemConverter.getMaterial(this.strMaterial, this.data);
                    if (this.material != null || this.data <= 0) return true;
                    this.material = Material.valueOf((String)this.strMaterial);
                    return true;
                }
                finally {
                    this.cachedBaseItem = BukkitAdapter.adapt(this.material);
                }
            } else {
                this.material = this.strMaterial.matches("[0-9]*") ? LegacyItemConverter.getMaterial(this.strMaterial, (byte)0) : Material.valueOf((String)this.strMaterial);
                this.cachedBaseItem = BukkitAdapter.adapt(this.material).data(this.data).amount(this.amount * this.amount);
            }
            return true;
        }
        catch (Exception ex) {
            this.material = Material.STONE;
            this.cachedBaseItem = BukkitAdapter.adapt(this.material);
            MythicLogger.errorItemConfig(this, this.config, "Material type '" + this.strMaterial + "' not found");
            return false;
        }
    }

    public List<String> getLore() {
        ArrayList ret = Lists.newArrayList();
        if (this.lore == null) {
            return ret;
        }
        for (PlaceholderString pl : this.lore) {
            ret.add(pl.toString());
        }
        return ret;
    }

    public List<PlaceholderString> getLoreRaw() {
        return this.lore;
    }

    public boolean addEnchantment(String in) {
        try {
            PlaceholderInt enchLevel;
            String[] split = in.contains(":") ? in.split(":") : in.split(" ");
            Enchantment ench = Enchantment.getByName((String)split[0]);
            PlaceholderInt placeholderInt = enchLevel = split.length > 1 ? PlaceholderInt.of(split[1]) : PlaceholderInt.of("1");
            if (ench == null) {
                MythicLogger.errorItemConfig(this, this.config, "Enchantment '" + split[0] + "' not found");
                return false;
            }
            this.enchantments.put(ench, enchLevel);
            return true;
        }
        catch (Error | Exception ex) {
            MythicLogger.errorItemConfig(this, this.config, "Could not apply enchantment");
            MythicLogger.handleMinorError(ex);
            return false;
        }
    }

    public AbstractItemStack generateItemStack(int amount) {
        return this.generateItemStack(new DropMetadataImpl(null, null), amount);
    }

    @Deprecated
    public AbstractItemStack generateItemStack(int amount, AbstractEntity dropper, AbstractEntity trigger) {
        SkillCaster d = MythicItem.getPlugin().getSkillManager().getCasterNullable(dropper);
        return this.generateItemStack(new DropMetadataImpl(d, trigger), amount);
    }

    public AbstractItemStack generateItemStack(DropMetadata meta, int amount) {
        BukkitItemStack bukkit;
        int durability;
        int repairCost;
        if (this.imported) {
            return this.cachedBaseItem.copy();
        }
        AbstractEntity dropper = Optional.ofNullable(meta).flatMap(m4 -> m4.getDropper().map(SkillCaster::getEntity)).orElse(null);
        AbstractItemStack itemStack = this.cachedBaseItem.copy().amount(this.cachedBaseItem.getAmount() * amount);
        if (this.customModelData != -1) {
            itemStack.modelData(this.customModelData);
        }
        if (this.unbreakable) {
            itemStack.breakable(false);
        }
        if (!this.placeOptions.isEmpty()) {
            itemStack.canPlaceOn(this.placeOptions.stream().map(it -> Material.valueOf((String)it.toUpperCase(Locale.ROOT))).toList());
        }
        if (!this.breakOptions.isEmpty()) {
            itemStack.canBreak(this.breakOptions.stream().map(it -> Material.valueOf((String)it.toUpperCase(Locale.ROOT))).toList());
        }
        int n = repairCost = !this.config.getBoolean("Options.Repairable", true) ? Integer.MAX_VALUE : this.config.getInteger("RepairCost", -1);
        if (repairCost != -1) {
            itemStack.repairCost(repairCost);
        }
        if (this.maxStackSize > 0) {
            itemStack.maxStackSize(this.maxStackSize);
        }
        if (this.displayName != null) {
            itemStack.name(Text.parse(this.displayName));
        }
        if (this.lore != null && !this.lore.isEmpty()) {
            ArrayList<Component> loreBuilder = new ArrayList<Component>();
            for (PlaceholderString pl : this.lore) {
                String str = pl.get(meta);
                if ((str = SkillString.parseMessageSpecialChars(str)).contains("{")) {
                    Matcher pMatcher = Patterns.LoreRanges.matcher(str);
                    while (pMatcher.find()) {
                        int min2 = Integer.parseInt(pMatcher.group(1));
                        int max = Integer.parseInt(pMatcher.group(2));
                        int num = Numbers.randomInt(max - min2) + min2;
                        str = str.replace(pMatcher.group(0), "" + num);
                    }
                }
                loreBuilder.add(Text.parse(str));
            }
            itemStack.lore(loreBuilder);
        }
        if (this.preventStacking) {
            itemStack.unstackable();
        }
        itemStack.customData(CompoundTagBuilder.create().putAll(this.itemOptions).putAll(this.itemNBT).build());
        if (!this.itemAttributes.isEmpty()) {
            this.itemAttributes.forEach(attr -> itemStack.addAttributeModifier((AbstractAttributeModifier)attr));
        }
        if (this.appendType.booleanValue()) {
            itemStack.customData("MYTHIC_TYPE", new StringTag(this.mythicTypeOverride));
        }
        if (this.itemVersion > 0) {
            itemStack.customData("MYTHIC_ITEM_VERSION", new IntTag(this.itemVersion));
        }
        if (!this.maxDurability.isStaticallyEqualTo(0)) {
            itemStack.maxDurability(this.maxDurability.get(meta, dropper));
        }
        if ((durability = this.durability.get(meta, Optional.ofNullable(meta).flatMap(DropMetadata::getCause).orElse(null))) > 0) {
            itemStack.durability(Numbers.clamp(durability, 1, itemStack.getMaxDurability()));
        }
        if (this.player != null) {
            itemStack.skullOwner(this.player, this.skinUUID);
        } else if (this.skinTexture != null || this.skinURL != null) {
            itemStack.skullTexture(this.skinUUID, this.skinTexture, this.skinURL);
        }
        if (itemStack instanceof BukkitItemStack) {
            bukkit = (BukkitItemStack)itemStack;
            if (!this.bannerLayers.isEmpty()) {
                bukkit.editMeta(m4 -> this.buildBanner((ItemMeta)m4, meta));
            }
            if (this.material == Material.SHIELD) {
                bukkit.editMeta(m4 -> this.buildShield((ItemMeta)m4, meta));
            }
            bukkit.editMeta(m4 -> this.buildBook((ItemMeta)m4, meta));
            bukkit.editMeta(m4 -> this.buildPotion((ItemMeta)m4, meta));
            if (this.material == Material.FIREWORK_ROCKET) {
                bukkit.editMeta(this::buildFirework);
            }
            if (this.material == Material.FIREWORK_STAR) {
                bukkit.editMeta(this::buildFireworkCharge);
            }
            if (this.data > 0) {
                bukkit.editMeta(MapMeta.class, m4 -> {
                    m4.setMapId((int)this.data);
                    m4.setMapView(Bukkit.getMap((int)this.data));
                });
            }
            if (this.color != null) {
                bukkit.editMeta(m4 -> this.setLeatherColor((ItemMeta)m4, meta));
            }
            if (this.armorTrim != null) {
                bukkit.editMeta(m4 -> this.applyArmorTrim((ItemMeta)m4, meta));
            }
        }
        if (itemStack instanceof ItemComponentBukkitItemStack) {
            bukkit = (ItemComponentBukkitItemStack)itemStack;
            if (this.rarity != null) {
                ((ItemComponentBukkitItemStack)bukkit).rarity(this.rarity);
            }
            if (this.fireResistant != null) {
                ((ItemComponentBukkitItemStack)bukkit).fireResistant(this.fireResistant);
            }
        }
        if (this.enchantments != null) {
            this.setEnchantments(dropper, itemStack);
        }
        if (!this.hideOptions.isEmpty()) {
            itemStack.flags(this.hideOptions.stream().map(AbstractItemFlag::valueOf).toList());
        }
        if (this.hideFlags) {
            itemStack.hideAll();
        }
        ItemStack stack = BukkitAdapter.adapt(itemStack);
        MythicMobItemGenerateEvent generateEvent = new MythicMobItemGenerateEvent(this, meta, stack);
        Events.callSync(generateEvent);
        return BukkitAdapter.adapt(generateEvent.getItemStack());
    }

    private void setEnchantments(AbstractEntity entity, AbstractItemStack itemStack) {
        if (this.enchantments == null || this.enchantments.isEmpty()) {
            return;
        }
        int enchantmentCount = Optional.ofNullable(entity).map(this.maxEnchantments::get).orElseGet(this.maxEnchantments::get);
        ArrayList enchantsToApply = Lists.newArrayList(this.enchantments.keySet());
        if (enchantmentCount > 0) {
            Collections.shuffle(enchantsToApply);
        } else {
            enchantmentCount = enchantsToApply.size();
        }
        for (int i = 0; i < enchantmentCount; ++i) {
            Enchantment enchant = (Enchantment)enchantsToApply.get(i);
            int enchantLevel = this.enchantments.get(enchant).get(entity);
            if (enchantLevel == 0) continue;
            this.applyEnchantToItem(itemStack, enchant, enchantLevel);
        }
    }

    private void applyEnchantToItem(AbstractItemStack itemStack, Enchantment enchant, int enchantLevel) {
        MythicApplyEnchantEvent event = new MythicApplyEnchantEvent(BukkitAdapter.adapt(itemStack), enchant, enchantLevel);
        Events.callAndReturn(event);
        if (event.getWasHandled().booleanValue()) {
            return;
        }
        itemStack.enchant(enchant, enchantLevel);
    }

    private void buildPotion(ItemMeta im, DropMetadata dropMetadata) {
        if (!(im instanceof PotionMeta)) {
            return;
        }
        PotionMeta pm = (PotionMeta)im;
        if (this.color != null) {
            try {
                pm.setColor(this.color.get(dropMetadata).toBukkitColor());
            }
            catch (Exception ex) {
                MythicLogger.errorItemConfig(this, this.config, "Potion color is configured incorrectly");
            }
        }
        if (this.potionEffects != null) {
            pm.clearCustomEffects();
            for (String s2 : this.potionEffects) {
                try {
                    String[] sp = s2.split(" ");
                    if (sp.length < 3) {
                        MythicLogger.errorItemConfig(this, this.config, "A potion effect is configured incorrectly. Format is 'EFFECT DURATION LEVEL'. Line=" + s2);
                        continue;
                    }
                    PotionEffectType pet = PotionEffectType.getByName((String)sp[0].toUpperCase());
                    int duration = Integer.parseInt(sp[1]);
                    int level = Integer.parseInt(sp[2]);
                    PotionEffect p = new PotionEffect(pet, duration, level - 1, true);
                    pm.addCustomEffect(p, false);
                }
                catch (Exception ex) {
                    MythicLogger.errorItemConfig(this, this.config, "A potion effect is configured incorrectly. Format is 'EFFECT DURATION LEVEL'. Line=" + s2);
                }
            }
        }
    }

    private void buildFirework(ItemMeta im) {
        int b;
        int g2;
        int r;
        String[] rgb;
        if (!(im instanceof FireworkMeta)) {
            return;
        }
        FireworkMeta pm = (FireworkMeta)im;
        FireworkEffect.Builder builder = FireworkEffect.builder();
        if (this.fireworkColors != null) {
            for (String s2 : this.fireworkColors) {
                try {
                    rgb = s2.split(",");
                    r = Integer.parseInt(rgb[0]);
                    g2 = Integer.parseInt(rgb[1]);
                    b = Integer.parseInt(rgb[2]);
                    builder.withColor(Color.fromRGB((int)r, (int)g2, (int)b));
                }
                catch (Exception ex) {
                    MythicLogger.errorItemConfig(this, this.config, "A firework color is configured incorrectly. Format is 'red,green,blue'. Line=" + s2);
                }
            }
        }
        if (this.fireworkFadeColors != null) {
            for (String s2 : this.fireworkFadeColors) {
                try {
                    rgb = s2.split(",");
                    r = Integer.parseInt(rgb[0]);
                    g2 = Integer.parseInt(rgb[1]);
                    b = Integer.parseInt(rgb[2]);
                    builder.withColor(Color.fromRGB((int)r, (int)g2, (int)b));
                }
                catch (Exception ex) {
                    MythicLogger.errorItemConfig(this, this.config, "A firework fade color is configured incorrectly. Format is 'red,green,blue'. Line=" + s2);
                }
            }
        }
        if (this.config.getBoolean("Firework.Flicker", false)) {
            builder.withFlicker();
        }
        if (this.config.getBoolean("Firework.Trail", false)) {
            builder.withTrail();
        }
        pm.addEffect(builder.build());
    }

    private void buildFireworkCharge(ItemMeta im) {
        int b;
        int g2;
        int r;
        String[] rgb;
        if (!(im instanceof FireworkEffectMeta)) {
            return;
        }
        FireworkEffectMeta pm = (FireworkEffectMeta)im;
        FireworkEffect.Builder builder = FireworkEffect.builder();
        if (this.fireworkColors != null) {
            for (String s2 : this.fireworkColors) {
                try {
                    rgb = s2.split(",");
                    r = Integer.parseInt(rgb[0]);
                    g2 = Integer.parseInt(rgb[1]);
                    b = Integer.parseInt(rgb[2]);
                    builder.withColor(Color.fromRGB((int)r, (int)g2, (int)b));
                }
                catch (Exception ex) {
                    MythicLogger.errorItemConfig(this, this.config, "A firework color is configured incorrectly. Format is 'red,green,blue'. Line=" + s2);
                }
            }
        }
        if (this.fireworkFadeColors != null) {
            for (String s2 : this.fireworkFadeColors) {
                try {
                    rgb = s2.split(",");
                    r = Integer.parseInt(rgb[0]);
                    g2 = Integer.parseInt(rgb[1]);
                    b = Integer.parseInt(rgb[2]);
                    builder.withColor(Color.fromRGB((int)r, (int)g2, (int)b));
                }
                catch (Exception ex) {
                    MythicLogger.errorItemConfig(this, this.config, "A firework fade color is configured incorrectly. Format is 'red,green,blue'. Line=" + s2);
                }
            }
        }
        if (this.config.getBoolean("Firework.Flicker", false)) {
            builder.withFlicker();
        }
        if (this.config.getBoolean("Firework.Trail", false)) {
            builder.withTrail();
        }
        pm.setEffect(builder.build());
    }

    private void buildBanner(ItemMeta im, DropMetadata dropMetadata) {
        if (!(im instanceof BannerMeta)) {
            return;
        }
        BannerMeta pm = (BannerMeta)im;
        if (this.color != null) {
            try {
                Pattern pattern = new Pattern(this.color.get(dropMetadata).toBukkitDyeColor(), PatternType.BASE);
                pm.addPattern(pattern);
            }
            catch (Exception ex) {
                MythicLogger.errorItemConfig(this, this.config, "A banner color is configured incorrectly, must use a color from the Bukkit DyeColor ENUM.");
            }
        }
        if (this.bannerLayers != null) {
            for (String s2 : this.bannerLayers) {
                try {
                    String[] sp = s2.split(" ");
                    if (sp.length < 2) {
                        MythicLogger.errorItemConfig(this, this.config, "A banner layer is configured incorrectly. Format is 'COLOR PATTERN'. Line=" + s2);
                        continue;
                    }
                    DyeColor dc = DyeColor.valueOf((String)sp[0].toUpperCase());
                    PatternType pt = PatternType.valueOf((String)sp[1]);
                    Pattern p = new Pattern(dc, pt);
                    pm.addPattern(p);
                }
                catch (Exception ex) {
                    MythicLogger.errorItemConfig(this, this.config, "A banner layer is configured incorrectly. Format is 'COLOR PATTERN'. Line=" + s2);
                }
            }
        }
    }

    private void buildShield(ItemMeta im, DropMetadata dropMetadata) {
        if (!(im instanceof BlockStateMeta)) {
            return;
        }
        BlockStateMeta pm = (BlockStateMeta)im;
        if (this.shieldColor == null && this.bannerLayers.isEmpty()) {
            return;
        }
        BlockState blockState = pm.getBlockState();
        if (!(blockState instanceof Banner)) {
            return;
        }
        Banner banner = (Banner)blockState;
        if (this.shieldColor != null) {
            try {
                banner.setBaseColor(this.shieldColor);
            }
            catch (Throwable ex) {
                MythicLogger.errorItemConfig(this, this.config, "The shield color is configured incorrectly.");
                MythicLogger.handleMinorError(ex);
            }
        }
        if (this.bannerLayers != null) {
            for (String s2 : this.bannerLayers) {
                try {
                    String[] sp = s2.split(" ");
                    if (sp.length < 2) {
                        MythicLogger.errorItemConfig(this, this.config, "A shield banner layer is configured incorrectly. Format is 'COLOR PATTERN'. Line=" + s2);
                        continue;
                    }
                    DyeColor dc = DyeColor.valueOf((String)sp[0].toUpperCase());
                    PatternType pt = PatternType.valueOf((String)sp[1]);
                    Pattern p = new Pattern(dc, pt);
                    banner.addPattern(p);
                }
                catch (Exception ex) {
                    MythicLogger.errorItemConfig(this, this.config, "A shield banner layer is configured incorrectly. Format is 'COLOR PATTERN'. Line=" + s2);
                }
            }
        }
        banner.update();
        pm.setBlockState((BlockState)banner);
    }

    private void buildBook(ItemMeta im, DropMetadata dropMetadata) {
        BookMeta bookMeta;
        block10: {
            block9: {
                if (!(im instanceof BookMeta)) break block9;
                bookMeta = (BookMeta)im;
                if (this.bookPages != null) break block10;
            }
            return;
        }
        String author = this.bookAuthor.get(dropMetadata);
        if (ServerVersion.isPaper()) {
            bookMeta.author(MiniMessage.miniMessage().deserialize((Object)author));
        } else {
            bookMeta.setAuthor(Text.toLegacy(Text.parse(author)));
        }
        String title = this.bookTitle.get(dropMetadata);
        if (ServerVersion.isPaper()) {
            bookMeta.title(MiniMessage.miniMessage().deserialize((Object)title));
        } else {
            bookMeta.setTitle(Text.toLegacy(Text.parse(title)));
        }
        for (PlaceholderString page : this.bookPages) {
            String contents = page.get(dropMetadata);
            if (ServerVersion.isPaper()) {
                bookMeta.addPages(new Component[]{MiniMessage.miniMessage().deserialize((Object)contents)});
                continue;
            }
            Component component = Text.parse(contents);
            bookMeta.addPage(new String[]{Text.toLegacy(component)});
        }
    }

    private void applyArmorTrim(ItemMeta itemMeta, DropMetadata dropMetadata) {
        if (ServerVersion.isBefore(MinecraftVersions.v1_20)) {
            return;
        }
        try {
            String pattern;
            String armorTrim = this.armorTrim.get(dropMetadata);
            String namespace = "minecraft:";
            String material = "iron";
            String[] parts = armorTrim.split(":", 2);
            if (parts.length > 1 && parts[1].contains(".")) {
                subparts = parts[1].split("\\.", 2);
                namespace = parts[0];
                material = subparts[0];
                pattern = subparts[1];
            } else if (parts.length == 1 && parts[0].contains(".")) {
                subparts = parts[0].split("\\.", 2);
                material = subparts[0];
                pattern = subparts[1];
            } else {
                pattern = armorTrim;
            }
            NamespacedKey materialKey = NamespacedKey.fromString((String)(namespace + material));
            NamespacedKey patternKey = NamespacedKey.fromString((String)(namespace + pattern));
            TrimMaterial trimMaterial = (TrimMaterial)Registry.TRIM_MATERIAL.get(materialKey);
            TrimPattern trimPattern = (TrimPattern)Registry.TRIM_PATTERN.get(patternKey);
            ArmorTrim trim = new ArmorTrim(trimMaterial, trimPattern);
            if (itemMeta instanceof ArmorMeta) {
                ArmorMeta armorMeta = (ArmorMeta)itemMeta;
                armorMeta.setTrim(trim);
            }
        }
        catch (Throwable ex) {
            MythicLogger.errorItemConfig(this, this.getConfig(), "Invalid ArmorTrim specified: " + String.valueOf(this.armorTrim));
            ex.printStackTrace();
        }
    }

    private void setLeatherColor(ItemMeta itemMeta, DropMetadata dropMetadata) {
        if (itemMeta instanceof LeatherArmorMeta) {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemMeta;
            leatherArmorMeta.setColor(this.color.get(dropMetadata).toBukkitColor());
        }
    }

    @Override
    public int compareTo(MythicItem o) {
        return this.internalName.compareTo(o.getInternalName());
    }

    @Override
    public Icon<ItemMenuContext> getIcon() {
        return IconBuilder.create().itemStack(this.cachedMenuItem).hideFlags().click((context, player) -> {
            player.performCommand("mythicmobs i get " + this.internalName);
            player.playSound(player.getLocation(), "entity.experience_orb.pickup", 1.0f, 1.0f);
        }).rightClick((context, player) -> {
            ItemEditorMenuContext ctx = new ItemEditorMenuContext(this, (ItemMenuContext)context);
            MythicItem.getPlugin().getMenuManager().getItemEditorMenu().open((Player)player, ctx);
        }).build();
    }

    public MythicConfig getConfig() {
        return this.config;
    }

    public ItemStack getCachedMenuItem() {
        return this.cachedMenuItem;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public Pack getPack() {
        return this.pack;
    }

    public File getFile() {
        return this.file;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setStrMaterial(String strMaterial) {
        this.strMaterial = strMaterial;
    }

    public Material getMaterial() {
        return this.material;
    }

    public int getCustomModelData() {
        return this.customModelData;
    }

    public void setCustomModelData(int customModelData) {
        this.customModelData = customModelData;
    }

    public int getAmount() {
        return this.amount;
    }

    public PlaceholderInt getDurability() {
        return this.durability;
    }

    public void setDurability(PlaceholderInt durability) {
        this.durability = durability;
    }

    public PlaceholderInt getMaxDurability() {
        return this.maxDurability;
    }

    public void setMaxDurability(PlaceholderInt maxDurability) {
        this.maxDurability = maxDurability;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public Boolean getFireResistant() {
        return this.fireResistant;
    }

    public void setFireResistant(Boolean fireResistant) {
        this.fireResistant = fireResistant;
    }

    public AbstractItemStackRarity getRarity() {
        return this.rarity;
    }

    public void setRarity(AbstractItemStackRarity rarity) {
        this.rarity = rarity;
    }

    public PlaceholderInt getMaxEnchantments() {
        return this.maxEnchantments;
    }

    public void setMaxEnchantments(PlaceholderInt maxEnchantments) {
        this.maxEnchantments = maxEnchantments;
    }

    public Boolean getPreventEnchanting() {
        return this.preventEnchanting;
    }

    public void setPreventEnchanting(Boolean preventEnchanting) {
        this.preventEnchanting = preventEnchanting;
    }

    public Boolean getPreventAnvilWith() {
        return this.preventAnvilWith;
    }

    public void setPreventAnvilWith(Boolean preventAnvilWith) {
        this.preventAnvilWith = preventAnvilWith;
    }

    public Boolean getPreventCraftingWith() {
        return this.preventCraftingWith;
    }

    public void setPreventCraftingWith(Boolean preventCraftingWith) {
        this.preventCraftingWith = preventCraftingWith;
    }

    public Boolean getPreventSmithingWith() {
        return this.preventSmithingWith;
    }

    public void setPreventSmithingWith(Boolean preventSmithingWith) {
        this.preventSmithingWith = preventSmithingWith;
    }

    public PlaceholderColor getDropColor() {
        return this.dropColor;
    }

    public void setDropColor(PlaceholderColor dropColor) {
        this.dropColor = dropColor;
    }

    public PlaceholderColor getColor() {
        return this.color;
    }

    public void setColor(PlaceholderColor color) {
        this.color = color;
    }

    public DyeColor getShieldColor() {
        return this.shieldColor;
    }

    public void setShieldColor(DyeColor shieldColor) {
        this.shieldColor = shieldColor;
    }

    public PlaceholderString getArmorTrim() {
        return this.armorTrim;
    }

    public void setArmorTrim(PlaceholderString armorTrim) {
        this.armorTrim = armorTrim;
    }

    public String getPlayer() {
        return this.player;
    }

    public String getSkinURL() {
        return this.skinURL;
    }

    public String getSkinTexture() {
        return this.skinTexture;
    }

    public UUID getSkinUUID() {
        return this.skinUUID;
    }

    public Optional<String> getLoreTemplate() {
        return this.loreTemplate;
    }

    public void setLore(List<PlaceholderString> lore) {
        this.lore = lore;
    }

    public Map<Enchantment, PlaceholderInt> getEnchantments() {
        return this.enchantments;
    }

    public void setEnchantments(Map<Enchantment, PlaceholderInt> enchantments) {
        this.enchantments = enchantments;
    }

    public PlaceholderString getBookAuthor() {
        return this.bookAuthor;
    }

    public void setBookAuthor(PlaceholderString bookAuthor) {
        this.bookAuthor = bookAuthor;
    }

    public PlaceholderString getBookTitle() {
        return this.bookTitle;
    }

    public void setBookTitle(PlaceholderString bookTitle) {
        this.bookTitle = bookTitle;
    }

    public List<PlaceholderString> getBookPages() {
        return this.bookPages;
    }

    public void setBookPages(List<PlaceholderString> bookPages) {
        this.bookPages = bookPages;
    }

    public List<String> getPotionEffects() {
        return this.potionEffects;
    }

    public void setPotionEffects(List<String> potionEffects) {
        this.potionEffects = potionEffects;
    }

    public List<String> getBannerLayers() {
        return this.bannerLayers;
    }

    public void setBannerLayers(List<String> bannerLayers) {
        this.bannerLayers = bannerLayers;
    }

    public List<String> getFireworkColors() {
        return this.fireworkColors;
    }

    public void setFireworkColors(List<String> fireworkColors) {
        this.fireworkColors = fireworkColors;
    }

    public List<String> getFireworkFadeColors() {
        return this.fireworkFadeColors;
    }

    public void setFireworkFadeColors(List<String> fireworkFadeColors) {
        this.fireworkFadeColors = fireworkFadeColors;
    }

    public Map<String, Tag> getItemNBT() {
        return this.itemNBT;
    }

    public List<String> getHideOptions() {
        return this.hideOptions;
    }

    public boolean isUnbreakable() {
        return this.unbreakable;
    }

    public boolean isHideFlags() {
        return this.hideFlags;
    }

    public String getMythicTypeOverride() {
        return this.mythicTypeOverride;
    }

    public void setMythicTypeOverride(String mythicTypeOverride) {
        this.mythicTypeOverride = mythicTypeOverride;
    }

    public Boolean getAppendType() {
        return this.appendType;
    }

    public void setAppendType(Boolean appendType) {
        this.appendType = appendType;
    }

    public boolean isPreventStacking() {
        return this.preventStacking;
    }

    public int getItemVersion() {
        return this.itemVersion;
    }

    public boolean isPreserveStatRatioOnUpdate() {
        return this.preserveStatRatioOnUpdate;
    }

    public String getDropGlowColor() {
        return this.dropGlowColor;
    }

    public Chroma getDropBeamColor() {
        return this.dropBeamColor;
    }

    public boolean isDropGlow() {
        return this.dropGlow;
    }

    public boolean isDropBeam() {
        return this.dropBeam;
    }

    public Map<SkillTrigger<?>, Queue<SkillMechanic>> getDropSkills() {
        return this.dropSkills;
    }
}

