/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.items;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.items.ItemManager;
import io.lumine.mythic.api.items.ItemSupplier;
import io.lumine.mythic.api.packs.Pack;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.config.properties.types.NodeListProp;
import io.lumine.mythic.bukkit.utils.files.Files;
import io.lumine.mythic.bukkit.utils.items.ItemFactory;
import io.lumine.mythic.bukkit.utils.lib.lang3.text.WordUtils;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.config.IOHandler;
import io.lumine.mythic.core.config.IOLoader;
import io.lumine.mythic.core.config.MythicConfigImpl;
import io.lumine.mythic.core.items.ItemGroup;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.utils.TemplateUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class ItemExecutor
extends ReloadableModule<MythicBukkit>
implements ItemManager,
Listener {
    private List<File> itemFiles;
    private IOLoader<MythicBukkit> defaultItems;
    private List<IOLoader<MythicBukkit>> itemLoaders;
    private Map<String, MythicItem> items = Maps.newConcurrentMap();
    private Map<String, ItemGroup> groups = Maps.newConcurrentMap();
    private Map<String, ItemSupplier> itemSuppliers = new ConcurrentHashMap<String, ItemSupplier>();

    public ItemExecutor(MythicBukkit plugin) {
        super(plugin, false);
    }

    @Override
    public void load(MythicBukkit plugin) {
        this.loadPredefinedItemGroups(plugin);
        this.loadItems(plugin);
        this.loadItemGroups(plugin);
    }

    @Override
    public void unload() {
        this.itemFiles = null;
        this.defaultItems = null;
        this.itemLoaders = null;
        this.groups.clear();
        this.items.clear();
    }

    private void loadItems(MythicBukkit plugin) {
        MythicLogger.log("Loading Items...");
        this.defaultItems = new IOLoader<MythicBukkit>(MythicBukkit.inst(), "ExampleItems.yml", "Items");
        this.itemFiles = IOHandler.getAllFiles(this.defaultItems.getFile().getParent());
        this.items.clear();
        ArrayList itemsUsingTemplates = Lists.newArrayList();
        for (Pack pack : plugin.getPackManager().getPacks()) {
            for (File folder : pack.getPackFolders("Items", true)) {
                for (File file : Files.getAll(folder.getAbsolutePath(), Lists.newArrayList((Object[])new String[]{"yml", "txt"}))) {
                    MythicConfigImpl fileConfig = new MythicConfigImpl(file);
                    for (String node : NodeListProp.getNodes(file, "")) {
                        try {
                            MythicConfig config = fileConfig.getNestedConfig(node);
                            String maybeTemplate = config.getString("Template");
                            if (maybeTemplate == null) {
                                maybeTemplate = config.getString("Templates");
                            }
                            if (maybeTemplate != null) {
                                itemsUsingTemplates.add(new TemplateUtil.TemplateItem(pack, file, node, config, maybeTemplate));
                                continue;
                            }
                            MythicItem mi = new MythicItem(pack, file, node, config);
                            pack.addItem();
                            this.registerItem(node, mi);
                        }
                        catch (Error | Exception ex) {
                            MythicLogger.error("Error loading item '" + node + "'. Enable debugging for a stack trace.");
                            if (((MythicBukkit)this.getPlugin()).getConfiguration().getDebugLevel() <= 0) continue;
                            ex.printStackTrace();
                        }
                    }
                }
            }
        }
        TemplateUtil.handleTemplates(itemsUsingTemplates);
    }

    private void loadPredefinedItemGroups(MythicBukkit plugin) {
        this.groups.put("OTHER", new ItemGroup("OTHER", "Other", ItemFactory.of(Material.IRON_SWORD)));
    }

    private void loadItemGroups(MythicBukkit plugin) {
        MythicLogger.log("Loading Item Groups...");
        for (MythicItem item : this.items.values()) {
            String group = item.getGroup();
            group = group == null ? "OTHER" : group.toUpperCase();
            if (this.groups.containsKey(group)) continue;
            this.groups.put(group, new ItemGroup(group, WordUtils.capitalizeFully(group), ItemFactory.of(item.getMaterial()).model(item.getCustomModelData())));
        }
    }

    @Override
    public Collection<MythicItem> getItems() {
        return Collections.unmodifiableCollection(this.items.values());
    }

    @Override
    public Collection<String> getItemNames() {
        return Collections.unmodifiableCollection(this.items.keySet());
    }

    public Collection<ItemGroup> getItemGroups() {
        return this.groups.values();
    }

    public Collection<String> getItemGroupNames() {
        return this.groups.keySet();
    }

    @Override
    public Optional<MythicItem> getItem(String name) {
        return Optional.ofNullable(this.items.getOrDefault(name, null));
    }

    @Override
    public String getMythicTypeFromItem(ItemStack item) {
        if (!this.isMythicItem(item)) {
            return null;
        }
        return ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getItemHandler().getNBTData(item).getString("MYTHIC_TYPE");
    }

    @Override
    public boolean isMythicItem(ItemStack item) {
        return ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getItemHandler().getNBTData(item).containsKey("MYTHIC_TYPE");
    }

    @Override
    public void registerItemSupplier(ItemSupplier supplier) {
        this.itemSuppliers.put(supplier.getNamespace().toLowerCase(), supplier);
    }

    public boolean isMMOItem(ItemStack item) {
        return ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getItemHandler().getNBTData(item).containsKey("MMOITEMS_ITEM_ID");
    }

    public boolean hasCustomDurability(ItemStack item) {
        return ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getItemHandler().getNBTData(item).containsKey("MYTHIC_MAX_CUSTOM_DURABILITY");
    }

    public int getMaxCustomDurability(ItemStack item) {
        return ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getItemHandler().getNBTData(item).getInt("MYTHIC_MAX_CUSTOM_DURABILITY");
    }

    public int getCurrentCustomDurability(ItemStack item) {
        return ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getItemHandler().getNBTData(item).getInt("MYTHIC_CURRENT_CUSTOM_DURABILITY");
    }

    public boolean getEnchantingDisabled(ItemStack item) {
        return ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getItemHandler().getNBTData(item).getByte("PreventEnchanting") == 1;
    }

    public boolean getAnvilDisabled(ItemStack item) {
        return ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getItemHandler().getNBTData(item).getByte("PreventAnvil") == 1;
    }

    public boolean getCraftingDisabled(ItemStack item) {
        return ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getItemHandler().getNBTData(item).getByte("PreventCrafting") == 1;
    }

    public boolean getSmithingDisabled(ItemStack item) {
        return ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getItemHandler().getNBTData(item).getByte("PreventSmithing") == 1;
    }

    public ItemStack getItemStack(String name) {
        return this.getItemStack(name, 1);
    }

    public ItemStack getItemStack(String name, int amount) {
        Optional<MythicItem> maybeItem = MythicBukkit.inst().getItemManager().getItem(name);
        if (maybeItem.isPresent()) {
            return BukkitAdapter.adapt(maybeItem.get().generateItemStack(amount));
        }
        try {
            return new ItemStack(Material.valueOf((String)name.toUpperCase()));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean registerItem(String internalName, MythicItem item) {
        if (this.items.containsKey(internalName)) {
            return false;
        }
        this.items.put(internalName, item);
        return true;
    }

    public void deleteItem(MythicItem item) {
        MythicLogger.log("Deleting MythicItem: {0}", item.getInternalName());
        this.items.remove(item.getInternalName());
        item.getConfig().deleteNodeAndSave();
    }

    public String getItemAttribute(String input) {
        String attribute;
        if (ServerVersion.isBeforeOrEq(MinecraftVersions.v1_15)) {
            attribute = switch (input.toUpperCase()) {
                case "DAMAGE", "ATTACK_DAMAGE", "ATTACKDAMAGE" -> "generic.attackDamage";
                case "HEALTH", "MAX_HEALTH", "MAXHEALTH", "HP" -> "generic.maxHealth";
                case "MOVEMENT_SPEED", "MOVEMENTSPEED", "MOVESPEED", "RUNSPEED", "RUN_SPEED" -> "generic.movementSpeed";
                case "ATTACK_SPEED", "ATTACKSPEED", "WEAPON_SPEED", "WEAPONSPEED" -> "generic.attackSpeed";
                case "KNOCKBACK", "ATTACKKNOCKBACK", "ATTACK_KNOCKBACK" -> "generic.attackKnockback";
                case "KNOCKBACK_RESISTANCE", "KNOCKBACKRESISTANCE", "KNOCKBACKRESIST" -> "generic.knockbackResistance";
                case "ARMOR" -> "generic.armor";
                case "ARMOR_TOUGHNESS", "TOUGHNESS", "ARMORTOUGHNESS" -> "generic.armorToughness";
                case "LUCK" -> "generic.luck";
                default -> input;
            };
        } else {
            attribute = switch (input.toUpperCase()) {
                case "DAMAGE", "ATTACK_DAMAGE", "ATTACKDAMAGE" -> "generic.attack_damage";
                case "HEALTH", "MAX_HEALTH", "MAXHEALTH", "HP" -> "generic.max_health";
                case "MOVEMENTSPEED", "MOVEMENT_SPEED", "MOVESPEED", "RUNSPEED", "RUN_SPEED" -> "generic.movement_speed";
                case "ATTACKSPEED", "ATTACK_SPEED", "WEAPON_SPEED", "WEAPONSPEED" -> "generic.attack_speed";
                case "KNOCKBACK", "ATTACKKNOCKBACK", "ATTACK_KNOCKBACK" -> "generic.attack_knockback";
                case "KNOCKBACKRESISTANCE", "KNOCKBACK_RESISTANCE", "KNOCKBACKRESIST" -> "generic.knockback_resistance";
                case "ARMOR" -> "generic.armor";
                case "ARMORTOUGHNESS", "ARMOR_TOUGHNESS", "TOUGHNESS" -> "generic.armor_toughness";
                case "LUCK" -> "generic.luck";
                case "MAXABSORPTION", "MAX_ABSORPTION" -> "generic.max_absorption";
                case "SCALE" -> "generic.scale";
                case "STEPHEIGHT", "STEP_HEIGHT" -> "generic.step_height";
                case "JUMPHEIGHT", "JUMP_HEIGHT" -> "generic.jump_height";
                case "BLOCKINTERACTIONRANGE", "BLOCK_INTERACTION_RANGE" -> "player.block_interaction_range";
                case "ENTITYINTERACTIONRANGE", "ENTITY_INTERACTION_RANGE" -> "player.entity_interaction_range";
                case "BLOCKBREAKSPEED", "BLOCK_BREAK_SPEED" -> "player.block_break_speed";
                case "GRAVITY" -> "generic.gravity";
                case "SAFEFALLDISTANCE", "SAFE_FALL_DISTANCE" -> "generic.safe_fall_distance";
                case "FALLDAMAGEMULTIPLIER", "FALL_DAMAGE_MULTIPLIER" -> "generic.fall_damage_multiplier";
                default -> input;
            };
        }
        return attribute;
    }

    @Override
    public Collection<MythicItem> filterItems(Collection<MythicItem> items, String ffilter) {
        String filter = ffilter.toUpperCase();
        items.removeIf(mi -> {
            boolean remove = true;
            if (mi.getInternalName().toUpperCase().contains(filter)) {
                remove = false;
            } else if (mi.getDisplayName() != null && mi.getDisplayName().toUpperCase().contains(filter)) {
                remove = false;
            }
            return remove;
        });
        return items;
    }
}

