/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.holograms;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.holograms.HologramProvider;
import io.lumine.mythic.api.holograms.IHologram;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.volatilecode.virtual.PacketTextDisplay;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.compatibility.CompatibilityManager;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.logging.ConsoleColor;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.holograms.DisplayHologramProvider;
import io.lumine.mythic.core.holograms.types.CastBar;
import io.lumine.mythic.core.holograms.types.HealthBar;
import io.lumine.mythic.core.holograms.types.Nameplate;
import io.lumine.mythic.core.holograms.types.SpeechBubble;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.mechanics.CastMechanic;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;

public class HologramManager
extends ReloadableModule<MythicBukkit> {
    private final CompatibilityManager compat;
    private HologramProvider provider;
    private Map<Integer, Collection<Integer>> attachedHolograms = Maps.newConcurrentMap();

    public HologramManager(MythicBukkit core, CompatibilityManager compat) {
        super(core);
        this.compat = compat;
    }

    @Override
    public void load(MythicBukkit plugin) {
        Schedulers.sync().runLater(() -> this.initialize(), 1L);
    }

    @Override
    public void unload() {
    }

    private void initialize() {
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_19_4)) {
            this.provider = new DisplayHologramProvider(this);
        } else if (this.compat.getHolograms().isPresent()) {
            MythicLogger.log(String.valueOf((Object)ConsoleColor.GREEN) + String.valueOf((Object)ConsoleColor.CHECK_MARK) + "Using Holograms plugin for holograms");
            this.provider = this.compat.getHolograms().get();
        } else if (this.compat.getHolographicDisplays().isPresent()) {
            MythicLogger.log(String.valueOf((Object)ConsoleColor.GREEN) + String.valueOf((Object)ConsoleColor.CHECK_MARK) + "Using HolographicDisplays plugin for holograms");
            this.provider = this.compat.getHolographicDisplays().get();
        }
    }

    public boolean isActive() {
        return this.provider != null;
    }

    public IHologram createHologram(String name, AbstractLocation location) {
        return this.provider == null ? null : this.provider.createHologram(name, location, " ");
    }

    public IHologram createHologram(String name, AbstractLocation location, String text) {
        return this.provider == null ? null : this.provider.createHologram(name, location, text);
    }

    public IHologram createHologram(AbstractEntity entity, PacketTextDisplay.PacketTextDisplayBuilder options) {
        return this.provider == null ? null : this.provider.createHologram(entity, " ", options);
    }

    public IHologram createHologram(Supplier<Collection<AbstractPlayer>> audience, AbstractEntity entity, String s2, PacketTextDisplay.PacketTextDisplayBuilder options) {
        return this.provider == null ? null : this.provider.createHologram(audience, entity, " ", options);
    }

    public IHologram createHologram(Supplier<Collection<AbstractPlayer>> audience, AbstractLocation location, String s2, PacketTextDisplay.PacketTextDisplayBuilder options) {
        return this.provider == null ? null : this.provider.createHologram(audience, location, " ", options);
    }

    public IHologram createHologram(AbstractEntity entity, String text, PacketTextDisplay.PacketTextDisplayBuilder options) {
        return this.provider == null ? null : this.provider.createHologram(entity, text, options);
    }

    public IHologram createHologram(AbstractLocation location, String text, PacketTextDisplay.PacketTextDisplayBuilder options) {
        return this.provider == null ? null : this.provider.createHologram(location, text, options);
    }

    public Nameplate createNameplate(ActiveMob activeMob) {
        return this.provider == null ? null : new Nameplate(this, activeMob);
    }

    public HealthBar createHealthBar(ActiveMob activeMob) {
        return this.provider == null ? null : new HealthBar(this, activeMob);
    }

    public SpeechBubble createSpeechBubble(SkillCaster skillCaster, Supplier<Collection<AbstractPlayer>> audience, PacketTextDisplay.PacketTextDisplayBuilder options) {
        return this.provider == null ? null : new SpeechBubble(this, skillCaster, audience, options);
    }

    public CastBar createCastBar(CastMechanic.CastTracker castTracker, String castingText) {
        return this.provider == null ? null : new CastBar(this, castTracker, castingText);
    }

    public void registerAttachedHologram(int entity, int hologram) {
        Collection collection = this.attachedHolograms.computeIfAbsent(entity, x -> Sets.newConcurrentHashSet());
        collection.add(hologram);
    }

    public void unregisterAttachedHologram(int entity, int hologram) {
        Collection<Integer> collection = this.attachedHolograms.get(entity);
        if (collection != null) {
            collection.remove(hologram);
            if (collection.isEmpty()) {
                this.attachedHolograms.remove(entity);
            }
        }
    }

    public Collection<Integer> getAttachedHolograms(int vehicleId) {
        return this.attachedHolograms.getOrDefault(vehicleId, null);
    }
}

