/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.drops.droppables;

import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.api.drops.IItemDrop;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.serialize.Chroma;
import io.lumine.mythic.core.drops.droppables.ItemDrop;
import io.lumine.mythic.core.glow.GlowColor;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.core.logging.MythicLogger;

public class MythicItemDrop
extends ItemDrop
implements IItemDrop {
    private final MythicItem item;
    protected PlaceholderDouble level;

    public MythicItemDrop(String line, String item, MythicLineConfig config) {
        super(line, config);
        Chroma beamColor;
        this.item = MythicBukkit.inst().getItemManager().getItem(item).get();
        this.level = config.getPlaceholderDouble(new String[]{"level", "lvl", "l"}, (PlaceholderDouble)null, new String[0]);
        String glowColor = config.getString(new String[]{"itemglowcolor", "glowcolor", "gc"}, this.item.getDropGlowColor(), new String[0]);
        if (glowColor != null) {
            try {
                this.itemGlow = GlowColor.valueOf(glowColor);
            }
            catch (Throwable ex) {
                MythicLogger.errorDropConfig(this, config, "Invalid ItemGlow Color specified");
                ex.printStackTrace();
            }
        }
        if ((beamColor = config.getColor(new String[]{"itembeamcolor", "beamColor", "bc"}, this.item.getDropBeamColor())) != null) {
            try {
                this.itemBeam = beamColor;
            }
            catch (Throwable ex) {
                MythicLogger.errorDropConfig(this, config, "Invalid BeamColor Color specified");
            }
        }
    }

    @Override
    public AbstractItemStack getDrop(DropMetadata meta, double amount) {
        if (this.level != null) {
            meta = meta.clone();
            meta.setLevel(this.level.get(meta));
        }
        return this.item.generateItemStack(meta, (int)amount);
    }

    public MythicItem getItem() {
        return this.item;
    }

    public PlaceholderDouble getLevel() {
        return this.level;
    }
}

