/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.drops;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.drops.DropManager;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.api.drops.ICommandDrop;
import io.lumine.mythic.api.drops.IDrop;
import io.lumine.mythic.api.drops.IIntangibleDrop;
import io.lumine.mythic.api.drops.IItemDrop;
import io.lumine.mythic.api.drops.ILocationDrop;
import io.lumine.mythic.api.drops.IMessagingDrop;
import io.lumine.mythic.api.packs.Pack;
import io.lumine.mythic.api.volatilecode.virtual.PacketEntity;
import io.lumine.mythic.api.volatilecode.virtual.PacketEntityRenderer;
import io.lumine.mythic.api.volatilecode.virtual.PacketItemDisplay;
import io.lumine.mythic.api.volatilecode.virtual.PacketTextDisplay;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitParticle;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.items.ItemFactory;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.bukkit.utils.serialize.Chroma;
import io.lumine.mythic.bukkit.utils.text.Text;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.config.IOHandler;
import io.lumine.mythic.core.config.IOLoader;
import io.lumine.mythic.core.config.MythicConfigImpl;
import io.lumine.mythic.core.config.MythicLineConfigImpl;
import io.lumine.mythic.core.drops.DefaultPityManager;
import io.lumine.mythic.core.drops.Drop;
import io.lumine.mythic.core.drops.DropTable;
import io.lumine.mythic.core.drops.InvalidDrop;
import io.lumine.mythic.core.drops.LootBag;
import io.lumine.mythic.core.drops.PityManager;
import io.lumine.mythic.core.drops.droppables.CommandDrop;
import io.lumine.mythic.core.drops.droppables.CustomDrop;
import io.lumine.mythic.core.drops.droppables.DropTableDrop;
import io.lumine.mythic.core.drops.droppables.ExperienceDrop;
import io.lumine.mythic.core.drops.droppables.HeroesExperienceDrop;
import io.lumine.mythic.core.drops.droppables.ItemDrop;
import io.lumine.mythic.core.drops.droppables.McMMODrop;
import io.lumine.mythic.core.drops.droppables.MythicDropsDrop;
import io.lumine.mythic.core.drops.droppables.MythicItemDrop;
import io.lumine.mythic.core.drops.droppables.MythicMobDrop;
import io.lumine.mythic.core.drops.droppables.NothingDrop;
import io.lumine.mythic.core.drops.droppables.PhatLootsDrop;
import io.lumine.mythic.core.drops.droppables.SkillAPIDrop;
import io.lumine.mythic.core.drops.droppables.VanillaItemDrop;
import io.lumine.mythic.core.drops.droppables.VaultDrop;
import io.lumine.mythic.core.glow.GlowColor;
import io.lumine.mythic.core.glow.GlowManager;
import io.lumine.mythic.core.items.LegacyItemConverter;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.mobs.tracker.DamageRecord;
import io.lumine.mythic.core.mobs.tracker.DamageRecordManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerAttemptPickupItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class DropExecutor
extends ReloadableModule<MythicBukkit>
implements DropManager {
    private PityManager pityManager = new DefaultPityManager();
    private Map<String, DropTable> dropTables = new ConcurrentHashMap<String, DropTable>();
    private Map<UUID, UUID> itemPickupMap = new ConcurrentHashMap<UUID, UUID>();
    private Map<UUID, PacketEntity> itemVfxBeams = new ConcurrentHashMap<UUID, PacketEntity>();

    public DropExecutor(MythicBukkit plugin) {
        super(plugin, false);
        if (ServerVersion.isPaper()) {
            Events.subscribe(PlayerAttemptPickupItemEvent.class).filter(event -> this.itemPickupMap.containsKey(event.getItem().getUniqueId())).handler(event -> {
                ItemStack itemStack;
                Item item = event.getItem();
                Player player = event.getPlayer();
                UUID uuid = this.itemPickupMap.get(item.getUniqueId());
                if (uuid != null && !uuid.equals(player.getUniqueId())) {
                    event.setCancelled(true);
                    return;
                }
                this.itemPickupMap.remove(item.getUniqueId());
                if (this.itemVfxBeams.containsKey(item.getUniqueId())) {
                    this.itemVfxBeams.get(item.getUniqueId()).destroy();
                    this.itemVfxBeams.remove(item.getUniqueId());
                }
                if ((itemStack = event.getItem().getItemStack()).getItemMeta().getPersistentDataContainer().has(new NamespacedKey((Plugin)MythicBukkit.inst(), "fancydrop"), PersistentDataType.STRING)) {
                    ItemMeta meta = itemStack.getItemMeta();
                    PersistentDataContainer pdc = meta.getPersistentDataContainer();
                    pdc.remove(new NamespacedKey((Plugin)MythicBukkit.inst(), "fancydrop"));
                    itemStack.setItemMeta(meta);
                }
            });
        }
    }

    @Override
    public void load(MythicBukkit plugin) {
        this.loadDropTables();
    }

    public void registerPityManager(PityManager manager) {
        this.pityManager = manager;
    }

    public void loadDropTables() {
        MythicLogger.log("Loading Drop Tables...");
        IOLoader<MythicBukkit> defaultDroptables = new IOLoader<MythicBukkit>(MythicBukkit.inst(), "ExampleDropTables.yml", "DropTables");
        List<File> droptableFiles = IOHandler.getAllFiles(defaultDroptables.getFile().getParent());
        for (Pack pack : ((MythicBukkit)this.getPlugin()).getPackManager().getPacks()) {
            for (File dropTablesFolder : pack.getPackFolders("DropTables", true)) {
                droptableFiles.addAll(IOHandler.getAllFiles(dropTablesFolder.getAbsolutePath()));
            }
        }
        List<IOLoader<MythicBukkit>> droptableLoaders = IOHandler.getSaveLoad(MythicBukkit.inst(), droptableFiles, "DropTables");
        this.dropTables.clear();
        for (IOLoader<MythicBukkit> sl : droptableLoaders) {
            for (String s2 : sl.getCustomConfig().getConfigurationSection("").getKeys(false)) {
                if (sl.getCustomConfig().getStringList(s2 + ".Drops") == null) continue;
                String file = sl.getFile().getName();
                MythicConfigImpl mc = new MythicConfigImpl(s2, sl.getCustomConfig());
                DropTable dt = new DropTable(this, file, s2, mc);
                this.dropTables.put(s2, dt);
            }
        }
        ((MythicBukkit)this.plugin).getClock().runSecondPass();
    }

    @Override
    public void unload() {
        this.dropTables.clear();
    }

    public void queueAfterLoad(Runnable r) {
        ((MythicBukkit)this.plugin).getClock().queueAfterLoad(r);
    }

    public void queueSecondPass(Runnable r) {
        ((MythicBukkit)this.plugin).getClock().queueSecondPass(r);
    }

    @Override
    public Optional<DropTable> getDropTable(String name) {
        return Optional.ofNullable(this.dropTables.getOrDefault(name, null));
    }

    @Override
    public Collection<DropTable> getDropTables() {
        return this.dropTables.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Drop getDrop(String fileName, String drop) {
        if (((String)drop).contains("}")) {
            String sp1 = ((String)drop).substring(0, ((String)drop).indexOf("}"));
            String sp2 = ((String)drop).substring(((String)drop).indexOf("}"));
            String ns = sp1.replace(" ", "") + sp2;
            drop = ns;
        }
        String[] s2 = ((String)drop).split(" ");
        String name = null;
        MythicLineConfigImpl mlc = new MythicLineConfigImpl(fileName, s2[0]);
        name = s2[0].contains("{") ? s2[0].substring(0, s2[0].indexOf("{")) : s2[0];
        String oName = name.toUpperCase();
        byte oData = 0;
        if (name.contains(":")) {
            oName = name.split(":")[0].toUpperCase();
            try {
                oData = Byte.valueOf(name.split(":")[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            name = name.split(":")[0];
        }
        Material material = null;
        try {
            Material material2 = material = oData == 0 ? Material.valueOf((String)oName) : LegacyItemConverter.getMaterial(oName, oData);
            if (material == null && oData > 0) {
                material = Material.valueOf((String)oName);
            }
        }
        catch (Exception ex) {
            material = LegacyItemConverter.getMaterial(oName, oData);
            if (material == null && oData > 0) {
                try {
                    material = Material.valueOf((String)oName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            if (material != null && material != Material.AIR) {
                name = material.toString();
            }
        }
        try {
            if (Material.matchMaterial((String)name) != null) {
                return new VanillaItemDrop((String)drop, (MythicLineConfig)mlc, name);
            }
            if (((MythicBukkit)this.getPlugin()).getDropManager().getDropTable(name).isPresent()) {
                return new DropTableDrop((String)drop, name, mlc);
            }
            if (((MythicBukkit)this.getPlugin()).getItemManager().getItem(name).isPresent()) {
                return new MythicItemDrop((String)drop, name, mlc);
            }
            switch (name.toUpperCase()) {
                case "NOTHING": 
                case "NONE": 
                case "NULL": {
                    return new NothingDrop((String)drop, mlc);
                }
                case "COMMAND": 
                case "CMD": {
                    return new CommandDrop((String)drop, mlc);
                }
                case "EXPERIENCE": 
                case "EXP": 
                case "XP": {
                    return new ExperienceDrop((String)drop, mlc);
                }
                case "MYTHICMOB": 
                case "MYTHICMOBS": 
                case "MM": {
                    return new MythicMobDrop((String)drop, mlc);
                }
                case "VAULT": 
                case "MONEY": 
                case "CURRENCY": {
                    return new VaultDrop((String)drop, mlc);
                }
                case "HEROESEXP": 
                case "HEROES-EXP": {
                    return new HeroesExperienceDrop((String)drop, mlc);
                }
                case "MCMMOEXP": 
                case "MCMMO-EXP": {
                    return new McMMODrop((String)drop, mlc);
                }
                case "MYTHICDROP": 
                case "MD": {
                    return new MythicDropsDrop((String)drop, mlc);
                }
                case "PHATLOOT": 
                case "PHATLOOTS": 
                case "PL": {
                    return new PhatLootsDrop((String)drop, mlc);
                }
                case "SKILLAPIEXP": 
                case "SKILLAPI-EXP": {
                    return new SkillAPIDrop((String)drop, mlc);
                }
            }
            return new CustomDrop(name, (String)drop, mlc);
        }
        catch (Exception ex) {
            return new InvalidDrop((String)drop, mlc);
        }
    }

    public static void Drop(Location loc, int exp, List<ItemStack> drops) {
        for (ItemStack is : drops) {
            loc.getWorld().dropItemNaturally(loc, is);
        }
        if (exp != 0) {
            int i = exp % 4;
            int per = (exp - exp % 4) / 4;
            for (int y = 0; y < 4; ++y) {
                ExperienceOrb eo = (ExperienceOrb)loc.getWorld().spawnEntity(loc, EntityType.EXPERIENCE_ORB);
                eo.setExperience(per);
            }
            if (i != 0) {
                ExperienceOrb eo = (ExperienceOrb)loc.getWorld().spawnEntity(loc, EntityType.EXPERIENCE_ORB);
                eo.setExperience(i);
            }
        }
    }

    public void handleEntityLootDrops(EntityDeathEvent event, LootBag lootBag, DropMetadata metadata, ActiveMob am) {
        int experience;
        block29: {
            List<Component> parsed;
            DamageRecord damageRecord;
            AbstractEntity aKiller;
            block30: {
                HashMap<IMessagingDrop, Double> messagingDrops = new HashMap<IMessagingDrop, Double>();
                LivingEntity killer = this.getKiller(event);
                aKiller = metadata.getCause().isPresent() ? metadata.getCause().get() : (killer == null ? null : BukkitAdapter.adapt((Entity)killer));
                AbstractEntity killedEntity = BukkitAdapter.adapt((Entity)event.getEntity());
                experience = 0;
                boolean fancy = false;
                for (Drop drop : lootBag.getDrops()) {
                    IDrop drop2;
                    double amount;
                    block28: {
                        block27: {
                            amount = drop.getAmount();
                            if (drop instanceof CustomDrop) {
                                CustomDrop customDrop = (CustomDrop)drop;
                                if (customDrop.getDrop().isEmpty()) continue;
                                drop2 = customDrop.getDrop().get();
                            } else {
                                drop2 = drop;
                            }
                            if (!(drop2 instanceof IItemDrop)) break block27;
                            IItemDrop itemDrop = (IItemDrop)drop2;
                            switch (am.getType().getDropMethod()) {
                                case FANCY: {
                                    fancy = true;
                                    if (aKiller != null && aKiller.isPlayer()) {
                                        this.handleFancyDrops(drop2, amount, am, metadata, event, aKiller);
                                        break;
                                    }
                                    break block28;
                                }
                                case CHEST: {
                                    break;
                                }
                                default: {
                                    event.getDrops().add(BukkitAdapter.adapt(itemDrop.getDrop(metadata, amount)));
                                    break;
                                }
                            }
                            break block28;
                        }
                        if (drop2 instanceof ExperienceDrop) {
                            experience = (int)((double)experience + amount);
                        } else if (drop2 instanceof IIntangibleDrop) {
                            IIntangibleDrop intangibleDrop = (IIntangibleDrop)drop2;
                            if (aKiller != null && aKiller.isPlayer()) {
                                intangibleDrop.giveDrop(aKiller.asPlayer(), metadata, amount);
                            }
                        } else if (drop2 instanceof ILocationDrop) {
                            ILocationDrop locationDrop = (ILocationDrop)drop2;
                            locationDrop.drop(killedEntity.getLocation(), metadata, amount);
                        } else if (drop2 instanceof ICommandDrop) {
                            metadata.setAmount((int)amount);
                            if (aKiller != null && aKiller.isPlayer()) {
                                ((ICommandDrop)drop2).dispatchCommand(aKiller.asPlayer(), metadata, amount);
                            } else {
                                ((ICommandDrop)drop2).dispatchCommand(null, metadata, amount);
                            }
                        }
                    }
                    if (!(drop2 instanceof IMessagingDrop)) continue;
                    messagingDrops.merge((IMessagingDrop)((Object)drop2), amount, (n, o) -> n + o);
                }
                if (aKiller != null && aKiller.isPlayer() && messagingDrops.size() > 0) {
                    for (Map.Entry entry : messagingDrops.entrySet()) {
                        String message = ((IMessagingDrop)entry.getKey()).getRewardMessage(metadata, (Double)entry.getValue());
                        if (message == null) continue;
                        aKiller.asPlayer().sendMessage(message);
                    }
                }
                if (aKiller == null || !aKiller.isPlayer()) break block29;
                DamageRecordManager recordManager = ((MythicBukkit)this.getPlugin()).getDamageRecordManager();
                damageRecord = recordManager.getRecord(am.getUniqueId());
                if (!am.getType().isDropsPerPlayer()) break block30;
                if (am.getType().getShowChatLeaderboardOnDeath().booleanValue()) {
                    List<Component> parsed2 = this.processMessages(am.getType().getFancyDropChatMessage(), damageRecord, aKiller.getUniqueId(), this.pityManager, am);
                    Player player = Bukkit.getPlayer((UUID)aKiller.getUniqueId());
                    if (player != null) {
                        parsed2.forEach(line -> Text.sendMessage((CommandSender)player, line));
                    }
                }
                if (!am.getType().getShowHologramLeaderboardOnDeath().booleanValue()) break block29;
                List<Component> parsed2 = this.processMessages(am.getType().getFancyDropHologramMessage(), damageRecord, aKiller.getUniqueId(), this.pityManager, am);
                PacketTextDisplay packetTextDisplay = PacketTextDisplay.create().textComponent(parsed2).cullingDistance(256).build(am.getLocation());
                if (Bukkit.getPlayer((UUID)aKiller.getUniqueId()) == null || !Bukkit.getPlayer((UUID)aKiller.getUniqueId()).isOnline()) break block29;
                ((PacketEntityRenderer)packetTextDisplay.getRenderer()).spawn(aKiller.asPlayer());
                Schedulers.async().runLater(packetTextDisplay::destroy, am.getType().getHologramLeaderboardTimeout().intValue());
                break block29;
            }
            if (am.getType().getShowChatLeaderboardOnDeath().booleanValue()) {
                for (UUID killerUUID : damageRecord.getDamagers()) {
                    parsed = this.processMessages(am.getType().getFancyDropChatMessage(), damageRecord, killerUUID, this.pityManager, am);
                    Player player = Bukkit.getPlayer((UUID)killerUUID);
                    if (player == null) continue;
                    parsed.forEach(line -> Text.sendMessage((CommandSender)player, line));
                }
            }
            if (am.getType().getShowHologramLeaderboardOnDeath().booleanValue()) {
                for (UUID killerUUID : damageRecord.getDamagers()) {
                    parsed = this.processMessages(am.getType().getFancyDropHologramMessage(), damageRecord, killerUUID, this.pityManager, am);
                    PacketTextDisplay packetTextDisplay = PacketTextDisplay.create().textComponent(parsed).cullingDistance(256).build(am.getLocation());
                    if (Bukkit.getPlayer((UUID)killerUUID) == null || !Bukkit.getPlayer((UUID)killerUUID).isOnline()) continue;
                    ((PacketEntityRenderer)packetTextDisplay.getRenderer()).spawn(aKiller.asPlayer());
                    Schedulers.async().runLater(packetTextDisplay::destroy, am.getType().getHologramLeaderboardTimeout().intValue());
                }
            }
        }
        if (experience > 0) {
            event.setDroppedExp(experience);
        }
    }

    private void handleFancyDrops(IDrop drop, double amount, ActiveMob am, DropMetadata metadata, EntityDeathEvent event, AbstractEntity killer) {
        ItemStack itemStack = BukkitAdapter.adapt(((IItemDrop)drop).getDrop(metadata, amount));
        Player playerKiller = (Player)BukkitAdapter.adapt(killer);
        if (!(drop instanceof ItemDrop)) {
            event.getDrops().add(itemStack);
            return;
        }
        ItemDrop itemDrop = (ItemDrop)drop;
        boolean perPlayerDrops = am.getType().isDropsPerPlayer();
        DamageRecordManager recordManager = ((MythicBukkit)this.getPlugin()).getDamageRecordManager();
        int place = recordManager.getRecord(am.getUniqueId()).getPlace(killer.getUniqueId());
        boolean didEnoughDamage = recordManager.getRecord(am.getUniqueId()).didEnoughDamage(killer.getUniqueId(), itemDrop.getMinDamage());
        if (perPlayerDrops && (!didEnoughDamage || place > itemDrop.getRequiredPlacement())) {
            return;
        }
        Location deathLocation = BukkitAdapter.adapt(am.getLocation());
        World deathWorld = deathLocation.getWorld();
        GlowManager glowManager = MythicBukkit.inst().getGlowManager();
        ItemMeta meta = itemStack.getItemMeta();
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        pdc.set(new NamespacedKey((Plugin)MythicBukkit.inst(), "fancydrop"), PersistentDataType.STRING, (Object)UUID.randomUUID().toString());
        itemStack.setItemMeta(meta);
        deathWorld.dropItemNaturally(deathLocation, itemStack, item -> {
            boolean clientSide;
            boolean bl = clientSide = am.getType().isDropsPerPlayer() && itemDrop.getClientSideDropsEnabled().orElse(am.getType().getDropsAreClientsideByDefault()) != false;
            if (am.getType().isDropsPerPlayer()) {
                this.itemPickupMap.put(item.getUniqueId(), playerKiller.getUniqueId());
                if (clientSide) {
                    item.setVisibleByDefault(false);
                    playerKiller.showEntity((Plugin)MythicBukkit.inst(), (Entity)item);
                }
            }
            if (itemDrop.getLootsplosionEnabled().orElse(am.getType().getDropsDoLootsplosion()).booleanValue()) {
                double randomX = (Math.random() * 0.5 - 0.25) * 1.4;
                double randomY = (Math.random() * 0.25 + 0.25) * 1.4;
                double randomZ = (Math.random() * 0.5 - 0.25) * 1.4;
                Vector velocity = new Vector(randomX, randomY, randomZ);
                item.setVelocity(velocity);
            }
            if (itemDrop.getItemGlowEnabled().orElse(am.getType().getDropsGlowByDefault()).booleanValue()) {
                GlowColor color = itemDrop.getItemGlow() != null ? itemDrop.getItemGlow() : GlowColor.WHITE;
                Schedulers.sync().runLater(() -> {
                    if (clientSide) {
                        glowManager.setColor(BukkitAdapter.adapt((Entity)item), color, BukkitAdapter.adapt(playerKiller));
                        glowManager.setGlowing(BukkitAdapter.adapt((Entity)item), true, BukkitAdapter.adapt(playerKiller));
                    } else {
                        glowManager.setColor(BukkitAdapter.adapt((Entity)item), color, ((MythicBukkit)this.getPlugin()).getBootstrap().getOnlinePlayers());
                        glowManager.setGlowing(BukkitAdapter.adapt((Entity)item), true, ((MythicBukkit)this.getPlugin()).getBootstrap().getOnlinePlayers());
                    }
                }, 1L);
            }
            if (itemDrop.getItemVFXEnabled().orElse(am.getType().getDropsHaveVFXByDefault()).booleanValue()) {
                ItemFactory vfxItem = itemDrop.getItemVfxMaterial() == null ? ItemFactory.of(am.getType().getDropsItemVFXMaterial()).model(am.getType().getDropsItemVFXModel()) : ItemFactory.of(Material.valueOf((String)itemDrop.getItemVfxMaterial())).model(itemDrop.getItemVfxData());
                if (itemDrop.getVfxColor() != null) {
                    vfxItem.color(itemDrop.getVfxColor());
                }
                PacketItemDisplay packetItemDisplay = PacketItemDisplay.create().item(vfxItem.build()).billboard(itemDrop.getDisplayBillboarding()).viewRange(Float.valueOf(200.0f)).build(BukkitAdapter.adapt(item.getLocation()));
                if (clientSide) {
                    packetItemDisplay.getRenderer().spawn(BukkitAdapter.adapt(playerKiller));
                } else {
                    packetItemDisplay.getRenderer().spawn(() -> ((MythicBukkit)this.getPlugin()).getBootstrap().getOnlinePlayers());
                }
                packetItemDisplay.getRenderer().mountEntity(BukkitAdapter.adapt((Entity)item));
                this.itemVfxBeams.put(item.getUniqueId(), packetItemDisplay);
                Schedulers.async().runRepeating(task -> {
                    if (item.isDead() || task.getTimesRan() > 10000) {
                        if (this.itemVfxBeams.containsKey(item.getUniqueId())) {
                            this.itemVfxBeams.get(item.getUniqueId()).destroy();
                            this.itemVfxBeams.remove(item.getUniqueId());
                        }
                        task.terminate();
                    } else {
                        packetItemDisplay.getRenderer().updateRenderedPlayers();
                        packetItemDisplay.getRenderer().mountEntity(BukkitAdapter.adapt((Entity)item));
                        packetItemDisplay.getRenderer().update();
                    }
                }, 1L, 1L);
            }
            if (itemDrop.getItemBeamEnabled().orElse(am.getType().getDropsHaveBeamByDefault()).booleanValue()) {
                Schedulers.async().runRepeating(task -> {
                    if (item.isDead() || task.getTimesRan() > 1000) {
                        task.terminate();
                        return;
                    }
                    Color color = itemDrop.getItemBeam() != null ? itemDrop.getItemBeam().toBukkitColor() : Chroma.Dyes.WHITE.getColor().toBukkitColor();
                    if (clientSide) {
                        this.createParticleBeamAboveItem(playerKiller, item.getLocation(), color);
                    } else {
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            if (player.getWorld() != item.getWorld() || player.getLocation().distance(item.getLocation()) > 50.0) continue;
                            this.createParticleBeamAboveItem(player, item.getLocation(), color);
                        }
                    }
                }, 2L, 2L);
            }
            if (itemDrop.getHologramNameEnabled().orElse(am.getType().getDropsShowNameByDefault()).booleanValue()) {
                item.setCustomNameVisible(true);
                if (drop instanceof MythicItemDrop) {
                    MythicItemDrop mythicItemDrop = (MythicItemDrop)drop;
                    String display = mythicItemDrop.getItem().getDisplayName();
                    item.customName(MiniMessage.miniMessage().deserialize((Object)display));
                } else {
                    item.customName(itemStack.displayName());
                }
            }
        });
        if (itemDrop.isResetPity()) {
            this.pityManager.resetPity(playerKiller.getUniqueId(), itemDrop.getPityCategory());
        }
        this.pityManager.addPity(playerKiller.getUniqueId(), itemDrop.getPityModifier(), itemDrop.getPityCategory());
    }

    public LivingEntity getKiller(EntityDeathEvent event) {
        EntityDamageEvent entityDamageEvent = event.getEntity().getLastDamageCause();
        if (entityDamageEvent != null && !entityDamageEvent.isCancelled() && entityDamageEvent instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent entityDamageByEntityEvent = (EntityDamageByEntityEvent)entityDamageEvent;
            Entity damager = entityDamageByEntityEvent.getDamager();
            if (damager instanceof Projectile) {
                Projectile projectile = (Projectile)damager;
                ProjectileSource projectileSource = projectile.getShooter();
                if (projectileSource instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)projectileSource;
                    return livingEntity;
                }
                return event.getEntity().getKiller();
            }
            if (damager instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)damager;
                return livingEntity;
            }
        }
        return event.getEntity().getKiller();
    }

    private void createParticleBeamAboveItem(Player player, Location itemLocation, Color color) {
        for (int i = 0; i < 20; ++i) {
            Location particleLocation = itemLocation.clone().add(0.0, 1.0 + (double)i * 0.1, 0.0);
            Particle.DustOptions dustOptions = new Particle.DustOptions(color, 1.0f);
            player.spawnParticle(BukkitParticle.DUST.getBukkitParticle(), particleLocation, 1, 0.0, 0.0, 0.0, 1.0, (Object)dustOptions);
        }
    }

    private String replacePlaceholders(String message, DamageRecord record, UUID playerUuid, PityManager pityManager, ActiveMob am) {
        Player player = Bukkit.getPlayer((UUID)playerUuid);
        if (player == null) {
            return message;
        }
        int playerRank = record.getPlace(playerUuid);
        double playerDamage = record.getDamagingPlayers().get(playerUuid).getTotalDamage();
        double playerPity = pityManager.getPity(playerUuid);
        message = message.replace("<mob.name>", am.getDisplayName());
        message = message.replace("<mob.hp>", String.valueOf((int)am.getType().getHealth().get()));
        message = message.replace("<player.rank>", String.valueOf(playerRank));
        message = message.replace("<player.damage>", String.format("%.2f", playerDamage));
        message = message.replace("<pity>", String.valueOf(playerPity));
        String regex = "<(\\d+)\\.(name|damage)>";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(message);
        while (matcher.find()) {
            int position = Integer.parseInt(matcher.group(1));
            String placeholderType = matcher.group(2);
            UUID damagerUuid = record.getDamagerInPlace(position);
            if (damagerUuid == null) {
                return null;
            }
            Player damagerPlayer = Bukkit.getPlayer((UUID)damagerUuid);
            if (damagerPlayer == null) {
                return null;
            }
            if ("name".equals(placeholderType)) {
                String damagerName = damagerPlayer.getName();
                message = message.replace("<" + position + ".name>", damagerName);
                continue;
            }
            if (!"damage".equals(placeholderType)) continue;
            double damagerDamage = record.getDamageInPlace(position);
            message = message.replace("<" + position + ".damage>", String.format("%.2f", damagerDamage));
        }
        return message;
    }

    private List<Component> processMessages(List<String> messages, DamageRecord record, UUID playerUuid, PityManager pityManager, ActiveMob am) {
        ArrayList<Component> parsed = new ArrayList<Component>();
        for (String s2 : messages) {
            boolean validLine = true;
            Matcher matcher = Pattern.compile("%(\\d+)\\.(name|damage)%").matcher(s2);
            while (matcher.find()) {
                int placeholderIndex = Integer.parseInt(matcher.group(1));
                if (placeholderIndex <= record.getDamagingPlayers().size()) continue;
                validLine = false;
                break;
            }
            if (!validLine || (s2 = this.replacePlaceholders(s2, record, playerUuid, pityManager, am)) == null) continue;
            parsed.add(MiniMessage.miniMessage().deserialize((Object)s2));
        }
        return parsed;
    }

    public PityManager getPityManager() {
        return this.pityManager;
    }
}

