/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.worldedit;

import com.google.common.collect.Lists;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardWriter;
import com.sk89q.worldedit.function.operation.ForwardExtentCopy;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.transform.AffineTransform;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.session.SessionOwner;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.logging.Log;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.bukkit.utils.serialize.Locus;
import io.lumine.mythic.bukkit.utils.serialize.Position;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;

public final class Regions {
    public static WorldEdit getWorldEdit() {
        return WorldEdit.getInstance();
    }

    public static BlockVector3 toWEVector(Position from) {
        return BlockVector3.at((double)from.getX(), (double)from.getY(), (double)from.getZ());
    }

    public static BlockVector3 toWEVector(Locus from) {
        return BlockVector3.at((double)from.getX(), (double)from.getY(), (double)from.getZ());
    }

    public static Locus fromWEVector(BlockVector3 from) {
        return Locus.of(from.getX(), from.getY(), from.getZ());
    }

    public static Position fromWEVector(BlockVector3 from, World fromWorld) {
        org.bukkit.World world = BukkitAdapter.adapt((World)fromWorld);
        return Position.of((double)from.getX(), (double)from.getY(), (double)from.getZ(), world);
    }

    public static Region toWERegion(io.lumine.mythic.bukkit.utils.serialize.Region from) {
        World world = BukkitAdapter.adapt((org.bukkit.World)from.getMin().toLocation().getWorld());
        BlockVector3 min2 = Regions.toWEVector(from.getMin());
        BlockVector3 max = Regions.toWEVector(from.getMax());
        return new CuboidRegion(world, min2, max);
    }

    public static io.lumine.mythic.bukkit.utils.serialize.Region fromWERegion(Region from) {
        Position min2 = Regions.fromWEVector(from.getMinimumPoint(), from.getWorld());
        Position max = Regions.fromWEVector(from.getMaximumPoint(), from.getWorld());
        return io.lumine.mythic.bukkit.utils.serialize.Region.of(min2, max);
    }

    public static World toWEWorld(Position from) {
        return BukkitAdapter.adapt((org.bukkit.World)from.toLocation().getWorld());
    }

    public static Optional<io.lumine.mythic.bukkit.utils.serialize.Region> getPlayerSelection(Player player) {
        BukkitPlayer absPlayer = BukkitAdapter.adapt((Player)player);
        LocalSession session = WorldEdit.getInstance().getSessionManager().getIfPresent((SessionOwner)absPlayer);
        World absWorld = session.getSelectionWorld();
        try {
            if (absWorld == null) {
                return Optional.empty();
            }
            Region region = session.getSelection(absWorld);
            if (region != null) {
                org.bukkit.World world = BukkitAdapter.adapt((World)region.getWorld());
                BlockVector3 min2 = region.getMinimumPoint();
                BlockVector3 max = region.getMaximumPoint();
                return Optional.of(io.lumine.mythic.bukkit.utils.serialize.Region.of(Position.of((double)min2.getX(), (double)min2.getY(), (double)min2.getZ(), world), Position.of((double)max.getX(), (double)max.getY(), (double)max.getZ(), world)));
            }
            return Optional.empty();
        }
        catch (Error | Exception ex) {
            ex.printStackTrace();
            return Optional.empty();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EditSession setRegion(io.lumine.mythic.bukkit.utils.serialize.Region region, Material material) {
        Region weRegion = Regions.toWERegion(region);
        try (EditSession editSession = WorldEdit.getInstance().newEditSession(weRegion.getWorld());){
            BaseBlock to = BukkitAdapter.adapt((BlockData)material.createBlockData()).toBaseBlock();
            try {
                editSession.setBlocks(weRegion, (BlockStateHolder)to);
                editSession.flushSession();
                EditSession editSession2 = editSession;
                return editSession2;
            }
            catch (Error | Exception ex) {
                ex.printStackTrace();
                if (editSession == null) return null;
                editSession.close();
                return null;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EditSession replaceRegion(io.lumine.mythic.bukkit.utils.serialize.Region region, Collection<Material> replace, Material material) {
        Region weRegion = Regions.toWERegion(region);
        try (EditSession editSession = WorldEdit.getInstance().newEditSession(weRegion.getWorld());){
            HashSet<BaseBlock> baseBlocks = new HashSet<BaseBlock>();
            for (Material m4 : replace) {
                baseBlocks.add(BukkitAdapter.adapt((BlockData)m4.createBlockData()).toBaseBlock());
            }
            BaseBlock to = BukkitAdapter.adapt((BlockData)material.createBlockData()).toBaseBlock();
            try {
                Material m4;
                editSession.replaceBlocks(weRegion, baseBlocks, (BlockStateHolder)to);
                editSession.flushSession();
                m4 = editSession;
                return m4;
            }
            catch (Error | Exception ex) {
                ex.printStackTrace();
                if (editSession == null) return null;
                editSession.close();
                return null;
            }
        }
    }

    public static Clipboard copyRegion(io.lumine.mythic.bukkit.utils.serialize.Region region) {
        Region weRegion = Regions.toWERegion(region);
        BlockArrayClipboard clipboard = new BlockArrayClipboard(weRegion);
        try (EditSession editSession = WorldEdit.getInstance().getEditSessionFactory().getEditSession(weRegion.getWorld(), -1);){
            ForwardExtentCopy forwardExtentCopy = new ForwardExtentCopy((Extent)editSession, weRegion, (Extent)clipboard, weRegion.getMinimumPoint());
            forwardExtentCopy.setCopyingEntities(true);
            try {
                Operations.complete((Operation)forwardExtentCopy);
            }
            catch (WorldEditException ex) {
                ex.printStackTrace();
                BlockArrayClipboard blockArrayClipboard = clipboard;
                if (editSession != null) {
                    editSession.close();
                }
                return blockArrayClipboard;
            }
        }
        return clipboard;
    }

    public static Optional<Clipboard> loadSchematic(File schematicFile) {
        Optional<Clipboard> optional;
        block10: {
            if (!schematicFile.exists()) {
                Log.error("Schematic file " + schematicFile.getAbsolutePath() + " doesnt exist");
                return Optional.empty();
            }
            ClipboardFormat schematicFormat = ClipboardFormats.findByFile((File)schematicFile);
            if (schematicFormat == null) {
                Log.error("Schematic file " + schematicFile.getAbsolutePath() + " is corrupt");
                return Optional.empty();
            }
            ClipboardReader reader = schematicFormat.getReader((InputStream)new FileInputStream(schematicFile));
            try {
                optional = Optional.ofNullable(reader.read());
                if (reader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return Optional.empty();
                }
            }
            reader.close();
        }
        return optional;
    }

    public static Optional<Clipboard> saveSchematic(io.lumine.mythic.bukkit.utils.serialize.Region region, File schematicFile) {
        Optional<Clipboard> optional;
        block9: {
            Clipboard clipboard = Regions.copyRegion(region);
            ClipboardFormat schematicFormat = ClipboardFormats.findByFile((File)schematicFile);
            if (schematicFormat == null) {
                Log.error("Schematic file " + schematicFile.getAbsolutePath() + " is corrupt");
                return Optional.empty();
            }
            ClipboardWriter reader = schematicFormat.getWriter((OutputStream)new FileOutputStream(schematicFile));
            try {
                reader.write(clipboard);
                optional = Optional.of(clipboard);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return Optional.empty();
                }
            }
            reader.close();
        }
        return optional;
    }

    public static void pasteSchematic(Clipboard schematic, io.lumine.mythic.bukkit.utils.serialize.Region pasteLocation) {
        Regions.pasteSchematic(schematic, pasteLocation.getMin(), 0, false);
    }

    public static void pasteSchematic(Clipboard schematic, Position pasteLocation) {
        Regions.pasteSchematic(schematic, pasteLocation, 0, false);
    }

    public static void pasteSchematic(Clipboard schematic, Position pasteLocation, boolean ignoreAir) {
        Regions.pasteSchematic(schematic, pasteLocation, 0, false);
    }

    public static void pasteSchematic(Clipboard schematic, Position pasteLocation, int rotation, boolean ignoreAir) {
        Regions.pasteSchematicThen(schematic, pasteLocation, rotation, ignoreAir, false, null);
    }

    public static void pasteSchematic(Clipboard schematic, Position pasteLocation, int rotation, boolean ignoreAir, boolean useOriginalOrigin) {
        Regions.pasteSchematicThen(schematic, pasteLocation, rotation, ignoreAir, useOriginalOrigin, null);
    }

    public static void pasteSchematicThen(Clipboard schematic, Position pasteLocation, int rotation, boolean ignoreAir, boolean useOriginalOrigin, Consumer<EditSession> then) {
        BlockVector3 pastePosition = BlockVector3.at((int)Numbers.floor(pasteLocation.getX()), (int)Numbers.floor(pasteLocation.getY()), (int)Numbers.floor(pasteLocation.getZ()));
        World faweWorld = Regions.toWEWorld(pasteLocation);
        if (!useOriginalOrigin) {
            schematic.setOrigin(schematic.getMinimumPoint());
        }
        try (EditSession editSession = WorldEdit.getInstance().newEditSession(faweWorld);){
            ClipboardHolder holder = new ClipboardHolder(schematic);
            if (rotation != 0) {
                AffineTransform tr = new AffineTransform();
                tr = tr.rotateY((double)rotation);
                holder.setTransform((Transform)tr);
            }
            Operation operation = holder.createPaste((Extent)editSession).to(pastePosition).ignoreAirBlocks(ignoreAir).build();
            try {
                Operations.complete((Operation)operation);
            }
            catch (WorldEditException e) {
                e.printStackTrace();
            }
            editSession.flushSession();
            if (then != null) {
                then.accept(editSession);
            }
        }
    }

    public static Collection<Position> pasteSchematic(Clipboard schematic, Position pasteLocation, int rotation, boolean ignoreAir, Collection<Material> blockPositions) {
        return Regions.pasteSchematic(schematic, pasteLocation, rotation, ignoreAir, false, blockPositions);
    }

    public static Collection<Position> pasteSchematic(Clipboard schematic, Position pasteLocation, int rotation, boolean ignoreAir, boolean useOriginalOrigin, Collection<Material> blockPositions) {
        BlockVector3 pastePosition = BlockVector3.at((int)Numbers.floor(pasteLocation.getX()), (int)Numbers.floor(pasteLocation.getY()), (int)Numbers.floor(pasteLocation.getZ()));
        World faweWorld = Regions.toWEWorld(pasteLocation);
        BlockVector3 origin = schematic.getOrigin();
        if (!useOriginalOrigin) {
            schematic.setOrigin(schematic.getMinimumPoint());
        }
        try (EditSession editSession = WorldEdit.getInstance().newEditSession(faweWorld);){
            ClipboardHolder holder = new ClipboardHolder(schematic);
            if (rotation != 0) {
                AffineTransform tr = new AffineTransform();
                tr = tr.rotateY((double)rotation);
                holder.setTransform((Transform)tr);
            }
            ArrayList ret = Lists.newArrayList();
            for (int x = schematic.getMinimumPoint().getX(); x <= schematic.getMaximumPoint().getX(); ++x) {
                for (int y = schematic.getMinimumPoint().getY(); y <= schematic.getMaximumPoint().getY(); ++y) {
                    for (int z = schematic.getMinimumPoint().getZ(); z <= schematic.getMaximumPoint().getZ(); ++z) {
                        BaseBlock state = schematic.getFullBlock(BlockVector3.at((int)x, (int)y, (int)z));
                        double ax = pastePosition.getX() + x - schematic.getMinimumPoint().getBlockX();
                        double ay = pastePosition.getY() + y - schematic.getMinimumPoint().getBlockY();
                        double az = pastePosition.getZ() + z - schematic.getMinimumPoint().getBlockZ();
                        if (state.getBlockType() != BlockTypes.CHEST) continue;
                        ret.add(Position.of(ax, ay, az, pasteLocation.getWorld()));
                    }
                }
            }
            Operation operation = holder.createPaste((Extent)editSession).to(pastePosition).ignoreAirBlocks(ignoreAir).build();
            try {
                Operations.complete((Operation)operation);
            }
            catch (WorldEditException e) {
                e.printStackTrace();
            }
            editSession.flushSession();
            ArrayList arrayList = ret;
            return arrayList;
        }
    }

    public static void pasteSchematicByBlock(Clipboard schematic, Position pasteLocation, int rotation, boolean ignoreAir, int blocksPerTick) {
        Regions.pasteSchematicByBlock(schematic, pasteLocation, rotation, ignoreAir, false, blocksPerTick);
    }

    public static void pasteSchematicByBlock(Clipboard schematic, Position pasteLocation, int rotation, boolean ignoreAir, boolean useOriginalOrigin, int blocksPerTick) {
        BlockVector3 pastePosition = BlockVector3.at((int)Numbers.floor(pasteLocation.getX()), (int)Numbers.floor(pasteLocation.getY()), (int)Numbers.floor(pasteLocation.getZ()));
        World faweWorld = Regions.toWEWorld(pasteLocation);
        if (!useOriginalOrigin) {
            schematic.setOrigin(schematic.getMinimumPoint());
        }
        ClipboardHolder holder = new ClipboardHolder(schematic);
        if (rotation != 0) {
            AffineTransform tr = new AffineTransform();
            tr = tr.rotateY((double)rotation);
            holder.setTransform((Transform)tr);
        }
        int i = 0;
        int blocks = 0;
        for (int y = schematic.getMinimumPoint().getY(); y <= schematic.getMaximumPoint().getY(); ++y) {
            for (int x = schematic.getMinimumPoint().getX(); x <= schematic.getMaximumPoint().getX(); ++x) {
                for (int z = schematic.getMinimumPoint().getZ(); z <= schematic.getMaximumPoint().getZ(); ++z) {
                    BaseBlock state = schematic.getFullBlock(BlockVector3.at((int)x, (int)y, (int)z));
                    double ax = pastePosition.getX() + x - schematic.getOrigin().getBlockX();
                    double ay = pastePosition.getY() + y - schematic.getOrigin().getBlockY();
                    double az = pastePosition.getZ() + z - schematic.getOrigin().getBlockZ();
                    if (state.getBlockType() == BlockTypes.AIR) continue;
                    if (++blocks % blocksPerTick == 0) {
                        ++i;
                    }
                    Schedulers.sync().runLater(() -> Regions.setBlock(faweWorld, BlockVector3.at((double)ax, (double)ay, (double)az), state), i);
                }
            }
        }
    }

    public static EditSession setBlock(World faweWorld, BlockVector3 position, BaseBlock to) {
        try (EditSession editSession = WorldEdit.getInstance().newEditSession(faweWorld);){
            editSession.setBlock(position, (BlockStateHolder)to);
            editSession.flushSession();
            EditSession editSession2 = editSession;
            return editSession2;
        }
        return null;
    }

    public static EditSession setBlocks(Region weRegion, BaseBlock to) {
        try (EditSession editSession = WorldEdit.getInstance().newEditSession(weRegion.getWorld());){
            editSession.setBlocks(weRegion, (BlockStateHolder)to);
            editSession.flushSession();
            EditSession editSession2 = editSession;
            return editSession2;
        }
        return null;
    }

    public static void undo(EditSession session) {
        try (EditSession editSession = WorldEdit.getInstance().newEditSession(session.getWorld());){
            session.undo(editSession);
            editSession.flushSession();
            Log.info("Undo completed");
        }
    }
}

