/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.random;

import com.google.common.base.Preconditions;
import io.lumine.mythic.bukkit.utils.random.Weighted;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class WeightedObject<T>
implements Weighted {
    private final T object;
    private final double weight;

    @Nonnull
    public static <T> WeightedObject<T> of(@Nonnull T object, double weight) {
        return new WeightedObject<T>(object, weight);
    }

    private WeightedObject(T object, double weight) {
        Preconditions.checkArgument((weight >= 0.0 ? 1 : 0) != 0, (Object)"weight cannot be negative");
        this.object = Objects.requireNonNull(object, "object");
        this.weight = weight;
    }

    @Nonnull
    public T get() {
        return this.object;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WeightedObject)) {
            return false;
        }
        WeightedObject other = (WeightedObject)o;
        return this.object.equals(other.object) && Double.compare(this.getWeight(), other.getWeight()) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.object.hashCode();
        result = result * 59 + (int)(Double.doubleToLongBits(this.getWeight()) >>> 32 ^ Double.doubleToLongBits(this.getWeight()));
        return result;
    }

    public String toString() {
        return "WeightedObject(object=" + String.valueOf(this.object) + ", weight=" + this.getWeight() + ")";
    }
}

