/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.particles;

import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.tasks.Task;
import io.lumine.mythic.bukkit.utils.terminable.Terminable;

public class ParticleEffect {

    public abstract class ParticleEffectAnimator
    implements Runnable,
    Terminable {
        private final int interval;
        private Task task;
        private int iteration = 0;

        public void start() {
            this.task = Schedulers.async().runRepeating(this, 0L, (long)this.interval);
        }

        @Override
        public void run() {
            this.tick(this.iteration);
            ++this.iteration;
        }

        public abstract void tick(int var1);

        @Override
        public void close() throws Exception {
            this.task.terminate();
        }

        public ParticleEffectAnimator(int interval) {
            this.interval = interval;
        }

        public int getInterval() {
            return this.interval;
        }

        public Task getTask() {
            return this.task;
        }

        public int getIteration() {
            return this.iteration;
        }

        public void setTask(Task task) {
            this.task = task;
        }

        public void setIteration(int iteration) {
            this.iteration = iteration;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParticleEffectAnimator)) {
                return false;
            }
            ParticleEffectAnimator other = (ParticleEffectAnimator)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getInterval() != other.getInterval()) {
                return false;
            }
            if (this.getIteration() != other.getIteration()) {
                return false;
            }
            Task this$task = this.getTask();
            Task other$task = other.getTask();
            return !(this$task == null ? other$task != null : !this$task.equals(other$task));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ParticleEffectAnimator;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getInterval();
            result = result * 59 + this.getIteration();
            Task $task = this.getTask();
            result = result * 59 + ($task == null ? 43 : $task.hashCode());
            return result;
        }

        public String toString() {
            return "ParticleEffect.ParticleEffectAnimator(interval=" + this.getInterval() + ", task=" + String.valueOf(this.getTask()) + ", iteration=" + this.getIteration() + ")";
        }
    }
}

