/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.numbers;

public class RangedInt {
    protected final Operation op;
    protected int min;
    protected int max;

    public RangedInt(String value) {
        this(value, false);
    }

    public RangedInt(String value, boolean squared) {
        if (value.contains("to")) {
            split = value.split("to");
            this.min = Integer.valueOf(split[0]);
            this.max = Integer.valueOf(split[1]);
            this.op = Operation.RANGE;
        } else if (!value.startsWith("-") && value.contains("-")) {
            split = value.split("-");
            this.min = Integer.valueOf(split[0]);
            this.max = Integer.valueOf(split[1]);
            this.op = Operation.RANGE;
        } else if (value.startsWith(">")) {
            s = value.substring(1);
            this.min = Integer.valueOf(s);
            this.max = Integer.MAX_VALUE;
            this.op = Operation.GREATER_THAN;
        } else if (value.startsWith("<")) {
            s = value.substring(1);
            this.min = Integer.MIN_VALUE;
            this.max = Integer.valueOf(s);
            this.op = Operation.LESS_THAN;
        } else {
            this.min = Integer.valueOf(value);
            this.max = Integer.valueOf(value);
            this.op = Operation.EQUALS;
        }
        if (this.min > this.max) {
            int i = this.min;
            this.min = this.max;
            this.max = i;
        }
        if (squared) {
            this.min *= this.min;
            this.max *= this.max;
        }
    }

    public Operation getOperation() {
        return this.op;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public boolean equals(Object o) {
        if (o instanceof Number) {
            int d = (Integer)o;
            switch (this.op.ordinal()) {
                case 0: {
                    return d == this.min;
                }
                case 1: {
                    return d > this.min;
                }
                case 2: {
                    return d < this.max;
                }
                case 3: {
                    return d >= this.min && d <= this.max;
                }
            }
            return true;
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        return "RangedInt{Amount=" + this.min + " to " + this.max + ", Operation=" + String.valueOf((Object)this.op) + "}";
    }

    public static enum Operation {
        EQUALS,
        GREATER_THAN,
        LESS_THAN,
        RANGE;

    }
}

