/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.menu.hotbar;

import io.lumine.mythic.bukkit.utils.menu.EditableIcon;
import io.lumine.mythic.bukkit.utils.menu.hotbar.HotbarMenu;
import io.lumine.mythic.bukkit.utils.menu.hotbar.HotbarMenuBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class EditableHotbarMenuBuilder<T> {
    private final HotbarMenuBuilder<T> builder;
    private final Map<String, EditableIcon<T>> icons;
    private final List<Integer> freeIcons;

    public Optional<EditableIcon<T>> getIcon(String key) {
        return Optional.ofNullable(this.icons.getOrDefault(key, null));
    }

    public HotbarMenu<T> build() {
        this.icons.values().forEach(eIcon -> eIcon.getSlots().forEach(slot -> this.builder.addIcon((int)slot, eIcon.getBuilder().build())));
        this.builder.unprotectedSlots(this.freeIcons);
        return this.builder.build();
    }

    public EditableHotbarMenuBuilder(HotbarMenuBuilder<T> builder, Map<String, EditableIcon<T>> icons, List<Integer> freeIcons) {
        this.builder = builder;
        this.icons = icons;
        this.freeIcons = freeIcons;
    }

    public HotbarMenuBuilder<T> getBuilder() {
        return this.builder;
    }

    public Map<String, EditableIcon<T>> getIcons() {
        return this.icons;
    }

    public List<Integer> getFreeIcons() {
        return this.freeIcons;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EditableHotbarMenuBuilder)) {
            return false;
        }
        EditableHotbarMenuBuilder other = (EditableHotbarMenuBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HotbarMenuBuilder<T> this$builder = this.getBuilder();
        HotbarMenuBuilder<T> other$builder = other.getBuilder();
        if (this$builder == null ? other$builder != null : !this$builder.equals(other$builder)) {
            return false;
        }
        Map<String, EditableIcon<T>> this$icons = this.getIcons();
        Map<String, EditableIcon<T>> other$icons = other.getIcons();
        if (this$icons == null ? other$icons != null : !((Object)this$icons).equals(other$icons)) {
            return false;
        }
        List<Integer> this$freeIcons = this.getFreeIcons();
        List<Integer> other$freeIcons = other.getFreeIcons();
        return !(this$freeIcons == null ? other$freeIcons != null : !((Object)this$freeIcons).equals(other$freeIcons));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EditableHotbarMenuBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HotbarMenuBuilder<T> $builder = this.getBuilder();
        result = result * 59 + ($builder == null ? 43 : $builder.hashCode());
        Map<String, EditableIcon<T>> $icons = this.getIcons();
        result = result * 59 + ($icons == null ? 43 : ((Object)$icons).hashCode());
        List<Integer> $freeIcons = this.getFreeIcons();
        result = result * 59 + ($freeIcons == null ? 43 : ((Object)$freeIcons).hashCode());
        return result;
    }

    public String toString() {
        return "EditableHotbarMenuBuilder(builder=" + String.valueOf(this.getBuilder()) + ", icons=" + String.valueOf(this.getIcons()) + ", freeIcons=" + String.valueOf(this.getFreeIcons()) + ")";
    }
}

