/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.locale;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.file.YamlConfiguration;

public final class Language {
    private static final Map<String, String> translations = Maps.newConcurrentMap();

    public static void loadLanguage(File languageFile) {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)languageFile);
        Set keys = config.getKeys(true);
        for (String key : keys) {
            if (!config.isString(key)) continue;
            translations.put(key, config.getString(key));
        }
    }

    public static String get(String key) {
        return Language.get(key, "");
    }

    public static String get(String key, String defaultValue) {
        return translations.getOrDefault(key, defaultValue);
    }
}

