/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.math3.analysis.solvers;

import io.lumine.mythic.bukkit.utils.lib.math3.analysis.solvers.AbstractUnivariateSolver;
import io.lumine.mythic.bukkit.utils.lib.math3.analysis.solvers.UnivariateSolverUtils;
import io.lumine.mythic.bukkit.utils.lib.math3.exception.TooManyEvaluationsException;
import io.lumine.mythic.bukkit.utils.lib.math3.util.FastMath;

public class BisectionSolver
extends AbstractUnivariateSolver {
    private static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;

    public BisectionSolver() {
        this(1.0E-6);
    }

    public BisectionSolver(double absoluteAccuracy) {
        super(absoluteAccuracy);
    }

    public BisectionSolver(double relativeAccuracy, double absoluteAccuracy) {
        super(relativeAccuracy, absoluteAccuracy);
    }

    protected double doSolve() throws TooManyEvaluationsException {
        double m4;
        double min2 = this.getMin();
        double max = this.getMax();
        this.verifyInterval(min2, max);
        double absoluteAccuracy = this.getAbsoluteAccuracy();
        do {
            m4 = UnivariateSolverUtils.midpoint(min2, max);
            double fmin = this.computeObjectiveValue(min2);
            double fm = this.computeObjectiveValue(m4);
            if (fm * fmin > 0.0) {
                min2 = m4;
                continue;
            }
            max = m4;
        } while (!(FastMath.abs(max - min2) <= absoluteAccuracy));
        m4 = UnivariateSolverUtils.midpoint(min2, max);
        return m4;
    }
}

