/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.DataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.JSONEntry;
import io.lumine.mythic.bukkit.utils.lib.jooq.JSONEntryValueStep;
import io.lumine.mythic.bukkit.utils.lib.jooq.Param;
import io.lumine.mythic.bukkit.utils.lib.jooq.Record1;
import io.lumine.mythic.bukkit.utils.lib.jooq.SQLDialect;
import io.lumine.mythic.bukkit.utils.lib.jooq.Scope;
import io.lumine.mythic.bukkit.utils.lib.jooq.Select;
import io.lumine.mythic.bukkit.utils.lib.jooq.conf.NestedCollectionEmulation;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractQueryPart;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.ConvertedDataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Keywords;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Names;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SQLDataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Val;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;

final class JSONEntryImpl<T>
extends AbstractQueryPart
implements JSONEntry<T>,
JSONEntryValueStep {
    static final Set<SQLDialect> SUPPORT_JSON_MERGE_PRESERVE = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
    private final Field<String> key;
    private final Field<T> value;

    JSONEntryImpl(Field<String> key) {
        this(key, null);
    }

    JSONEntryImpl(Field<String> key, Field<T> value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public final Field<String> key() {
        return this.key;
    }

    @Override
    public final Field<T> value() {
        return this.value;
    }

    public final <X> JSONEntry<X> value(X newValue) {
        return this.value(Tools.field(newValue));
    }

    public final <X> JSONEntry<X> value(Field<X> newValue) {
        return new JSONEntryImpl<X>(this.key, newValue);
    }

    public final <X> JSONEntry<X> value(Select<? extends Record1<X>> newValue) {
        return this.value(DSL.field(newValue));
    }

    @Override
    public void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case MARIADB: 
            case MYSQL: 
            case POSTGRES: 
            case SQLITE: 
            case YUGABYTEDB: {
                ctx.visit(this.key).sql(", ").visit(JSONEntryImpl.jsonCast(ctx, this.value));
                break;
            }
            default: {
                ctx.visit(Keywords.K_KEY).sql(' ').visit(this.key).sql(' ').visit(Keywords.K_VALUE).sql(' ').visit(JSONEntryImpl.jsonCast(ctx, this.value));
            }
        }
    }

    static final Function<? super Field<?>, ? extends Field<?>> jsonCastMapper(Context<?> ctx) {
        return field -> JSONEntryImpl.jsonCast(ctx, field);
    }

    static final Field<?> jsonCast(Context<?> ctx, Field<?> field) {
        DataType type = field.getDataType();
        switch (ctx.family()) {
            case H2: {
                if (JSONEntryImpl.isType(type, UUID.class)) {
                    return field.cast(SQLDataType.VARCHAR(36));
                }
                if (!type.isTemporal()) break;
                return field.cast(SQLDataType.VARCHAR);
            }
            case MARIADB: 
            case MYSQL: {
                if (!JSONEntryImpl.isType(type, Boolean.class)) break;
                return DSL.inlined(field);
            }
            case SQLITE: {
                if (!JSONEntryImpl.isType(type, Boolean.class)) break;
                return DSL.function(Names.N_JSON, SQLDataType.JSON, DSL.iif(DSL.condition(field), DSL.inline("true"), DSL.inline("false")));
            }
            case POSTGRES: 
            case YUGABYTEDB: {
                if (field instanceof Param) {
                    if (field.getType() != Object.class) {
                        return field.cast(field.getDataType());
                    }
                    return field.cast(SQLDataType.VARCHAR);
                }
                return field;
            }
        }
        return field;
    }

    static final <T> Field<T> unescapeNestedJSON(Scope ctx, Field<T> value) {
        if (JSONEntryImpl.isJSON(ctx, value.getDataType())) {
            switch (ctx.family()) {
                case MARIADB: 
                case MYSQL: 
                case SQLITE: {
                    return DSL.function(Names.N_JSON_EXTRACT, value.getDataType(), value, DSL.inline("$"));
                }
            }
        }
        return value;
    }

    static final boolean isType(DataType<?> t2, Class<?> type) {
        if (t2 instanceof ConvertedDataType) {
            t2 = ((ConvertedDataType)t2).delegate();
        }
        return t2.getType() == type;
    }

    static final boolean isJSON(Scope scope, DataType<?> t2) {
        if (t2 instanceof ConvertedDataType) {
            t2 = ((ConvertedDataType)t2).delegate();
        }
        return t2.isJSON() || t2.isEmbeddable() && Boolean.TRUE.equals(scope.data((Object)Tools.BooleanDataKey.DATA_MULTISET_CONTENT)) && JSONEntryImpl.emulateMultisetWithJSON(scope) || t2.isRecord() && Boolean.TRUE.equals(scope.data((Object)Tools.BooleanDataKey.DATA_MULTISET_CONTENT)) && JSONEntryImpl.emulateMultisetWithJSON(scope) || t2.isMultiset() && JSONEntryImpl.emulateMultisetWithJSON(scope);
    }

    private static final boolean emulateMultisetWithJSON(Scope scope) {
        return Tools.emulateMultiset(scope.configuration()) == NestedCollectionEmulation.JSON || Tools.emulateMultiset(scope.configuration()) == NestedCollectionEmulation.JSONB;
    }

    static final Field<?> booleanValAsVarchar(Field<?> field) {
        return field instanceof Val ? ((Val)field).convertTo0(SQLDataType.VARCHAR) : field;
    }

    static final Field<?> jsonMerge(Scope scope, String empty, Field<?> ... fields) {
        return DSL.function(SUPPORT_JSON_MERGE_PRESERVE.contains((Object)scope.dialect()) ? Names.N_JSON_MERGE_PRESERVE : Names.N_JSON_MERGE, fields[0].getDataType(), Tools.combine(DSL.inline(empty), fields));
    }

    @Override
    public final Field<String> $key() {
        return this.key;
    }

    @Override
    public final Field<?> $value() {
        return this.value;
    }
}

