/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Clause;
import io.lumine.mythic.bukkit.utils.lib.jooq.Condition;
import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.QueryPart;
import io.lumine.mythic.bukkit.utils.lib.jooq.RenderContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.Row;
import io.lumine.mythic.bukkit.utils.lib.jooq.SQLDialect;
import io.lumine.mythic.bukkit.utils.lib.jooq.Table;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractQueryPartMap;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import java.util.Map;
import java.util.Set;

final class FieldMapForUpdate
extends AbstractQueryPartMap<Field<?>, Field<?>>
implements QOM.UNotYetImplemented {
    private static final Set<SQLDialect> CASTS_NEEDED = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    private static final Set<SQLDialect> NO_SUPPORT_QUALIFY = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.YUGABYTEDB);
    private final Table<?> table;
    private final Clause assignmentClause;

    FieldMapForUpdate(Table<?> table, Clause assignmentClause) {
        this.table = table;
        this.assignmentClause = assignmentClause;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.size() > 0) {
            String separator = "";
            boolean supportsQualify = !NO_SUPPORT_QUALIFY.contains((Object)ctx.dialect()) && ctx.qualify();
            RenderContext.CastMode previous = ctx.castMode();
            if (!CASTS_NEEDED.contains((Object)ctx.dialect())) {
                ctx.castMode(RenderContext.CastMode.NEVER);
            }
            for (Map.Entry<Field<?>, Field<?>> entry : FieldMapForUpdate.removeReadonly(ctx, Tools.flattenEntrySet(this.entrySet(), true))) {
                if (!"".equals(separator)) {
                    ctx.sql(separator).formatSeparator();
                }
                ctx.start(this.assignmentClause).qualify(supportsQualify, c -> c.visit((QueryPart)entry.getKey())).sql(" = ");
                Condition condition = (Condition)ctx.data((Object)Tools.DataKey.DATA_ON_DUPLICATE_KEY_WHERE);
                if (condition != null) {
                    ctx.visit(DSL.when(condition, entry.getValue()).else_(entry.getKey()));
                } else {
                    ctx.visit(entry.getValue());
                }
                ctx.end(this.assignmentClause);
                separator = ",";
            }
            if (!CASTS_NEEDED.contains((Object)ctx.dialect())) {
                ctx.castMode(previous);
            }
        } else {
            ctx.sql("[ no fields are updated ]");
        }
    }

    static final Iterable<Map.Entry<Field<?>, Field<?>>> removeReadonly(Context<?> ctx, Iterable<Map.Entry<Field<?>, Field<?>>> it) {
        return it;
    }

    static final Row removeReadonly(Context<?> ctx, Row row) {
        return FieldMapForUpdate.removeReadonly(ctx, row, row);
    }

    static final Row removeReadonly(Context<?> ctx, Row checkRow, Row removeRow) {
        return removeRow;
    }

    final void set(Map<?, ?> map) {
        map.forEach((k, v) -> {
            Field<?> field = Tools.tableField(this.table, k);
            this.put(field, Tools.field(v, field));
        });
    }
}

