/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Binding;
import io.lumine.mythic.bukkit.utils.lib.jooq.BindingGetResultSetContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.BindingGetSQLInputContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.BindingGetStatementContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.BindingRegisterContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.BindingSQLContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.BindingSetSQLOutputContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.BindingSetStatementContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.Converter;
import io.lumine.mythic.bukkit.utils.lib.jooq.Converters;
import io.lumine.mythic.bukkit.utils.lib.jooq.ResourceManagingScope;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DefaultExecuteContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SQLDataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.jdbc.JDBCUtils;
import java.sql.Blob;
import java.sql.SQLException;

public class BlobBinding
implements Binding<byte[], byte[]> {
    @Override
    public final Converter<byte[], byte[]> converter() {
        return Converters.identity(byte[].class);
    }

    @Override
    public final void sql(BindingSQLContext<byte[]> ctx) throws SQLException {
        ctx.render().visit(DSL.val((Object)ctx.value(), SQLDataType.BLOB));
    }

    @Override
    public final void register(BindingRegisterContext<byte[]> ctx) throws SQLException {
        ctx.statement().registerOutParameter(ctx.index(), 2004);
    }

    @Override
    public final void set(BindingSetStatementContext<byte[]> ctx) throws SQLException {
        ctx.statement().setBlob(ctx.index(), BlobBinding.newBlob(ctx, ctx.value()));
    }

    @Override
    public final void set(BindingSetSQLOutputContext<byte[]> ctx) throws SQLException {
        ctx.output().writeBlob(BlobBinding.newBlob(ctx, ctx.value()));
    }

    @Override
    public final void get(BindingGetResultSetContext<byte[]> ctx) throws SQLException {
        Blob blob = ctx.resultSet().getBlob(ctx.index());
        try {
            ctx.value(blob == null ? null : blob.getBytes(1L, Tools.asInt(blob.length())));
        }
        finally {
            JDBCUtils.safeFree(blob);
        }
    }

    @Override
    public final void get(BindingGetStatementContext<byte[]> ctx) throws SQLException {
        Blob blob = ctx.statement().getBlob(ctx.index());
        try {
            ctx.value(blob == null ? null : blob.getBytes(1L, Tools.asInt(blob.length())));
        }
        finally {
            JDBCUtils.safeFree(blob);
        }
    }

    @Override
    public final void get(BindingGetSQLInputContext<byte[]> ctx) throws SQLException {
        Blob blob = ctx.input().readBlob();
        try {
            ctx.value(blob == null ? null : blob.getBytes(1L, Tools.asInt(blob.length())));
        }
        finally {
            JDBCUtils.safeFree(blob);
        }
    }

    static final Blob newBlob(ResourceManagingScope scope, byte[] bytes) throws SQLException {
        switch (scope.dialect()) {
            default: 
        }
        Blob blob = DefaultExecuteContext.localConnection().createBlob();
        scope.autoFree(blob);
        blob.setBytes(1L, bytes);
        return blob;
    }
}

