/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.config.properties.types;

import io.lumine.mythic.bukkit.utils.chat.ColorString;
import io.lumine.mythic.bukkit.utils.config.properties.PropertyType;
import io.lumine.mythic.bukkit.utils.plugin.LuminePlugin;
import org.bukkit.configuration.ConfigurationSection;

public class StringProp
extends PropertyType<String> {
    private final String defaultValue;

    public StringProp(LuminePlugin plugin, Object file, String node) {
        super(plugin, file, node);
        this.defaultValue = "";
    }

    public StringProp(LuminePlugin plugin, Object file, String node, String defaultValue) {
        super(plugin, file, node);
        this.defaultValue = defaultValue;
    }

    @Override
    protected String compute(ConfigurationSection section, String node) {
        if (section == null) {
            return this.defaultValue;
        }
        String prop = section.getString(node);
        if (prop == null) {
            return this.defaultValue;
        }
        String value = section.getString(node);
        return value == null ? null : ColorString.get(value);
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }
}

