/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;
import org.bukkit.entity.ZombieVillager;

public class BukkitZombieVillager
extends BukkitEntityType {
    private static final int height = 2;
    private double reinforcementChance = -1.0;
    private Villager.Profession villagerProfession;

    @Override
    public void instantiate(MythicConfig mc) {
        this.reinforcementChance = mc.getDouble("Options.ReinforcementsChance", -1.0);
        String prof = mc.getString("Options.Profession", "FARMER");
        try {
            this.villagerProfession = Villager.Profession.valueOf((String)prof.toUpperCase());
        }
        catch (Exception ex) {
            this.villagerProfession = Villager.Profession.FARMER;
        }
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        ZombieVillager e = (ZombieVillager)this.spawnEntity(location, EntityType.ZOMBIE_VILLAGER, reason, prespawnFunc);
        e.setBaby(false);
        e.setVillagerProfession(this.villagerProfession);
        e = (ZombieVillager)this.applyOptions((Entity)e);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        ZombieVillager e = (ZombieVillager)entity;
        if (this.reinforcementChance >= 0.0) {
            e.getAttribute(Attribute.ZOMBIE_SPAWN_REINFORCEMENTS).setBaseValue(this.reinforcementChance);
        }
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return BukkitZombieVillager.isInstanceOf(e);
    }

    public static boolean isInstanceOf(Entity e) {
        return e instanceof ZombieVillager;
    }

    @Override
    public int getHeight() {
        return 2;
    }
}

