/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.api.volatilecode.VolatileEntityType;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Snowman;

public class BukkitSnowman
extends BukkitEntityType {
    private static final int height = 2;
    private boolean preventSnowFormation = false;
    private boolean isDerp = false;

    @Override
    public void instantiate(MythicConfig mc) {
        this.preventSnowFormation = mc.getBoolean("Options.PreventSnowFormation", false);
        this.isDerp = mc.getBoolean("Options.Derp", false);
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        Entity e = this.spawnEntity(location, VolatileEntityType.SNOW_GOLEM, reason, prespawnFunc);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Snowman e = (Snowman)entity;
        e.setDerp(this.isDerp);
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Snowman;
    }

    @Override
    public int getHeight() {
        return 2;
    }

    public boolean getPreventSnowFormation() {
        return this.preventSnowFormation;
    }
}

