/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.entities.properties.AgeableProperty;
import java.util.function.Consumer;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Sheep;

public class BukkitSheep
extends BukkitEntityType {
    protected static final int height = 2;
    private AgeableProperty ageableProperty;
    protected DyeColor color;
    private boolean isSheared = false;

    @Override
    public void instantiate(MythicConfig mc) {
        this.ageableProperty = new AgeableProperty(mc);
        String strcolor = mc.getString("Options.Color", "WHITE");
        this.color = DyeColor.valueOf((String)strcolor);
        this.isSheared = mc.getBoolean("Options.Sheared", false);
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        Entity e = this.spawnEntity(location, EntityType.SHEEP, reason, prespawnFunc);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Sheep e = (Sheep)entity;
        this.ageableProperty.applyProperties(entity);
        e.setColor(this.color);
        e.setSheared(this.isSheared);
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Sheep;
    }

    @Override
    public int getHeight() {
        return 2;
    }

    public DyeColor getColor() {
        return this.color;
    }
}

