/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.compatibility;

import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.papi.PlaceholderManager;
import io.lumine.mythic.bukkit.utils.plugin.LuminePlugin;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.placeholders.PAPIPlaceholder;
import io.lumine.mythic.core.utils.annotations.AnnotationUtil;
import io.lumine.mythic.core.utils.annotations.MythicPAPIPlaceholder;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PlaceholderAPISupport
extends PlaceholderManager<MythicBukkit> {
    private PlaceholderTree placeholders = new PlaceholderTree(this);

    public PlaceholderAPISupport(MythicBukkit plugin) {
        super(plugin);
        this.registerPlaceholders(plugin, "io.lumine.mythic.core.skills.placeholders.papi");
    }

    public void registerPlaceholders(LuminePlugin plugin, String packageName) {
        Collection<Class<?>> placeholderClasses = AnnotationUtil.getAnnotatedClasses(plugin, packageName, MythicPAPIPlaceholder.class);
        for (Class<?> clazz : placeholderClasses) {
            try {
                String name = clazz.getAnnotation(MythicPAPIPlaceholder.class).placeholder();
                if (!PAPIPlaceholder.class.isAssignableFrom(clazz)) continue;
                Constructor<?> constructor = clazz.getConstructor(plugin.getClass());
                this.register(name, (PAPIPlaceholder)constructor.newInstance(plugin));
            }
            catch (Exception ex) {
                MythicLogger.error("Failed to load placeholder {0}", clazz.getCanonicalName());
                ex.printStackTrace();
            }
        }
    }

    @Override
    public String parse(String string) {
        return PlaceholderAPI.setPlaceholders(null, (String)string);
    }

    public String parse(String string, AbstractPlayer player) {
        return PlaceholderAPI.setPlaceholders((Player)((Player)player.getBukkitEntity()), (String)string);
    }

    public String onRequest(OfflinePlayer player, String identifier) {
        String[] split = identifier.split("_");
        ArrayList<String> argsList = new ArrayList<String>();
        PlaceholderTree ref = this.placeholders;
        for (int i = 0; i < split.length; ++i) {
            if (ref.getSubPlaceholders().containsKey(split[i])) {
                ref = ref.getSubPlaceholders().get(split[i]);
                continue;
            }
            argsList.add(split[i]);
        }
        String[] args = argsList.toArray(new String[0]);
        return ref.getPlaceholder().onPlaceholderRequest(player, args);
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return "mythic";
    }

    @Override
    @NotNull
    public String getVersion() {
        return "5.0.0";
    }

    public void register(String[] keys, PAPIPlaceholder transformer) {
        for (String key : keys) {
            this.register(key, transformer);
        }
    }

    public void register(String key, PAPIPlaceholder transformer) {
        String[] split = key.split("_");
        PlaceholderTree ref = this.placeholders;
        for (int i = 0; i <= split.length; ++i) {
            if (i == split.length) {
                ref.setPlaceholder(transformer);
                continue;
            }
            if (!ref.getSubPlaceholders().containsKey(split[i])) {
                ref.getSubPlaceholders().put(split[i], new PlaceholderTree(this));
            }
            ref = ref.getSubPlaceholders().get(split[i]);
        }
    }

    private class PlaceholderTree {
        private PAPIPlaceholder placeholder = null;
        private Map<String, PlaceholderTree> subPlaceholders = new HashMap<String, PlaceholderTree>();

        public PlaceholderTree(PlaceholderAPISupport placeholderAPISupport) {
        }

        public PAPIPlaceholder getPlaceholder() {
            return this.placeholder;
        }

        public Map<String, PlaceholderTree> getSubPlaceholders() {
            return this.subPlaceholders;
        }

        public void setPlaceholder(PAPIPlaceholder placeholder) {
            this.placeholder = placeholder;
        }

        public void setSubPlaceholders(Map<String, PlaceholderTree> subPlaceholders) {
            this.subPlaceholders = subPlaceholders;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PlaceholderTree)) {
                return false;
            }
            PlaceholderTree other = (PlaceholderTree)o;
            if (!other.canEqual(this)) {
                return false;
            }
            PAPIPlaceholder this$placeholder = this.getPlaceholder();
            PAPIPlaceholder other$placeholder = other.getPlaceholder();
            if (this$placeholder == null ? other$placeholder != null : !this$placeholder.equals(other$placeholder)) {
                return false;
            }
            Map<String, PlaceholderTree> this$subPlaceholders = this.getSubPlaceholders();
            Map<String, PlaceholderTree> other$subPlaceholders = other.getSubPlaceholders();
            return !(this$subPlaceholders == null ? other$subPlaceholders != null : !((Object)this$subPlaceholders).equals(other$subPlaceholders));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PlaceholderTree;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PAPIPlaceholder $placeholder = this.getPlaceholder();
            result = result * 59 + ($placeholder == null ? 43 : $placeholder.hashCode());
            Map<String, PlaceholderTree> $subPlaceholders = this.getSubPlaceholders();
            result = result * 59 + ($subPlaceholders == null ? 43 : ((Object)$subPlaceholders).hashCode());
            return result;
        }

        public String toString() {
            return "PlaceholderAPISupport.PlaceholderTree(placeholder=" + String.valueOf(this.getPlaceholder()) + ", subPlaceholders=" + String.valueOf(this.getSubPlaceholders()) + ")";
        }
    }
}

