/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.compatibility;

import io.lumine.mythic.api.adapters.AbstractBlock;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.api.drops.IItemDrop;
import io.lumine.mythic.api.items.ItemSupplier;
import io.lumine.mythic.api.volatilecode.virtual.PacketFallingBlock;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.events.MythicDropLoadEvent;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.core.drops.droppables.ItemDrop;
import io.lumine.mythic.core.logging.MythicLogger;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.logging.Level;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.block.CustomBlock;
import net.Indyuce.mmoitems.api.droptable.item.MMOItemDropItem;
import net.Indyuce.mmoitems.api.player.PlayerData;
import net.Indyuce.mmoitems.api.util.MushroomState;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class MMOItemsSupport
extends ReloadableModule<MythicBukkit>
implements ItemSupplier {
    public MMOItemsSupport(MythicBukkit plugin) {
        super(plugin);
    }

    @Override
    public void load(MythicBukkit plugin) {
        Events.subscribe(MythicDropLoadEvent.class).handler(event -> {
            if (event.getDropName().equalsIgnoreCase("mmoitems") || event.getDropName().equalsIgnoreCase("mmoitem")) {
                event.register(new MMOItemsDrop(this, event.getDropName(), event.getConfig()));
            }
        }).bindWith(this);
    }

    @Override
    public void unload() {
    }

    @Override
    public String getNamespace() {
        return "mmoitems";
    }

    @Override
    public ItemStack getItem(String name) {
        return this.getCustomItem(name);
    }

    @Override
    public boolean isSimilar(String name, ItemStack itemStack) {
        return false;
    }

    @Override
    public Collection<String> getAvailableItemNames() {
        return Collections.emptyList();
    }

    public boolean isMMOItem(ItemStack itemStack) {
        return ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getItemHandler().getNBTData(itemStack).containsKey("MMOITEMS_ITEM_ID");
    }

    public boolean checkCustomBlock(Block block, int id) {
        Optional optional = MMOItems.plugin.getCustomBlocks().getFromBlock(block.getBlockData());
        if (optional.isPresent()) {
            CustomBlock custom = (CustomBlock)optional.get();
            return id == custom.getId();
        }
        return false;
    }

    public Material getCustomBlockMaterial(int id) {
        return MMOItems.plugin.getCustomBlocks().getBlock(id).getState().getType();
    }

    public MushroomState getCustomBlockState(int id) {
        return MMOItems.plugin.getCustomBlocks().getBlock(id).getState();
    }

    public AbstractBlock getMMOItemsBlock(int id) {
        return new MMOItemsBlock(id);
    }

    public ItemStack getCustomItem(String string) {
        try {
            String[] split = string.split("\\.");
            String typeFormat = split[0].toUpperCase().replace("-", "_");
            Type type = MMOItems.plugin.getTypes().get(typeFormat);
            String id = split[1];
            return MMOItems.plugin.getItems().getItem(type, id);
        }
        catch (IllegalArgumentException exception) {
            MythicLogger.error("Could not load drop item: " + exception.getMessage());
            return new ItemStack(Material.ZOMBIE_HORSE_SPAWN_EGG);
        }
    }

    public AbstractBlock getCustomMMOBlock(int id) {
        return new MMOItemsBlock(id);
    }

    public class MMOItemsBlock
    extends AbstractBlock {
        private final CustomBlock block;

        public MMOItemsBlock(int id) {
            this.block = MMOItems.plugin.getCustomBlocks().getBlock(id);
        }

        @Override
        public void set(AbstractLocation location) {
            this.set(location, true);
        }

        @Override
        public void set(AbstractLocation location, boolean physics) {
            if (this.block != null) {
                Location loc = BukkitAdapter.adapt(location);
                loc.getBlock().setBlockData(this.block.getState().getBlockData(), physics);
            }
        }

        @Override
        public boolean matches(AbstractLocation location) {
            Block block = BukkitAdapter.adapt(location).getBlock();
            return ((MythicBukkit)MMOItemsSupport.this.getPlugin()).getCompatibility().getMMOItems().get().checkCustomBlock(block, this.block.getId());
        }

        @Override
        public PacketFallingBlock createFakeEntity(AbstractLocation location) {
            return new PacketFallingBlock(location, this.block.getState().getBlockData());
        }

        @Override
        @Nullable
        public BlockData getBlockData() {
            return this.block.getState().getBlockData();
        }

        public boolean equals(Object o) {
            if (o instanceof MMOItemsBlock) {
                MMOItemsBlock block = (MMOItemsBlock)o;
                return block.getBlock().equals(this.block);
            }
            return false;
        }

        public int hashCode() {
            return this.block.hashCode();
        }

        public CustomBlock getBlock() {
            return this.block;
        }
    }

    public class MMOItemsDrop
    extends ItemDrop
    implements IItemDrop {
        private Type type;
        private String id;
        private MMOItemDropItem dropItem;

        public MMOItemsDrop(MMOItemsSupport this$0, String line, MythicLineConfig config) {
            super(line, config);
            try {
                String typeFormat = config.getString("type").toUpperCase().replace("-", "_");
                Validate.isTrue((boolean)MMOItems.plugin.getTypes().has(typeFormat), (String)("Could not find type with ID " + typeFormat));
                this.type = MMOItems.plugin.getTypes().get(typeFormat);
                this.id = config.getString("id");
                Validate.notNull((Object)this.id, (String)"MMOItems ID cannot be null");
                this.dropItem = new MMOItemDropItem(this.type, this.id, 1.0, config.getDouble("unidentified", 0.0), 1, 1);
            }
            catch (IllegalArgumentException exception) {
                MMOItems.plugin.getLogger().log(Level.WARNING, "Could not load drop item: " + exception.getMessage());
                return;
            }
        }

        @Override
        public AbstractItemStack getDrop(DropMetadata metadata, double amount) {
            if (this.dropItem != null) {
                PlayerData playerData = metadata.getTrigger() != null && metadata.getTrigger().isPlayer() ? PlayerData.get((OfflinePlayer)((Player)metadata.getTrigger().getBukkitEntity())) : null;
                ItemStack itemStack = this.dropItem.getItem(playerData, Numbers.round(amount));
                if (itemStack == null) {
                    MythicLogger.errorCompatibility("MMOITEMS", "Item type " + this.type.getId() + "." + this.id + " not found");
                    return BukkitAdapter.adapt(Material.STONE);
                }
                return BukkitAdapter.adapt(itemStack);
            }
            return BukkitAdapter.adapt(Material.STONE);
        }

        public Type getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public MMOItemDropItem getDropItem() {
            return this.dropItem;
        }
    }
}

