/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.commands.items.edit;

import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.commands.items.edit.EditEnchantsCommand;
import io.lumine.mythic.bukkit.commands.items.edit.EditLoreCommand;
import io.lumine.mythic.bukkit.commands.items.edit.EditStatsCommand;
import io.lumine.mythic.bukkit.utils.caffeine.cache.Cache;
import io.lumine.mythic.bukkit.utils.caffeine.cache.Caffeine;
import io.lumine.mythic.bukkit.utils.commands.Command;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.core.menus.items.ItemEditorMenuContext;
import io.lumine.mythic.core.menus.items.ItemMenuContext;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ItemEditCommand
extends Command<MythicBukkit> {
    public static Cache<UUID, ItemEditorMenuContext> lastEdited = Caffeine.newBuilder().maximumSize(50L).expireAfterWrite(Duration.ofMinutes(5L)).build();

    public ItemEditCommand(Command<MythicBukkit> parent) {
        super(parent);
        this.addSubCommands(new EditLoreCommand(this), new EditStatsCommand(this), new EditEnchantsCommand(this));
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        MythicBukkit cfr_ignored_0 = (MythicBukkit)this.getPlugin();
        if (!MythicBukkit.isVolatile()) {
            CommandHelper.sendError(sender, "This feature requires Mythic Premium");
            return true;
        }
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            return true;
        }
        String itemName = args[0];
        Optional<MythicItem> maybeItem = ((MythicBukkit)this.getPlugin()).getItemManager().getItem(itemName);
        if (maybeItem.isEmpty()) {
            CommandHelper.sendError(sender, "Invalid Item Name");
            return true;
        }
        MythicItem item = maybeItem.get();
        ItemEditorMenuContext ctx = lastEdited.getIfPresent(player.getUniqueId());
        if (ctx == null) {
            ItemMenuContext btx = new ItemMenuContext();
            ctx = new ItemEditorMenuContext(item, btx);
        } else {
            lastEdited.invalidate(player.getUniqueId());
        }
        ((MythicBukkit)this.getPlugin()).getMenuManager().getItemEditorMenu().open(player, ctx);
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return Collections.emptyList();
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.items.edit";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "edit";
    }
}

