/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.adapters.item;

import io.lumine.mythic.api.adapters.AbstractAttributeModifier;
import io.lumine.mythic.api.adapters.AbstractItemFlag;
import io.lumine.mythic.api.adapters.AbstractItemStackRarity;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.bukkit.utils.text.Text;
import io.lumine.mythic.core.drops.EquipSlot;
import io.lumine.mythic.core.utils.jnbt.CompoundTag;
import io.lumine.mythic.core.utils.jnbt.Tag;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemRarity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.Repairable;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.Nullable;

public class ItemComponentBukkitItemStack
extends BukkitItemStack {
    public ItemComponentBukkitItemStack(ItemStack itemStack) {
        super(itemStack);
    }

    public boolean isFireResistant() {
        return Optional.ofNullable(this.getItemMeta()).map(ItemMeta::isFireResistant).orElse(false);
    }

    @Nullable
    public AbstractItemStackRarity getRarity() {
        return Optional.ofNullable(this.getItemMeta()).map(ItemMeta::getRarity).map(rarity -> switch (rarity) {
            default -> throw new MatchException(null, null);
            case ItemRarity.EPIC -> AbstractItemStackRarity.EPIC;
            case ItemRarity.RARE -> AbstractItemStackRarity.RARE;
            case ItemRarity.UNCOMMON -> AbstractItemStackRarity.UNCOMMON;
            case ItemRarity.COMMON -> AbstractItemStackRarity.COMMON;
        }).orElse(null);
    }

    public BukkitItemStack clone() {
        return new ItemComponentBukkitItemStack(this.itemStack.clone());
    }

    @Override
    public ItemComponentBukkitItemStack editMeta(Consumer<ItemMeta> block) {
        ItemMeta meta = this.itemStack.getItemMeta();
        block.accept(meta);
        this.itemStack.setItemMeta(meta);
        return this;
    }

    @Override
    public ItemComponentBukkitItemStack setName(String name) {
        return this.name(Text.parse(name));
    }

    @Override
    public ItemComponentBukkitItemStack name(Component component) {
        return this.editMeta(meta -> meta.displayName(component));
    }

    @Override
    public ItemComponentBukkitItemStack setLore(List<String> lore) {
        return this.lore((List)lore.stream().map(Text::parse).toList());
    }

    @Override
    public ItemComponentBukkitItemStack lore(List<Component> lines) {
        return this.editMeta(meta -> meta.lore(lines));
    }

    @Override
    public ItemComponentBukkitItemStack amount(int amount) {
        this.itemStack.setAmount(amount);
        return this;
    }

    @Override
    @Deprecated
    public ItemComponentBukkitItemStack data(int data) {
        this.itemStack.setDurability((short)data);
        return this;
    }

    @Override
    public boolean isBreakable() {
        return Optional.ofNullable(this.getItemMeta()).map(ItemMeta::isUnbreakable).orElse(true) == false;
    }

    @Override
    public ItemComponentBukkitItemStack breakable(boolean breakable) {
        return this.editMeta(meta -> meta.setUnbreakable(!breakable));
    }

    @Override
    public ItemComponentBukkitItemStack hideAll() {
        return this.flags(Arrays.asList(AbstractItemFlag.values()));
    }

    @Override
    public ItemComponentBukkitItemStack flags(Collection<AbstractItemFlag> flags) {
        this.editMeta(meta -> meta.addItemFlags((ItemFlag[])flags.stream().map(BukkitAdapter::adapt).toArray(ItemFlag[]::new)));
        return this;
    }

    @Override
    public int getRepairCost() {
        return Optional.ofNullable(this.getItemMeta()).map(meta -> {
            if (meta instanceof Repairable) {
                Repairable repairable = (Repairable)meta;
                return repairable.getRepairCost();
            }
            return 0;
        }).orElse(0);
    }

    @Override
    public ItemComponentBukkitItemStack repairCost(int repairCost) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta instanceof Repairable) {
            Repairable repairable = (Repairable)meta;
            repairable.setRepairCost(repairCost);
            this.itemStack.setItemMeta((ItemMeta)repairable);
        }
        return this;
    }

    @Override
    public ItemComponentBukkitItemStack maxStackSize(int maxStackSize) {
        return this.editMeta(meta -> meta.setMaxStackSize(Integer.valueOf(maxStackSize)));
    }

    @Override
    public ItemComponentBukkitItemStack modelData(int modelData) {
        return this.editMeta(meta -> meta.setCustomModelData(Integer.valueOf(modelData)));
    }

    @Override
    public ItemComponentBukkitItemStack addAttributeModifier(AbstractAttributeModifier modifier) {
        Attribute attribute = (Attribute)Registry.ATTRIBUTE.get(NamespacedKey.minecraft((String)modifier.key()));
        if (attribute == null) {
            throw new IllegalArgumentException("Unknown attribute '" + modifier.key() + "'");
        }
        UUID uniqueId = UUID.randomUUID();
        EquipSlot abstractSlot = modifier.slot();
        if (abstractSlot == null || abstractSlot == EquipSlot.NONE) {
            return this.editMeta(meta -> meta.addAttributeModifier(attribute, new AttributeModifier(uniqueId, uniqueId.toString(), modifier.value().get(), AttributeModifier.Operation.values()[modifier.operation().getOperation()])));
        }
        EquipmentSlot slot = modifier.slot().getBukkitSlot();
        if (slot == null) {
            throw new IllegalStateException("Unexpected value: " + String.valueOf(modifier.slot()));
        }
        return this.editMeta(meta -> meta.addAttributeModifier(attribute, new AttributeModifier(uniqueId, uniqueId.toString(), modifier.value().get(), AttributeModifier.Operation.values()[modifier.operation().getOperation()], slot)));
    }

    @Override
    public ItemComponentBukkitItemStack skullOwner(String username) {
        return this.skullData(username, null, null, null);
    }

    @Override
    public ItemComponentBukkitItemStack skullOwner(String username, UUID uniqueId) {
        return this.skullData(username, uniqueId, null, null);
    }

    @Override
    public ItemComponentBukkitItemStack skullTexture(String texture) {
        return this.skullData(null, null, texture, null);
    }

    @Override
    public ItemComponentBukkitItemStack skullTexture(String texture, String url) {
        return this.skullData(null, null, texture, url);
    }

    @Override
    public ItemComponentBukkitItemStack skullTexture(UUID uuid, String texture, String url) {
        return this.skullData(null, uuid, texture, url);
    }

    @Override
    public ItemComponentBukkitItemStack enchant(Enchantment enchantment, int level) {
        if (this.itemStack.getType() != Material.ENCHANTED_BOOK) {
            this.itemStack.addUnsafeEnchantment(enchantment, level);
        } else {
            this.editMeta(m4 -> ((EnchantmentStorageMeta)m4).addStoredEnchant(enchantment, level, true));
        }
        return this;
    }

    @Override
    public ItemComponentBukkitItemStack enchantmentGlow(boolean glow) {
        return this.editMeta(meta -> meta.setEnchantmentGlintOverride(Boolean.valueOf(glow)));
    }

    @Override
    public int getDurability() {
        return Optional.ofNullable(this.getItemMeta()).map(meta -> {
            if (meta instanceof Damageable) {
                Damageable damageable = (Damageable)meta;
                return damageable.getDamage();
            }
            return 0;
        }).orElse(0);
    }

    @Override
    public ItemComponentBukkitItemStack durability(int durability) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta instanceof Damageable) {
            Damageable damageable = (Damageable)meta;
            damageable.setDamage(durability);
            this.itemStack.setItemMeta(meta);
        }
        return this;
    }

    @Override
    public int getMaxDurability() {
        return Optional.ofNullable(this.getItemMeta()).map(meta -> {
            Damageable damageable;
            if (meta instanceof Damageable && (damageable = (Damageable)meta).hasMaxDamage()) {
                return damageable.getMaxDamage();
            }
            return 0;
        }).orElse(0);
    }

    @Override
    public ItemComponentBukkitItemStack maxDurability(int durability) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta instanceof Damageable) {
            Damageable damageable = (Damageable)meta;
            damageable.setMaxDamage(Integer.valueOf(durability));
            this.itemStack.setItemMeta(meta);
        }
        return this;
    }

    @Override
    public ItemComponentBukkitItemStack canPlaceOn(Collection<Material> materials) {
        this.itemStack = handler.setCanPlaceOn(this.itemStack, materials);
        return this;
    }

    @Override
    public ItemComponentBukkitItemStack canBreak(Collection<Material> materials) {
        this.itemStack = handler.setCanBreak(this.itemStack, materials);
        return this;
    }

    @Override
    public ItemComponentBukkitItemStack potionEffect(PotionEffectType type, int duration, int amplifier) {
        ItemMeta itemMeta = this.getItemMeta();
        if (itemMeta instanceof PotionMeta) {
            PotionMeta meta = (PotionMeta)itemMeta;
            meta.addCustomEffect(new PotionEffect(type, duration, amplifier), true);
            this.itemStack.setItemMeta((ItemMeta)meta);
        }
        return this;
    }

    @Override
    public ItemComponentBukkitItemStack color(int r, int g2, int b) {
        ItemMeta meta = this.itemStack.getItemMeta();
        Color color = Color.fromRGB((int)r, (int)g2, (int)b);
        if (meta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)meta;
            potionMeta.setColor(color);
        } else if (meta instanceof LeatherArmorMeta) {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)meta;
            leatherArmorMeta.setColor(color);
        }
        this.itemStack.setItemMeta(meta);
        return this;
    }

    @Override
    public CompoundTag getCustomData() {
        return handler.getNBTData(this.itemStack);
    }

    @Override
    public ItemComponentBukkitItemStack customData(String key, Tag value) {
        this.itemStack = handler.addNBTData(this.itemStack, key, value);
        return this;
    }

    @Override
    public ItemComponentBukkitItemStack customData(CompoundTag tag) {
        tag.getValue().forEach(this::customData);
        return this;
    }

    @Override
    public ItemComponentBukkitItemStack copy() {
        return new ItemComponentBukkitItemStack(this.itemStack.clone());
    }

    private ItemComponentBukkitItemStack skullData(String username, UUID uniqueId, String texture, String url) {
        this.itemStack = handler.setSkinData(this.itemStack, username, uniqueId, texture, url);
        return this;
    }

    public ItemComponentBukkitItemStack fireResistant(boolean fireResistant) {
        return this.editMeta(meta -> meta.setFireResistant(fireResistant));
    }

    public ItemComponentBukkitItemStack rarity(AbstractItemStackRarity rarity) {
        return this.editMeta(meta -> meta.setRarity(switch (rarity) {
            default -> throw new MatchException(null, null);
            case AbstractItemStackRarity.COMMON -> ItemRarity.COMMON;
            case AbstractItemStackRarity.UNCOMMON -> ItemRarity.UNCOMMON;
            case AbstractItemStackRarity.RARE -> ItemRarity.RARE;
            case AbstractItemStackRarity.EPIC -> ItemRarity.EPIC;
        }));
    }
}

