/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.adapters;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractSkillAdapter;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.damage.DamageMetadata;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.events.MythicDamageEvent;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.items.ItemFactory;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.mechanics.ShootFireballMechanic;
import io.lumine.mythic.core.skills.mechanics.ShootMechanic;
import io.lumine.mythic.core.skills.mechanics.ShootShulkerMechanic;
import io.lumine.mythic.core.utils.MythicUtil;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Creature;
import org.bukkit.entity.DragonFireball;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Item;
import org.bukkit.entity.LargeFireball;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.entity.SizedFireball;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Trident;
import org.bukkit.entity.WitherSkull;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Lever;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class BukkitSkillAdapter
implements AbstractSkillAdapter {
    public BukkitSkillAdapter(MythicBukkit plugin) {
    }

    @Override
    public void doDamage(DamageMetadata meta, AbstractEntity aTarget) {
        MythicDamageEvent damageEvent = Events.callAndReturn(new MythicDamageEvent(meta.getDamager(), aTarget, meta));
        if (damageEvent.isCancelled()) {
            return;
        }
        MythicBukkit.inst().getVolatileCodeHandler().getEntityHandler().doDamage(meta, aTarget);
    }

    @Override
    public void strikeLightning(AbstractLocation source) {
        BukkitAdapter.adapt(source.getWorld()).strikeLightning(BukkitAdapter.adapt(source));
    }

    @Override
    public void strikeLightningEffect(AbstractLocation source) {
        BukkitAdapter.adapt(source.getWorld()).strikeLightningEffect(BukkitAdapter.adapt(source));
    }

    @Override
    public void shootFireball(SkillCaster am, ShootFireballMechanic.FireballType type, AbstractLocation origin, AbstractLocation target, float velocity, float yield, boolean incendiary, int fireTicks, boolean playsound, boolean charged, AbstractItemStack item) {
        Vector facing;
        if (target == null) {
            return;
        }
        Location bukkitTargetLocation = BukkitAdapter.adapt(target);
        Entity bukkitShooter = BukkitAdapter.adapt(am.getEntity());
        Location bukkitOrigin = origin == null ? bukkitShooter.getLocation().clone().add(0.0, 1.0, 0.0) : BukkitAdapter.adapt(origin);
        Fireball fireball = null;
        if (bukkitShooter instanceof Creature && ((Creature)bukkitShooter).getTarget() == target && origin != null) {
            switch (type) {
                case NORMAL: {
                    fireball = (Fireball)((LivingEntity)bukkitShooter).launchProjectile(Fireball.class);
                    break;
                }
                case SMALL: {
                    fireball = (Fireball)((LivingEntity)bukkitShooter).launchProjectile(SmallFireball.class);
                    break;
                }
                case LARGE: {
                    fireball = (Fireball)((LivingEntity)bukkitShooter).launchProjectile(LargeFireball.class);
                    break;
                }
                case WITHER: {
                    fireball = (Fireball)((LivingEntity)bukkitShooter).launchProjectile(WitherSkull.class);
                    break;
                }
                case DRAGON: {
                    fireball = (Fireball)((LivingEntity)bukkitShooter).launchProjectile(DragonFireball.class);
                    break;
                }
                case ITEM: {
                    fireball = (Fireball)((LivingEntity)bukkitShooter).launchProjectile(SizedFireball.class);
                }
            }
        } else {
            facing = bukkitTargetLocation.toVector().subtract(bukkitOrigin.toVector()).normalize();
            double yaw = Math.toDegrees(Math.atan2(-facing.getX(), facing.getZ()));
            double pitch = Math.toDegrees(-Math.asin(facing.getY()));
            bukkitOrigin.setYaw((float)yaw);
            bukkitOrigin.setPitch((float)pitch);
            bukkitOrigin.add(facing.multiply(2));
            switch (type) {
                case NORMAL: {
                    fireball = (Fireball)bukkitOrigin.getWorld().spawn(bukkitOrigin, Fireball.class);
                    break;
                }
                case SMALL: {
                    fireball = (Fireball)bukkitOrigin.getWorld().spawn(bukkitOrigin, SmallFireball.class);
                    break;
                }
                case LARGE: {
                    fireball = (Fireball)bukkitOrigin.getWorld().spawn(bukkitOrigin, LargeFireball.class);
                    break;
                }
                case WITHER: {
                    fireball = (Fireball)bukkitOrigin.getWorld().spawn(bukkitOrigin, WitherSkull.class);
                    ((WitherSkull)fireball).setCharged(charged);
                    break;
                }
                case DRAGON: {
                    fireball = (Fireball)bukkitOrigin.getWorld().spawn(bukkitOrigin, DragonFireball.class);
                    break;
                }
                case ITEM: {
                    fireball = (Fireball)bukkitOrigin.getWorld().spawn(bukkitOrigin, SizedFireball.class);
                    ((SizedFireball)fireball).setDisplayItem(BukkitAdapter.adapt(item));
                }
            }
        }
        if (playsound) {
            bukkitShooter.getWorld().playEffect(bukkitShooter.getLocation(), Effect.GHAST_SHOOT, 0);
        }
        facing = bukkitTargetLocation.toVector().subtract(bukkitOrigin.toVector()).normalize().multiply(velocity);
        fireball.setVelocity(facing);
        fireball.setBounce(false);
        fireball.setIsIncendiary(incendiary);
        fireball.setFireTicks(fireTicks);
        fireball.setYield(yield);
        if (bukkitShooter instanceof LivingEntity) {
            fireball.setShooter((ProjectileSource)((LivingEntity)bukkitShooter));
        }
    }

    @Override
    public AbstractEntity shootProjectile(SkillCaster caster, AbstractLocation target, AbstractLocation origin, Class<? extends Projectile> projectileClass, AbstractVector velocity, ShootMechanic mechanic) {
        Projectile projectile;
        LivingEntity l = (LivingEntity)caster.getEntity().getBukkitEntity();
        Location fTarget = BukkitAdapter.adapt(target);
        Vector vector = BukkitAdapter.adapt(velocity);
        if (Double.isNaN(vector.getX())) {
            vector.setX(0);
        }
        if (Double.isNaN(vector.getY())) {
            vector.setY(0);
        }
        if (Double.isNaN(vector.getZ())) {
            vector.setZ(0);
        }
        if (target == null) {
            projectile = l.launchProjectile(projectileClass, vector);
        } else if (mechanic.getFromOrigin().booleanValue()) {
            Location fOrigin = BukkitAdapter.adapt(origin);
            projectile = (Projectile)fTarget.getWorld().spawn(fOrigin, projectileClass);
            projectile.setVelocity(vector);
        } else {
            projectile = l.launchProjectile(projectileClass, vector);
        }
        if (projectile instanceof AbstractArrow) {
            ItemStack is;
            String tridentItem;
            if (!mechanic.getCanPickup().booleanValue()) {
                ((AbstractArrow)projectile).setPickupStatus(AbstractArrow.PickupStatus.DISALLOWED);
            }
            ((AbstractArrow)projectile).setKnockbackStrength(mechanic.getKnockbackStrength());
            ((AbstractArrow)projectile).setPierceLevel(mechanic.getPierceLevel());
            if (projectile instanceof Trident && !(tridentItem = mechanic.getTridentItem().get(caster)).isEmpty() && (is = BukkitAdapter.adapt(MythicBukkit.inst().getBootstrap().createItem(tridentItem))) != null) {
                MythicBukkit.inst().getVolatileCodeHandler().getItemHandler().setTridentItem((Trident)projectile, is);
            }
        } else if (projectile instanceof ThrownPotion) {
            ItemFactory potionItem = mechanic.getProjectileType() == ShootMechanic.ProjectileType.LINGERING_POTION ? ItemFactory.of(Material.LINGERING_POTION) : ItemFactory.of(Material.SPLASH_POTION);
            PotionEffectType potionType = PotionEffectType.getByName((String)mechanic.getPotionEffectType().get(caster));
            int potionDuration = mechanic.getPotionDuration().get(caster);
            int potionAmplifier = mechanic.getPotionAmplifier().get(caster);
            potionItem.potionEffect(potionType, potionDuration, potionAmplifier);
            potionItem.color(mechanic.getPotionColor());
            ((ThrownPotion)projectile).setItem(potionItem.build());
        }
        projectile.setBounce(mechanic.getBounce().booleanValue());
        projectile.setShooter((ProjectileSource)l);
        return BukkitAdapter.adapt((Entity)projectile);
    }

    @Override
    public AbstractEntity shootArcProjectile(SkillCaster caster, AbstractLocation target, AbstractLocation origin, Class<? extends Projectile> projectileClass, float velocity, boolean fromOrigin) {
        Projectile projectile;
        Location from;
        int gravity = 20;
        LivingEntity l = (LivingEntity)caster.getEntity().getBukkitEntity();
        Location to = BukkitAdapter.adapt(target);
        if (fromOrigin) {
            Location fOrigin;
            from = fOrigin = BukkitAdapter.adapt(origin);
            projectile = (Projectile)from.getWorld().spawn(fOrigin, projectileClass);
        } else {
            from = l.getLocation();
            projectile = l.launchProjectile(projectileClass);
        }
        projectile.setBounce(false);
        projectile.setShooter((ProjectileSource)l);
        Vector test = to.clone().subtract(from).toVector();
        Double elevation = test.getY();
        Double launchAngle = MythicUtil.calculateLaunchAngle(from, to, velocity, elevation, 20.0);
        Double distance = Math.sqrt(Math.pow(test.getX(), 2.0) + Math.pow(test.getZ(), 2.0));
        if (launchAngle == null) {
            launchAngle = Math.atan((40.0 * elevation + Math.pow(velocity, 2.0)) / (40.0 * elevation + 2.0 * Math.pow(velocity, 2.0)));
        }
        Double hangtime = MythicUtil.calculateHangtime(launchAngle, velocity, elevation, 20.0);
        test.setY(Math.tan(launchAngle) * distance);
        test = MythicUtil.normalizeVector(test);
        velocity = (float)((double)velocity + 1.188 * Math.pow(hangtime, 2.0) + (Numbers.randomDouble() - 0.8) / 2.0);
        test = test.multiply((double)velocity / 20.0);
        projectile.setVelocity(test);
        return BukkitAdapter.adapt((Entity)projectile);
    }

    @Override
    public AbstractEntity rainProjectile(SkillCaster caster, AbstractLocation source, Class<? extends Projectile> projectileClass, float velocity) {
        LivingEntity l = (LivingEntity)caster.getEntity().getBukkitEntity();
        Location s2 = BukkitAdapter.adapt(source);
        Projectile projectile = (Projectile)l.getWorld().spawn(s2, projectileClass);
        Vector v = s2.clone().add(0.0, -1.0, 0.0).toVector().subtract(s2.toVector()).normalize().multiply(velocity);
        projectile.setVelocity(v);
        projectile.setBounce(false);
        projectile.setShooter((ProjectileSource)l);
        return BukkitAdapter.adapt((Entity)projectile);
    }

    @Override
    public AbstractEntity shootShulkerBullet(SkillCaster caster, AbstractEntity target, AbstractLocation origin, ShootShulkerMechanic mechanic) {
        ShulkerBullet projectile;
        LivingEntity l = (LivingEntity)caster.getEntity().getBukkitEntity();
        Entity eTarget = BukkitAdapter.adapt(target);
        if (mechanic.getFromOrigin().booleanValue()) {
            Location fOrigin = BukkitAdapter.adapt(origin);
            projectile = (ShulkerBullet)eTarget.getWorld().spawn(fOrigin, ShulkerBullet.class);
        } else {
            projectile = (ShulkerBullet)l.launchProjectile(ShulkerBullet.class);
        }
        projectile.setTarget(eTarget);
        projectile.setBounce(mechanic.getBounce().booleanValue());
        projectile.setShooter((ProjectileSource)l);
        return BukkitAdapter.adapt((Entity)projectile);
    }

    @Override
    public void throwSkill(AbstractLocation source, AbstractEntity target, float velocity, float velocityY) {
        Vector V = BukkitAdapter.adapt(target.getLocation()).toVector().subtract(BukkitAdapter.adapt(source).toVector()).normalize().multiply(velocity);
        if (velocity == 0.0f) {
            V.setY(velocityY);
        } else {
            V.setY((double)velocityY + V.getY());
        }
        if (V.length() > 4.0) {
            V = V.normalize().multiply(4);
        }
        if (Double.isNaN(V.getX())) {
            V.setX(0);
        }
        if (Double.isNaN(V.getY())) {
            V.setY(0);
        }
        if (Double.isNaN(V.getZ())) {
            V.setZ(0);
        }
        target.getBukkitEntity().setVelocity(V);
    }

    @Override
    public void itemSprayEffect(AbstractLocation source, ItemStack item, int amount, int duration, double force, double yForce, double radius, double yOffset, boolean allowPickup, boolean applyGravity) {
        Location l = BukkitAdapter.adapt(source);
        ItemStack is = item;
        is.setAmount(1);
        Location loc = l.clone().add(0.0, yOffset, 0.0);
        Item[] items = new Item[amount];
        if (radius <= 0.0) {
            for (int i = 0; i < amount; ++i) {
                items[i] = loc.getWorld().dropItem(loc, is);
                items[i].setVelocity(new Vector((Numbers.randomDouble() - 0.5) * force, (Numbers.randomDouble() - 0.5) * yForce, (Numbers.randomDouble() - 0.5) * force));
                items[i].setGravity(applyGravity);
                try {
                    if (allowPickup) continue;
                    items[i].setPickupDelay(Short.MAX_VALUE);
                    if (!ServerVersion.isPaper()) continue;
                    items[i].setCanMobPickup(false);
                    items[i].setCanPlayerPickup(false);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else {
            for (int i = 0; i < amount; ++i) {
                Location lx = loc.clone();
                lx.setX(lx.getX() - radius + Numbers.randomDouble() * (radius * 2.0));
                lx.setZ(lx.getZ() - radius + Numbers.randomDouble() * (radius * 2.0));
                items[i] = lx.getWorld().dropItem(lx, is);
                items[i].setVelocity(new Vector((Numbers.randomDouble() - 0.5) * force, (Numbers.randomDouble() - 0.5) * yForce, (Numbers.randomDouble() - 0.5) * force));
                items[i].setGravity(applyGravity);
                try {
                    if (allowPickup) continue;
                    items[i].setPickupDelay(Short.MAX_VALUE);
                    items[i].setTicksLived(5800);
                    if (!ServerVersion.isPaper()) continue;
                    items[i].setCanMobPickup(false);
                    items[i].setCanPlayerPickup(false);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        Schedulers.sync().runLater(() -> {
            for (int i = 0; i < items.length; ++i) {
                items[i].remove();
            }
        }, duration);
    }

    @Override
    public void playSmokeEffect(AbstractLocation source, int direction) {
        BukkitAdapter.adapt(source).getWorld().playEffect(BukkitAdapter.adapt(source), Effect.SMOKE, direction);
    }

    @Override
    public void pushButton(SkillCaster am, AbstractLocation location) {
        Block block = BukkitAdapter.adapt(location).getWorld().getBlockAt(BukkitAdapter.adapt(location));
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Executing pushbutton mechanic @ " + location.toString(), new Object[0]);
        try {
            MythicBukkit.inst().getVolatileCodeHandler().getBlockHandler().togglePowerable(location, 20L);
        }
        catch (Exception e) {
            MythicLogger.error("A pushbutton skill is improperly configured: block is not a button.");
            e.printStackTrace();
            return;
        }
    }

    @Override
    public void toggleLever(SkillCaster am, AbstractLocation location, int duration) {
        Block block = BukkitAdapter.adapt(location).getWorld().getBlockAt(BukkitAdapter.adapt(location));
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Executing togglelever mechanic @ " + location.toString() + " duration=" + duration, new Object[0]);
        try {
            MythicBukkit.inst().getVolatileCodeHandler().getBlockHandler().togglePowerable(location, duration);
        }
        catch (Exception e) {
            MythicLogger.error("A ToggleLever skill is improperly configured: block is not a button.");
        }
    }

    @Override
    public void executeVolley(SkillCaster am, AbstractLocation t2, int amount, float velocity, float spread, int fireTicks, int removeDelay, boolean canPickup) {
        if (!(am.getEntity().getBukkitEntity() instanceof ProjectileSource)) {
            return;
        }
        ProjectileSource source = (ProjectileSource)am.getEntity().getBukkitEntity();
        Location target = BukkitAdapter.adapt(t2);
        Location spawn = BukkitAdapter.adapt(am.getLocation()).clone();
        spawn.setY(spawn.getY() + 3.0);
        Vector v = target == null ? spawn.getDirection() : target.toVector().subtract(spawn.toVector()).normalize();
        final ArrayList<Arrow> arrowList = new ArrayList<Arrow>();
        for (int i = 0; i < amount; ++i) {
            Arrow a = spawn.getWorld().spawnArrow(spawn, v, velocity, spread / 10.0f);
            a.setVelocity(a.getVelocity());
            if (am.getEntity() != null) {
                a.setShooter(source);
            }
            if (fireTicks > 0) {
                a.setFireTicks(fireTicks);
            }
            if (canPickup) {
                a.setPickupStatus(AbstractArrow.PickupStatus.DISALLOWED);
            }
            arrowList.add(a);
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MythicBukkit.inst(), new Runnable(){

            @Override
            public void run() {
                for (Arrow a : arrowList) {
                    a.remove();
                }
                arrowList.clear();
            }
        }, (long)removeDelay);
    }

    public void sendToastNotification(SkillCaster caster, String message) {
    }

    private static class LeverUnswitcher
    implements Runnable {
        private Block block;

        public LeverUnswitcher(Block block) {
            this.block = block;
        }

        @Override
        public void run() {
            try {
                if (!this.block.getChunk().isLoaded()) {
                    this.block.getChunk().load();
                }
                Lever button = new Lever(Material.LEVER, this.block.getData());
                button.setPowered(false);
                BlockRedstoneEvent toggle = new BlockRedstoneEvent(this.block, 0, 1);
                Bukkit.getPluginManager().callEvent((Event)toggle);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

