/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.adapters;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractAttributeModifier;
import io.lumine.mythic.api.adapters.AbstractItemFlag;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.volatilecode.handlers.VolatileItemHandler;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.serialize.Chroma;
import io.lumine.mythic.bukkit.utils.text.Text;
import io.lumine.mythic.core.utils.Patterns;
import io.lumine.mythic.core.utils.jnbt.CompoundTag;
import io.lumine.mythic.core.utils.jnbt.Tag;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.apache.commons.lang.StringUtils;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.Nullable;

public abstract class BukkitItemStack
implements AbstractItemStack {
    protected static final VolatileItemHandler handler = MythicBukkit.inst().getVolatileCodeHandler().getItemHandler();
    protected ItemStack itemStack;

    protected BukkitItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public ItemStack getItemStack() {
        return this.itemStack.clone();
    }

    public Material getType() {
        return this.itemStack.getType();
    }

    @Deprecated
    public BukkitItemStack type(Material material) {
        this.itemStack.setType(material);
        return this;
    }

    @Nullable
    public ItemMeta getItemMeta() {
        return this.itemStack.getItemMeta();
    }

    public BukkitItemStack editMeta(Consumer<ItemMeta> consumer) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta == null) {
            return this;
        }
        consumer.accept(meta);
        this.itemStack.setItemMeta(meta);
        return this;
    }

    public <T extends ItemMeta> BukkitItemStack editMeta(Class<T> clazz, Consumer<T> consumer) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta == null || !meta.getClass().equals(clazz)) {
            return this;
        }
        consumer.accept(meta);
        this.itemStack.setItemMeta(meta);
        return this;
    }

    @Override
    @Deprecated
    @Nullable
    public String getName() {
        Component component = this.name();
        if (component instanceof TextComponent) {
            TextComponent text = (TextComponent)component;
            return text.content();
        }
        return null;
    }

    @Override
    public Component name() {
        return this.itemStack.displayName();
    }

    @Override
    public abstract BukkitItemStack setName(@Nullable String var1);

    @Override
    public abstract BukkitItemStack name(Component var1);

    @Override
    @Deprecated
    public Collection<String> getLore() {
        return this.lore().stream().map(line -> {
            if (line instanceof TextComponent) {
                TextComponent text = (TextComponent)line;
                return text.content();
            }
            return null;
        }).collect(Collectors.toList());
    }

    @Override
    public Collection<Component> lore() {
        return this.itemStack.lore();
    }

    @Override
    public abstract BukkitItemStack setLore(List<String> var1);

    @Override
    public abstract BukkitItemStack lore(List<Component> var1);

    @Override
    public BukkitItemStack loreText(List<String> lore) {
        ArrayList componentList = Lists.newArrayList();
        for (String line : lore) {
            if (line == null) continue;
            componentList.add(Text.parse(line));
        }
        return this.lore((List)componentList);
    }

    @Override
    public BukkitItemStack clearLore() {
        this.itemStack.lore().clear();
        return this;
    }

    @Override
    public int getAmount() {
        return this.itemStack.getAmount();
    }

    @Override
    public abstract BukkitItemStack amount(int var1);

    @Override
    @Deprecated
    public int getData() {
        return this.itemStack.getDurability();
    }

    @Override
    public abstract BukkitItemStack data(int var1);

    @Override
    public abstract BukkitItemStack breakable(boolean var1);

    @Override
    public abstract BukkitItemStack hideAll();

    @Override
    public BukkitItemStack flags(AbstractItemFlag ... flags) {
        return this.flags(Arrays.stream(flags).toList());
    }

    @Override
    public abstract BukkitItemStack flags(Collection<AbstractItemFlag> var1);

    @Override
    public abstract BukkitItemStack repairCost(int var1);

    @Override
    public int getMaxStackSize() {
        return this.getType().getMaxStackSize();
    }

    @Override
    public abstract BukkitItemStack maxStackSize(int var1);

    @Override
    public BukkitItemStack unstackable() {
        return this.maxStackSize(1);
    }

    @Override
    public int getModelData() {
        return Optional.ofNullable(this.getItemMeta()).map(ItemMeta::getCustomModelData).orElse(0);
    }

    @Override
    public abstract BukkitItemStack modelData(int var1);

    @Override
    public abstract BukkitItemStack addAttributeModifier(AbstractAttributeModifier var1);

    @Override
    public abstract BukkitItemStack skullOwner(String var1);

    @Override
    public abstract BukkitItemStack skullOwner(String var1, UUID var2);

    @Override
    public abstract BukkitItemStack skullTexture(String var1);

    @Override
    public abstract BukkitItemStack skullTexture(String var1, String var2);

    @Override
    public abstract BukkitItemStack enchant(Enchantment var1, int var2);

    @Override
    public abstract BukkitItemStack enchantmentGlow(boolean var1);

    @Override
    public abstract BukkitItemStack durability(int var1);

    @Override
    public abstract BukkitItemStack maxDurability(int var1);

    @Override
    public abstract BukkitItemStack canPlaceOn(Collection<Material> var1);

    @Override
    public abstract BukkitItemStack canBreak(Collection<Material> var1);

    @Override
    public abstract BukkitItemStack potionEffect(PotionEffectType var1, int var2, int var3);

    @Override
    public abstract BukkitItemStack color(int var1, int var2, int var3);

    @Override
    public BukkitItemStack color(Chroma color) {
        return this.color(color.red(), color.green(), color.blue());
    }

    @Override
    public BukkitItemStack color(String color) {
        int b;
        int g2;
        int r;
        if (color.startsWith("#")) {
            Color parsedColor = Color.decode(color);
            r = parsedColor.getRed();
            g2 = parsedColor.getRed();
            b = parsedColor.getRed();
        } else if (StringUtils.countMatches((String)color, (String)",") == 2) {
            String[] components = color.split(",");
            r = Integer.parseInt(components[0]);
            g2 = Integer.parseInt(components[1]);
            b = Integer.parseInt(components[2]);
        } else {
            org.bukkit.Color bukkitColor = DyeColor.valueOf((String)color.toUpperCase()).getColor();
            r = bukkitColor.getRed();
            g2 = bukkitColor.getGreen();
            b = bukkitColor.getBlue();
        }
        return this.color(r, g2, b);
    }

    @Override
    public abstract BukkitItemStack customData(String var1, Tag var2);

    @Override
    public abstract BukkitItemStack customData(CompoundTag var1);

    @Override
    public boolean isSimilar(AbstractItemStack other) {
        if (other instanceof BukkitItemStack) {
            BukkitItemStack bukkit = (BukkitItemStack)other;
            if (this.isSimilar(bukkit.itemStack)) {
                return true;
            }
            CompoundTag data = this.getCustomData();
            CompoundTag otherData = other.getCustomData();
            if (data.getString("MYTHIC_TYPE") != null && Objects.equals(data.getString("MYTHIC_TYPE"), otherData.getString("MYTHIC_TYPE"))) {
                return true;
            }
            if (data.getString("MMOITEMS_ITEM_TYPE") != null && Objects.equals(data.getString("MMOITEMS_ITEM_TYPE"), otherData.getString("MMOITEMS_ITEM_TYPE"))) {
                return true;
            }
            return data.getString("MMOITEMS_ITEM_ID") != null && Objects.equals(data.getString("MMOITEMS_ITEM_ID"), otherData.getString("MMOITEMS_ITEM_ID"));
        }
        return false;
    }

    public boolean isSimilar(ItemStack other) {
        return this.itemStack.isSimilar(other);
    }

    public static Collection<AbstractItemStack> getMatches(String regex) {
        HashSet<AbstractItemStack> bukkitItemStacks = new HashSet<AbstractItemStack>();
        if (regex.toLowerCase().startsWith("mmoitems.") && MythicBukkit.inst().getCompatibility().getMMOItems().isPresent()) {
            bukkitItemStacks.add(MythicBukkit.inst().getBootstrap().createItem(regex));
        } else {
            for (String itemNames : MythicBukkit.inst().getItemManager().getItemNames()) {
                if (!itemNames.matches(Patterns.toRegex(regex))) continue;
                bukkitItemStacks.add(MythicBukkit.inst().getBootstrap().createItem(itemNames));
            }
            for (Material mats : Material.values()) {
                if (!mats.toString().matches(Patterns.toRegex(regex.toUpperCase()))) continue;
                bukkitItemStacks.add(BukkitAdapter.adapt(mats));
            }
        }
        return bukkitItemStacks;
    }
}

