/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit;

import io.lumine.mythic.api.MythicPlugin;
import io.lumine.mythic.api.MythicProvider;
import io.lumine.mythic.api.adapters.AbstractWorld;
import io.lumine.mythic.api.adapters.ServerInterface;
import io.lumine.mythic.api.adapters.SkillAdapter;
import io.lumine.mythic.api.volatilecode.VolatileCodeDisabled;
import io.lumine.mythic.api.volatilecode.VolatileCodeHandler;
import io.lumine.mythic.bukkit.BukkitAPIHelper;
import io.lumine.mythic.bukkit.BukkitBootstrap;
import io.lumine.mythic.bukkit.adapters.BukkitSkillTriggers;
import io.lumine.mythic.bukkit.adapters.BukkitWorld;
import io.lumine.mythic.bukkit.clock.MythicClock;
import io.lumine.mythic.bukkit.clock.TimingsHandler;
import io.lumine.mythic.bukkit.commands.BaseCommand;
import io.lumine.mythic.bukkit.commands.menus.MenuCommand;
import io.lumine.mythic.bukkit.commands.mobs.SpawnCommand;
import io.lumine.mythic.bukkit.compatibility.CompatibilityManager;
import io.lumine.mythic.bukkit.listeners.ThreatTableListeners;
import io.lumine.mythic.bukkit.metrics.MetricsLite;
import io.lumine.mythic.bukkit.metrics.bStats;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.chat.ColorString;
import io.lumine.mythic.bukkit.utils.gson.GsonProvider;
import io.lumine.mythic.bukkit.utils.holograms.BukkitHologramFactory;
import io.lumine.mythic.bukkit.utils.holograms.HologramFactory;
import io.lumine.mythic.bukkit.utils.logging.ConsoleColor;
import io.lumine.mythic.bukkit.utils.plugin.LuminePlugin;
import io.lumine.mythic.bukkit.utils.text.Text;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.config.ConfigExecutor;
import io.lumine.mythic.core.drops.DropExecutor;
import io.lumine.mythic.core.glow.GlowManager;
import io.lumine.mythic.core.holograms.HologramManager;
import io.lumine.mythic.core.items.ItemExecutor;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.menus.MenuManager;
import io.lumine.mythic.core.mobs.MobExecutor;
import io.lumine.mythic.core.mobs.tracker.DamageRecordManager;
import io.lumine.mythic.core.packs.PackExecutor;
import io.lumine.mythic.core.players.PlayerManager;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.pins.PinExecutor;
import io.lumine.mythic.core.skills.placeholders.PlaceholderExecutor;
import io.lumine.mythic.core.skills.stats.StatExecutor;
import io.lumine.mythic.core.skills.variables.Variable;
import io.lumine.mythic.core.skills.variables.VariableManager;
import io.lumine.mythic.core.skills.variables.VariableSerializer;
import io.lumine.mythic.core.spawning.random.RandomSpawnerManager;
import io.lumine.mythic.core.spawning.spawners.SpawnerManager;
import io.lumine.mythic.core.utils.Patterns;
import io.lumine.mythic.core.utils.jnbt.CompoundTag;
import io.lumine.mythic.core.utils.jnbt.NBTCompoundSerializer;
import io.lumine.mythic.core.utils.jnbt.NBTSerializer;
import io.lumine.mythic.core.utils.jnbt.Tag;
import io.lumine.mythic.core.worlds.WorldManager;
import java.io.File;
import java.io.IOException;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class MythicBukkit
extends LuminePlugin
implements MythicPlugin {
    private static MythicBukkit plugin;
    private ServerInterface server;
    private BaseCommand baseCommand;
    private ConfigExecutor configuration;
    private PackExecutor packManager;
    private MythicClock clock;
    private PinExecutor pinManager;
    private RandomSpawnerManager randomSpawningManager;
    private MobExecutor mobManager;
    private PlayerManager playerManager;
    private WorldManager worldManager;
    private SkillExecutor skillManager;
    private DropExecutor dropManager;
    private DamageRecordManager damageRecordManager;
    private ItemExecutor itemManager;
    private SpawnerManager spawnerManager;
    private VariableManager variableManager;
    private StatExecutor statManager;
    private MenuManager menuManager;
    private PlaceholderExecutor placeholderManager;
    private HologramManager hologramManager;
    private GlowManager glowManager;
    private CompatibilityManager compatibility;
    private BukkitHologramFactory hologramProvider;
    private VolatileCodeHandler volatileCodeHandler;
    private TimingsHandler timingsHandler;
    private BukkitAPIHelper APIHelper;
    private boolean shuttingDown = false;
    private Boolean isUpdateAvailable = false;
    private static final Object volatilityHandler;
    private static final Object volatilltyHandler;

    @Override
    public void load() {
        plugin = this;
        MythicLogger.log(Text.colorizeLegacy("<rainbow>Mythic Enabled!"));
    }

    @Override
    public void enable() {
        this.server = new BukkitBootstrap(this);
        SkillAdapter.initializeBukkit(this);
        MythicLogger.log("Loading {0} for {1} {2}...", this.getDescription().getName(), ServerVersion.isPaper() ? "Paper" : "Spigot", ServerVersion.get().toString());
        if (ServerVersion.isPaper()) {
            MythicLogger.log("The server is running Paper; enabled Paper exclusive functionality");
        } else {
            MythicLogger.log("The server is running Spigot; disabled Paper exclusive functionality");
        }
        Patterns.CompilePatterns();
        GsonProvider.update(builder -> builder.registerTypeAdapter(AbstractWorld.class, (Object)GsonProvider.standard().getAdapter(BukkitWorld.class)).registerTypeAdapter(Tag.class, (Object)new NBTSerializer()).registerTypeAdapter(CompoundTag.class, (Object)new NBTCompoundSerializer()).registerTypeAdapter(Variable.class, (Object)new VariableSerializer()));
        File statsFile = new File(this.getDataFolder(), "stats.yml");
        if (!statsFile.exists()) {
            this.saveResource("stats.yml", false);
        }
        this.clock = new MythicClock(this);
        this.configuration = new ConfigExecutor(this);
        this.configuration.firstLoad();
        this.packManager = new PackExecutor(this);
        this.hologramProvider = new BukkitHologramFactory();
        this.provideService(HologramFactory.class, this.hologramProvider);
        this.volatileCodeHandler = this.getVolatileCodeHandler();
        this.placeholderManager = new PlaceholderExecutor(this);
        this.compatibility = new CompatibilityManager(this);
        this.itemManager = new ItemExecutor(this);
        this.damageRecordManager = new DamageRecordManager(this);
        this.dropManager = new DropExecutor(this);
        this.pinManager = new PinExecutor(this);
        this.mobManager = new MobExecutor(this);
        this.playerManager = new PlayerManager(this);
        this.worldManager = new WorldManager(this);
        this.skillManager = new SkillExecutor(this);
        this.spawnerManager = new SpawnerManager(this);
        this.randomSpawningManager = new RandomSpawnerManager(this);
        this.variableManager = new VariableManager(this);
        this.statManager = new StatExecutor(this);
        this.menuManager = new MenuManager(this);
        this.glowManager = new GlowManager(this);
        this.hologramManager = new HologramManager(this, this.compatibility);
        this.getConfiguration().load(this);
        MythicLogger.log("MythicMobs configuration file loaded successfully.");
        this.timingsHandler = new TimingsHandler();
        this.clock.load(this);
        PluginManager manager = this.getServer().getPluginManager();
        manager.registerEvents((Listener)new BukkitSkillTriggers(this), (Plugin)this);
        manager.registerEvents((Listener)new ThreatTableListeners(), (Plugin)this);
        manager.registerEvents((Listener)this.getItemManager(), (Plugin)this);
        this.APIHelper = new BukkitAPIHelper();
        this.baseCommand = new BaseCommand(this);
        this.registerCommand("mythicmobs", this.baseCommand);
        this.registerCommand("spawnmob", new SpawnCommand(this));
        if (MythicBukkit.isVolatile()) {
            this.registerCommand("mythicmobsmenu", new MenuCommand(this));
        }
        MythicProvider.register(this);
        if (this.configuration.getAllowMetrics().booleanValue()) {
            new bStats(this);
            try {
                new MetricsLite(this);
            }
            catch (IOException e) {
                MythicLogger.debug(MythicLogger.DebugLevel.INFO, "MetricsLite: Failed to submit MetricsLite stats.", new Object[0]);
            }
        }
        this.getMobManager().ScanWorld();
        Schedulers.sync().runLater(() -> {
            this.clock.runPostReload();
            this.placeholderManager.setAcceptingRegisteredParsers(false);
        }, 40L);
        MythicLogger.log(String.valueOf((Object)ConsoleColor.GREEN) + String.valueOf((Object)ConsoleColor.CHECK_MARK) + " MythicMobs" + (MythicBukkit.isVolatile() ? " Premium" : "") + " v" + this.getVersion() + " ( build " + this.getBuildNumber() + " ) has been successfully loaded!" + String.valueOf((Object)ConsoleColor.RESET));
    }

    @Override
    public void disable() {
        MythicLogger.log(String.valueOf((Object)ConsoleColor.PURPLE) + String.valueOf((Object)ConsoleColor.BOLD) + "------------------------------------------------------------" + String.valueOf((Object)ConsoleColor.RESET));
        MythicLogger.log(String.valueOf((Object)ConsoleColor.PURPLE) + String.valueOf((Object)ConsoleColor.BOLD) + "- " + String.valueOf((Object)ConsoleColor.RESET));
        MythicLogger.log(String.valueOf((Object)ConsoleColor.PURPLE) + String.valueOf((Object)ConsoleColor.BOLD) + "- " + String.valueOf((Object)ConsoleColor.YELLOW) + "Unloading Mythic..." + String.valueOf((Object)ConsoleColor.RESET));
        MythicLogger.log(String.valueOf((Object)ConsoleColor.PURPLE) + String.valueOf((Object)ConsoleColor.BOLD) + "- " + String.valueOf((Object)ConsoleColor.RESET));
        MythicLogger.log(String.valueOf((Object)ConsoleColor.PURPLE) + String.valueOf((Object)ConsoleColor.BOLD) + "------------------------------------------------------------" + String.valueOf((Object)ConsoleColor.RESET));
        this.shuttingDown = true;
        if (this.getSpawnerManager() != null) {
            this.getSpawnerManager().unloadAllSpawners();
            MythicLogger.log(String.valueOf((Object)ConsoleColor.PURPLE) + String.valueOf((Object)ConsoleColor.BOLD) + "- " + String.valueOf((Object)ConsoleColor.RESET) + "Spawners saved and unloaded..." + String.valueOf((Object)ConsoleColor.RESET));
        }
        this.getMobManager().despawnAllMobs();
        MythicLogger.log(String.valueOf((Object)ConsoleColor.PURPLE) + String.valueOf((Object)ConsoleColor.BOLD) + "- " + String.valueOf((Object)ConsoleColor.RESET) + "Mobs saved and unloaded..." + String.valueOf((Object)ConsoleColor.RESET));
        this.volatileCodeHandler = null;
        this.timingsHandler = null;
        this.configuration.unload();
        this.variableManager.terminate();
        MythicLogger.log(String.valueOf((Object)ConsoleColor.PURPLE) + String.valueOf((Object)ConsoleColor.BOLD) + "- " + String.valueOf((Object)ConsoleColor.RESET) + "Variables saved..." + String.valueOf((Object)ConsoleColor.RESET));
        this.compatibility.terminate();
        MythicLogger.log(String.valueOf((Object)ConsoleColor.PURPLE) + String.valueOf((Object)ConsoleColor.BOLD) + "- " + String.valueOf((Object)ConsoleColor.RESET) + "All active settings have been saved!" + String.valueOf((Object)ConsoleColor.RESET));
        MythicLogger.log(String.valueOf((Object)ConsoleColor.PURPLE) + String.valueOf((Object)ConsoleColor.BOLD) + "- " + String.valueOf((Object)ConsoleColor.RESET) + "Mythic has been unloaded!" + String.valueOf((Object)ConsoleColor.RESET));
        MythicLogger.log(String.valueOf((Object)ConsoleColor.PURPLE) + String.valueOf((Object)ConsoleColor.BOLD) + "------------------------------------------------------------" + String.valueOf((Object)ConsoleColor.RESET));
    }

    public static MythicBukkit inst() {
        return plugin;
    }

    public ServerInterface getBootstrap() {
        return this.server;
    }

    private static Object initializeVolatility() {
        try {
            return Class.forName("io.lumine.mythic.core.CarsonJF");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while enabling CarsonJF", e);
        }
    }

    @Override
    public VolatileCodeHandler getVolatileCodeHandler() {
        if (this.volatileCodeHandler != null) {
            return this.volatileCodeHandler;
        }
        VolatileCodeHandler VCH = new VolatileCodeDisabled();
        String version = ServerVersion.getNMS().toString();
        try {
            Class<?> clazz = Class.forName("io.lumine.mythic.core.volatilecode.VolatileCodeEnabled_" + version);
            if (VolatileCodeHandler.class.isAssignableFrom(clazz)) {
                VCH = (VolatileCodeHandler)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (ClassNotFoundException e) {
            MythicLogger.error(ColorString.get("&6--====|||| &c&lMythic &6||||====--"));
            MythicLogger.error("This version of Mythic is not fully compatible with your version of Bukkit.");
            MythicLogger.error("Some features may be limited or disabled until you use a compatible version.");
            MythicLogger.error("Server NMS Version Detected - {0}", version);
        }
        catch (Exception e) {
            throw new RuntimeException("Unknown exception loading version handler. Volatile code has been disabled.", e);
        }
        this.volatileCodeHandler = VCH;
        return VCH;
    }

    public static final boolean isVolatile() {
        return volatilltyHandler != null;
    }

    public String getVersion() {
        return this.getDescription().getVersion().split("-")[0];
    }

    private static Object initializeVolatillty() {
        try {
            return Class.forName("io.lumine.mythic.utils.CarsonJF");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while enabling CarsonJF", e);
        }
    }

    public String getBuildNumber() {
        String[] split = this.getDescription().getVersion().split("-");
        if (split.length == 2) {
            return split[1];
        }
        if (split.length == 3) {
            return split[2];
        }
        return "????";
    }

    public BaseCommand getBaseCommand() {
        return this.baseCommand;
    }

    @Override
    public ConfigExecutor getConfiguration() {
        return this.configuration;
    }

    @Override
    public PackExecutor getPackManager() {
        return this.packManager;
    }

    public MythicClock getClock() {
        return this.clock;
    }

    @Override
    public PinExecutor getPinManager() {
        return this.pinManager;
    }

    public RandomSpawnerManager getRandomSpawningManager() {
        return this.randomSpawningManager;
    }

    @Override
    public MobExecutor getMobManager() {
        return this.mobManager;
    }

    public PlayerManager getPlayerManager() {
        return this.playerManager;
    }

    public WorldManager getWorldManager() {
        return this.worldManager;
    }

    @Override
    public SkillExecutor getSkillManager() {
        return this.skillManager;
    }

    @Override
    public DropExecutor getDropManager() {
        return this.dropManager;
    }

    public DamageRecordManager getDamageRecordManager() {
        return this.damageRecordManager;
    }

    @Override
    public ItemExecutor getItemManager() {
        return this.itemManager;
    }

    public SpawnerManager getSpawnerManager() {
        return this.spawnerManager;
    }

    public VariableManager getVariableManager() {
        return this.variableManager;
    }

    public StatExecutor getStatManager() {
        return this.statManager;
    }

    public MenuManager getMenuManager() {
        return this.menuManager;
    }

    @Override
    public PlaceholderExecutor getPlaceholderManager() {
        return this.placeholderManager;
    }

    public HologramManager getHologramManager() {
        return this.hologramManager;
    }

    public GlowManager getGlowManager() {
        return this.glowManager;
    }

    public CompatibilityManager getCompatibility() {
        return this.compatibility;
    }

    public BukkitHologramFactory getHologramProvider() {
        return this.hologramProvider;
    }

    public TimingsHandler getTimingsHandler() {
        return this.timingsHandler;
    }

    public BukkitAPIHelper getAPIHelper() {
        return this.APIHelper;
    }

    @Override
    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    public Boolean getIsUpdateAvailable() {
        return this.isUpdateAvailable;
    }

    static {
        volatilityHandler = MythicBukkit.initializeVolatility();
        volatilltyHandler = MythicBukkit.initializeVolatillty();
    }
}

