/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.volatilecode.virtual;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.adapters.AbstractWorld;
import io.lumine.mythic.api.volatilecode.virtual.IPacketEntityRenderer;
import io.lumine.mythic.api.volatilecode.virtual.PacketEntity;
import io.lumine.mythic.bukkit.MythicBukkit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;

public abstract class PacketEntityRenderer<T extends PacketEntity<?>>
implements IPacketEntityRenderer<T> {
    protected final int entityId;
    protected final UUID uniqueId = UUID.randomUUID();
    protected final T wrapper;
    protected double cullingDistanceSq = 25000.0;
    protected Supplier<Collection<AbstractPlayer>> viewers = null;
    protected Map<AbstractPlayer, Boolean> trackedPlayers = Maps.newConcurrentMap();
    protected Boolean renderDataPerPlayer = false;
    protected int mount = -1;

    public PacketEntityRenderer(T wrapper) {
        this.entityId = MythicBukkit.inst().getVolatileCodeHandler().getEntityHandler().getNextEntityId();
        this.wrapper = wrapper;
    }

    @Override
    public void spawn(AbstractPlayer target) {
        this.trackedPlayers.put(target, false);
        this.updateRenderedPlayers(true);
    }

    @Override
    public void spawn() {
        this.spawn(() -> MythicBukkit.inst().getBootstrap().getOnlinePlayers());
    }

    @Override
    public void spawn(Supplier<Collection<AbstractPlayer>> playerSupplier) {
        this.viewers = playerSupplier;
        Collection<AbstractPlayer> players = playerSupplier.get();
        for (AbstractPlayer player : players) {
            this.trackedPlayers.put(player, false);
        }
        this.updateRenderedPlayers(true);
    }

    @Override
    public void spawn(AbstractWorld world) {
        this.spawn(() -> world.getPlayers());
    }

    @Override
    public void spawn(Collection<AbstractPlayer> players) {
        for (AbstractPlayer player : players) {
            this.trackedPlayers.put(player, false);
        }
        this.updateRenderedPlayers(true);
    }

    @Override
    public void spawnWithMount(AbstractPlayer target, PacketEntityRenderer mount) {
        ArrayList packets = Lists.newArrayList();
        packets.addAll(mount.getSpawnPackets(target));
        packets.addAll(this.getSpawnPackets(target));
        packets.add(mount.createPassengerPacket(this.entityId));
        this.setMount(mount.getEntityId());
        this.sendPacket(target, packets);
    }

    @Override
    public void spawnWithMount(Supplier<Collection<AbstractPlayer>> playerSupplier, PacketEntityRenderer mount) {
        this.viewers = playerSupplier;
        mount.setViewers(playerSupplier);
        Collection<AbstractPlayer> players = playerSupplier.get();
        for (AbstractPlayer abstractPlayer : players) {
            this.trackedPlayers.put(abstractPlayer, false);
            mount.getTrackedPlayers().put(abstractPlayer, false);
        }
        this.updateRenderedPlayers(false);
        mount.updateRenderedPlayers(false);
        this.setMount(mount.getEntityId());
        for (Map.Entry entry : this.trackedPlayers.entrySet()) {
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            AbstractPlayer target = (AbstractPlayer)entry.getKey();
            ArrayList packets = Lists.newArrayList();
            packets.addAll(mount.getSpawnPackets(target));
            packets.addAll(this.getSpawnPackets(target));
            packets.add(mount.createPassengerPacket(this.entityId));
            this.sendPacket((AbstractPlayer)entry.getKey(), packets);
        }
    }

    @Override
    public void spawnWithMount(Collection<AbstractPlayer> players, PacketEntityRenderer mount) {
        for (AbstractPlayer abstractPlayer : players) {
            this.trackedPlayers.put(abstractPlayer, false);
            mount.getTrackedPlayers().put(abstractPlayer, false);
        }
        this.updateRenderedPlayers(false);
        mount.updateRenderedPlayers(false);
        this.setMount(mount.getEntityId());
        for (Map.Entry entry : this.trackedPlayers.entrySet()) {
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            AbstractPlayer target = (AbstractPlayer)entry.getKey();
            ArrayList packets = Lists.newArrayList();
            packets.addAll(mount.getSpawnPackets(target));
            packets.addAll(this.getSpawnPackets(target));
            packets.add(mount.createPassengerPacket(this.entityId));
            this.sendPacket((AbstractPlayer)entry.getKey(), packets);
        }
    }

    @Override
    public void setCullingDistance(int blocks) {
        this.cullingDistanceSq = Math.pow(blocks, 2.0);
    }

    @Override
    public void updateRenderedPlayers(boolean sendSpawnPacket) {
        if (this.viewers != null) {
            Collection<AbstractPlayer> viewerCollection = this.viewers.get();
            this.trackedPlayers.keySet().removeIf(player -> !viewerCollection.contains(player));
            for (AbstractPlayer player2 : viewerCollection) {
                this.trackedPlayers.putIfAbsent(player2, false);
            }
        }
        AbstractLocation location = ((PacketEntity)this.wrapper).getLocation().peek();
        this.trackedPlayers.replaceAll((player, value) -> {
            if (!location.getWorld().equals(player.getWorld())) {
                return false;
            }
            double d = Math.pow(player.getLocation().getX() - location.getX(), 2.0) + Math.pow(player.getLocation().getZ() - location.getZ(), 2.0);
            if (value.booleanValue()) {
                if (d > this.cullingDistanceSq) {
                    this.destroy((AbstractPlayer)player);
                    return false;
                }
            } else if (d <= this.cullingDistanceSq) {
                if (sendSpawnPacket) {
                    this.create((AbstractPlayer)player);
                }
                return true;
            }
            return value;
        });
    }

    public abstract void sendPacket(AbstractPlayer var1, Collection<Object> var2);

    public abstract void sendPacket(AbstractPlayer var1, Object ... var2);

    public abstract void sendPacket(Object ... var1);

    @Override
    public void update() {
        Object packetTeleport = null;
        Object packetVelocity = null;
        if (this.mount < 0) {
            if (((PacketEntity)this.getWrapper()).getLocation().isDirty()) {
                AbstractLocation location = ((PacketEntity)this.getWrapper()).getLocation().get();
                packetTeleport = this.createTeleportPacket(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
            }
            if (((PacketEntity)this.getWrapper()).getVelocity().isDirty()) {
                AbstractVector velocity = ((PacketEntity)this.getWrapper()).getVelocity().get();
                packetVelocity = this.createVelocityPacket(velocity.getX(), velocity.getY(), velocity.getZ());
            }
        }
        if (this.renderDataPerPlayer.booleanValue()) {
            Set<AbstractPlayer> set = this.trackedPlayers.keySet();
            for (AbstractPlayer player : set) {
                Object packetData = this.createDataPacket(player, false);
                if (packetTeleport != null) {
                    this.sendPacket(player, packetTeleport);
                }
                if (packetData != null) {
                    this.sendPacket(player, packetData);
                }
                if (packetVelocity == null) continue;
                this.sendPacket(player, packetVelocity);
            }
        } else {
            Object packetData = this.createDataPacket(false);
            this.sendPacket(packetData, packetTeleport, packetVelocity);
        }
    }

    private void create(AbstractPlayer target) {
        Collection<Object> packets = this.getSpawnPackets(target);
        if (this.mount > 0) {
            packets.add(this.createMountPacket(this.mount));
        }
        this.sendPacket(target, packets);
    }

    @Override
    public void destroy() {
        Object destroyPacket = this.createRemovePacket();
        Set<AbstractPlayer> set = this.trackedPlayers.keySet();
        for (AbstractPlayer player : set) {
            this.sendPacket(player, destroyPacket);
        }
        this.trackedPlayers.clear();
    }

    @Override
    public void destroy(AbstractPlayer player) {
        this.trackedPlayers.put(player, false);
        Object destroyPacket = this.createRemovePacket();
        this.sendPacket(player, destroyPacket);
    }

    @Override
    public void mountEntity(AbstractEntity entity) {
        int id = entity.getBukkitEntity().getEntityId();
        Object packet = this.createMountPacket(id);
        if (packet != null) {
            this.mount = id;
            this.sendPacket(packet);
        }
    }

    @Override
    public void addPassenger(PacketEntityRenderer entity) {
        Object packet = this.createPassengerPacket(entity.getEntityId());
        if (packet != null) {
            entity.setMount(this.entityId);
            this.sendPacket(packet);
        }
    }

    protected abstract Collection<Object> getSpawnPackets(AbstractPlayer var1);

    protected abstract Object createSpawnPacket();

    protected abstract Object createDataPacket(boolean var1);

    protected Object createDataPacket(AbstractPlayer player, boolean force) {
        return this.createDataPacket(force);
    }

    protected abstract Object createRemovePacket();

    protected abstract Object createVelocityPacket(double var1, double var3, double var5);

    protected abstract Object createTeleportPacket(double var1, double var3, double var5, float var7, float var8);

    protected Object createMountPacket(int entityId) {
        return null;
    }

    protected Object createPassengerPacket(int entityId) {
        return null;
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public T getWrapper() {
        return this.wrapper;
    }

    public void setViewers(Supplier<Collection<AbstractPlayer>> viewers) {
        this.viewers = viewers;
    }

    @Override
    public Map<AbstractPlayer, Boolean> getTrackedPlayers() {
        return this.trackedPlayers;
    }

    public void setTrackedPlayers(Map<AbstractPlayer, Boolean> trackedPlayers) {
        this.trackedPlayers = trackedPlayers;
    }

    public Boolean getRenderDataPerPlayer() {
        return this.renderDataPerPlayer;
    }

    public void setRenderDataPerPlayer(Boolean renderDataPerPlayer) {
        this.renderDataPerPlayer = renderDataPerPlayer;
    }

    @Override
    public void setMount(int mount) {
        this.mount = mount;
    }
}

