/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.volatilecode.handlers;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.utils.jnbt.CompoundTag;
import io.lumine.mythic.core.utils.jnbt.CompoundTagBuilder;
import io.lumine.mythic.core.utils.jnbt.ListTag;
import io.lumine.mythic.core.utils.jnbt.ListTagBuilder;
import io.lumine.mythic.core.utils.jnbt.StringTag;
import io.lumine.mythic.core.utils.jnbt.Tag;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.entity.Trident;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public interface VolatileItemHandler {
    public ItemStack addNBTData(ItemStack var1, String var2, Tag var3);

    public CompoundTag getNBTData(ItemStack var1);

    public ItemStack setNBTData(ItemStack var1, CompoundTag var2);

    public void destroyItem(ItemStack var1);

    public ItemStack setNBTData(ItemStack var1, CompoundTag var2, PlaceholderMeta var3);

    public int spawnFakeItem(Player var1, ItemStack var2, AbstractLocation var3);

    public void collectFakeItem(Player var1, int var2);

    public void destroyFakeItem(Player var1, int var2);

    public float getItemRecharge(Player var1);

    public boolean getItemRecharging(Player var1);

    public void resetItemRecharge(Player var1);

    default public void setTridentItem(Trident entity, ItemStack item) {
    }

    default public String serializeItem(ItemStack itemStack) {
        return "[Unsupported Operation]";
    }

    default public Map<String, Object> getComponentData(ItemStack itemStack) {
        return Collections.emptyMap();
    }

    default public String dumpComponentData(ItemStack itemStack) {
        return "[Unsupported Operation]";
    }

    default public String dumpNBTData(ItemStack itemStack) {
        return "";
    }

    default public ItemStack setDisplayName(ItemStack itemStack, Component displayName) {
        CompoundTag nbt = this.getNBTData(itemStack);
        CompoundTagBuilder displayTag = Optional.ofNullable(nbt.getCompound("Display")).map(CompoundTag::createBuilder).orElse(CompoundTagBuilder.create());
        displayTag.putString("Name", (String)GsonComponentSerializer.gson().serialize(displayName));
        return this.setNBTData(itemStack, nbt.builder(builder -> builder.put("Display", displayTag.build())));
    }

    default public ItemStack setLore(ItemStack itemStack, Collection<Component> lore) {
        CompoundTag nbt = this.getNBTData(itemStack);
        CompoundTagBuilder displayTag = Optional.ofNullable(nbt.getCompound("Display")).map(CompoundTag::createBuilder).orElse(CompoundTagBuilder.create());
        displayTag.put("Lore", ListTagBuilder.create(StringTag.class).addAll(lore.stream().map(line -> (String)GsonComponentSerializer.gson().serialize(line)).map(StringTag::new).toList()).build());
        return this.setNBTData(itemStack, nbt.builder(builder -> builder.put("Display", displayTag.build())));
    }

    default public ItemStack setSkinData(ItemStack itemStack, @Nullable String playerName, @Nullable UUID playerUuid, @Nullable String textureData, @Nullable String textureUrl) {
        if (playerName != null) {
            itemStack = this.addNBTData(itemStack, "SkullOwner", new StringTag(playerName));
        } else if (textureData != null || textureUrl != null) {
            CompoundTag valuesTag = CompoundTag.create(texture -> texture.putString("Value", Objects.requireNonNullElseGet(textureData, () -> Base64Coder.encodeString((String)("{textures:{SKIN:{url:\"" + textureUrl + "\"}}}")))));
            ListTag valuesList = ListTagBuilder.createWith((Tag[])new CompoundTag[]{valuesTag}).build();
            itemStack = this.addNBTData(itemStack, "SkullOwner", CompoundTag.create(skullOwnerTag -> {
                skullOwnerTag.put("Properties", CompoundTag.create(properties -> properties.put("textures", valuesList)));
                skullOwnerTag.putUUID("Id", playerUuid);
            }));
        } else {
            throw new IllegalArgumentException("cannot set skin data with none of player name, texture data, or texture URL non-null.");
        }
        return itemStack;
    }

    default public ItemStack setCanPlaceOn(ItemStack itemStack, Collection<Material> materials) {
        return this.addNBTData(itemStack, "CanPlaceOn", ListTag.create(StringTag.class, builder -> builder.addAll(materials.stream().map(it -> new StringTag(NamespacedKey.minecraft((String)it.name().toLowerCase()).toString())).toList())));
    }

    default public ItemStack setCanBreak(ItemStack itemStack, Collection<Material> materials) {
        return this.addNBTData(itemStack, "CanBreak", ListTag.create(StringTag.class, builder -> builder.addAll(materials.stream().map(it -> new StringTag(NamespacedKey.minecraft((String)it.name().toLowerCase()).toString())).toList())));
    }
}

