/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.skills;

import io.lumine.mythic.core.skills.triggers.SkillTriggerMetadata;
import io.lumine.mythic.core.skills.triggers.meta.EmptyMetadata;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;

public record SkillTrigger<T extends SkillTriggerMetadata>(String name, Class<T> metadataClass, List<String> aliases) {
    private static final Map<String, SkillTrigger> TRIGGERS = new HashMap<String, SkillTrigger>();

    public SkillTrigger(String name, Class<T> metadataClass, List<String> aliases) {
        this.name = name.toUpperCase();
        this.metadataClass = metadataClass;
        this.aliases = aliases.stream().map(String::toUpperCase).toList();
    }

    @Deprecated
    public static SkillTrigger trigger(String name) {
        String thatName = name.toUpperCase();
        if (TRIGGERS != null && TRIGGERS.containsKey(thatName)) {
            return TRIGGERS.get(thatName);
        }
        return SkillTrigger.create(thatName, new String[0]);
    }

    public static SkillTrigger create(String name, String ... aliases) {
        return new SkillTrigger<EmptyMetadata>(name, EmptyMetadata.class, Arrays.asList(aliases));
    }

    public static SkillTrigger create(String name, Class<? extends SkillTriggerMetadata> clazz, String ... aliases) {
        return new SkillTrigger<SkillTriggerMetadata>(name, clazz, Arrays.asList(aliases));
    }

    public static SkillTrigger get(String name) {
        String thatName = name.toUpperCase();
        if (TRIGGERS.containsKey(thatName)) {
            return TRIGGERS.get(thatName);
        }
        return TRIGGERS.get("DEFAULT");
    }

    public static void register(SkillTrigger trigger) {
        Validate.notNull((Object)trigger, (String)"trigger cannot be null");
        String name = trigger.name();
        List<String> aliases = trigger.aliases;
        if (!TRIGGERS.containsKey(name)) {
            TRIGGERS.put(name, trigger);
        }
        aliases.forEach(alias -> {
            if (!TRIGGERS.containsKey(alias)) {
                TRIGGERS.put((String)alias, trigger);
            }
        });
    }

    public static Collection<SkillTrigger> values() {
        return TRIGGERS.values();
    }

    public void register() {
        SkillTrigger.register(this);
    }
}

