/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.mobs;

import io.lumine.mythic.api.adapters.AbstractBossBar;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.entities.MythicEntityType;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.api.packs.Pack;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillTrigger;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.core.config.DropMethod;
import io.lumine.mythic.core.drops.DropTable;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.mobs.DespawnMode;
import io.lumine.mythic.core.mobs.model.MobModel;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.variables.VariableRegistry;
import io.lumine.mythic.core.spawning.spawners.MythicSpawner;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.entity.Entity;

public interface MythicMob
extends Comparable<MythicMob> {
    public String getInternalName();

    public Pack getPack();

    public File getFile();

    public void buildCache();

    public PlaceholderString getDisplayName();

    public void setDisplayName(PlaceholderString var1);

    public MythicEntityType getEntityType();

    public void setEntityType(MythicEntityType var1);

    public String getEntityTypeString();

    public BukkitEntityType getMythicEntity();

    public DespawnMode getDespawnMode();

    public PlaceholderString getEggDisplay();

    public MobModel getModel();

    public DropTable getDropTable();

    public DropMethod getDropMethod();

    public Boolean getDamageLeaderboard();

    public Boolean getShowHologramLeaderboardOnDeath();

    public Integer getHologramLeaderboardTimeout();

    public Boolean getShowChatLeaderboardOnDeath();

    public List<String> getFancyDropHologramMessage();

    public List<String> getFancyDropChatMessage();

    public Boolean getDropsAreClientsideByDefault();

    public DropTable getEquipmentTable();

    public Boolean getOptionLockPitch();

    public Map<String, Double> getDamageModifiers();

    public Map<String, Double> getEntityDamageModifiers();

    public String getAiNavigator();

    public boolean isUsingTimers();

    public int getNoDamageTicks();

    public int getMaxAttackRange();

    public int getMaxAttackableRange();

    public int getMaxThreatDistance();

    public boolean isUseCustomNameplate();

    public Boolean getRepeatAllSkills();

    public Boolean getPreventOtherDrops();

    public Boolean getPreventRandomEquipment();

    public Boolean getPreventLeashing();

    public Boolean getPreventRename();

    public Boolean getPreventEndermanTeleport();

    public Boolean getPreventItemPickup();

    public Boolean getPreventSilverfishInfection();

    public Boolean getPreventSunburn();

    public Boolean getPreventExploding();

    public Boolean getPreventMobKillDrops();

    public Boolean getPreventTransformation();

    public Boolean getPreventMounts();

    public Boolean getPassthroughDamage();

    public Boolean getApplyInvisibility();

    public Boolean getDigOutOfGround();

    public Boolean getUsesHealthBar();

    public double getSpawnVelocityX();

    public double getSpawnVelocityXMax();

    public double getSpawnVelocityY();

    public double getSpawnVelocityYMax();

    public double getSpawnVelocityZ();

    public double getSpawnVelocityZMax();

    public Boolean getSpawnVelocityXRange();

    public Boolean getSpawnVelocityYRange();

    public Boolean getSpawnVelocityZRange();

    public PlaceholderString getDisguise();

    public boolean isFakePlayer();

    public MythicConfig getConfig();

    default public ActiveMob spawn(AbstractLocation location, double level) {
        return this.spawn(location, level, SpawnReason.OTHER);
    }

    public ActiveMob spawn(AbstractLocation var1, double var2, SpawnReason var4);

    public ActiveMob spawn(AbstractLocation var1, double var2, SpawnReason var4, Consumer<Entity> var5);

    public ActiveMob spawn(AbstractLocation var1, double var2, SpawnReason var4, Consumer<Entity> var5, MythicSpawner var6);

    public ActiveMob applyMobOptions(ActiveMob var1, double var2);

    public ActiveMob applyMobVolatileOptions(ActiveMob var1);

    public ActiveMob applySpawnModifiers(ActiveMob var1);

    public void executeSkills(SkillTrigger var1, SkillMetadata var2);

    public void executeSignalSkill(String var1, SkillMetadata var2);

    public Queue<SkillMechanic> getSkills(SkillTrigger var1);

    public boolean hasSkills(SkillTrigger var1);

    public Queue<SkillMechanic> getTimerSkills();

    public PlaceholderDouble getAttrHealth();

    public void setAttrHealth(PlaceholderDouble var1);

    public PlaceholderDouble getAttrDamage();

    public void setAttrDamage(PlaceholderDouble var1);

    public PlaceholderDouble getAttrArmor();

    public void setAttrArmor(PlaceholderDouble var1);

    public PlaceholderDouble getAttrMovementSpeed();

    public void setAttrMovementSpeed(PlaceholderDouble var1);

    public double getPerLevelHealth();

    public double getPerLevelDamage();

    public double getPerLevelPower();

    public PlaceholderDouble getArmor();

    public double getPerLevelArmor();

    public double getArmor(ActiveMob var1);

    public PlaceholderDouble getDamage();

    public double getDamage(ActiveMob var1);

    public double getMovementSpeed(ActiveMob var1);

    public double getReviveHealth(ActiveMob var1);

    public double getFlyingSpeed(ActiveMob var1);

    public double getKnockbackResistance(double var1);

    public double getAttackSpeed(double var1);

    public boolean hasFaction();

    public String getFaction();

    public void setFaction(String var1);

    public PlaceholderDouble getHealth();

    public double getHealth(ActiveMob var1);

    public boolean getIsInvincible();

    public boolean usesThreatTable();

    public boolean usesImmunityTable();

    public boolean usesHearing();

    public boolean getThreatTableUseDamageTaken();

    public boolean getThreatTableDecaysUnreachable();

    public List<String> getLevelModifiers();

    public List<String> getAIGoalSelectors();

    public List<String> getAITargetSelectors();

    public boolean hasKillMessages();

    public PlaceholderString getKillMessage();

    public boolean getIsInteractable();

    public boolean usesBossBar();

    public int getBossBarRangeSquared();

    public Optional<AbstractBossBar> getBossBar();

    public PlaceholderString getBossBarTitle();

    public boolean getShowHealthInChat();

    public boolean getShowNameOnDamaged();

    public Map<String, PlaceholderDouble> getStats();

    public float getSpeechBubbleOffset();

    public VariableRegistry getDefaultVariables();

    public Boolean getPreventVanillaDamage();

    public boolean isDropsPerPlayer();

    public Boolean getDropsDoLootsplosion();

    public Boolean getDropsShowNameByDefault();

    public Boolean getDropsGlowByDefault();

    public Boolean getDropsHaveBeamByDefault();

    public Boolean getDropsHaveVFXByDefault();

    public double getDropsPerPlayerRequiredDamagePercent();

    public Material getDropsItemVFXMaterial();

    public int getDropsItemVFXModel();

    public AbstractItemStack getEgg();
}

