/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.adapters;

public abstract class AbstractBiome {
    private final String key;

    public AbstractBiome(String key) {
        this.key = key.toLowerCase();
    }

    public abstract String getType();

    public String toString() {
        return this.key;
    }

    public boolean matches(String biome) {
        if (biome.contains("*") || biome.contains("?")) {
            return this.key.matches(biome.replace("?", ".?").replace("*", ".*?"));
        }
        return this.key.equalsIgnoreCase(biome);
    }

    public boolean equals(Object o) {
        if (o instanceof AbstractBiome) {
            AbstractBiome biome = (AbstractBiome)o;
            return this.getKey().equals(biome.getKey());
        }
        if (o instanceof String) {
            String string = (String)o;
            return this.getKey().equalsIgnoreCase(string);
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String getKey() {
        return this.key;
    }
}

