/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.waypoint;

import io.lumine.mythic.lib.api.MMOLineConfig;
import io.lumine.mythic.lib.util.PostLoadAction;
import io.lumine.mythic.lib.util.PreloadedObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.api.util.MMOCoreUtils;
import net.Indyuce.mmocore.loot.chest.condition.Condition;
import net.Indyuce.mmocore.loot.chest.condition.ConditionInstance;
import net.Indyuce.mmocore.player.Unlockable;
import net.Indyuce.mmocore.waypoint.WaypointOption;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class Waypoint
implements Unlockable,
PreloadedObject {
    private final String id;
    private final String name;
    private final Location loc;
    private final List<String> lore;
    private final double radiusSquared;
    private final int warpTime;
    private final Map<Waypoint, Double> destinations = new HashMap<Waypoint, Double>();
    private final Map<WaypointOption, Boolean> options = new HashMap<WaypointOption, Boolean>();
    private final double dynamicCost;
    private final double setSpawnCost;
    private final double normalCost;
    private final List<Condition> dynamicUseConditions = new ArrayList<Condition>();
    private final PostLoadAction postLoadAction = new PostLoadAction(config -> {
        if (config.contains("linked")) {
            ConfigurationSection section = config.getConfigurationSection("linked");
            for (String key : section.getKeys(false)) {
                this.destinations.put(MMOCore.plugin.waypointManager.get(key), section.getDouble(key));
            }
        }
        if (MMOCore.plugin.configManager.waypointLinkReciprocity) {
            this.destinations.forEach((neighbor, cost) -> neighbor.destinations.put(this, (Double)cost));
        }
    });

    public Waypoint(ConfigurationSection config2) {
        this.postLoadAction.cacheConfig(config2);
        this.id = Objects.requireNonNull(config2, "Could not load config section").getName();
        this.name = Objects.requireNonNull(config2.getString("name"), "Could not load waypoint name");
        this.lore = Objects.requireNonNullElse(config2.getStringList("lore"), new ArrayList());
        this.loc = MMOCoreUtils.readLocation(Objects.requireNonNull(config2.getString("location"), "Could not read location"));
        this.radiusSquared = Math.pow(config2.getDouble("radius"), 2.0);
        this.warpTime = Math.max(0, config2.getInt("warp-time", MMOCore.plugin.configManager.waypointWarpTime));
        this.dynamicCost = config2.getDouble("cost.dynamic-use");
        this.normalCost = config2.getDouble("cost.normal-use");
        this.setSpawnCost = config2.getDouble("cost.set-spawnpoint");
        for (WaypointOption option : WaypointOption.values()) {
            this.options.put(option, config2.getBoolean("option." + option.getPath(), option.getDefaultValue()));
        }
        if (config2.contains("dynamic-conditions")) {
            List conditions = config2.getStringList("dynamic-conditions");
            for (String condition : conditions) {
                try {
                    this.dynamicUseConditions.add(MMOCore.plugin.loadManager.loadCondition(new MMOLineConfig(condition)));
                }
                catch (RuntimeException exception) {
                    MMOCore.plugin.getLogger().log(Level.WARNING, "Could not load condition '" + condition + "' from waypoint '" + this.id + "': " + exception.getMessage());
                }
            }
        }
    }

    @NotNull
    public PostLoadAction getPostLoadAction() {
        return this.postLoadAction;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public Location getLocation() {
        return this.loc;
    }

    public int getWarpTime() {
        return this.warpTime;
    }

    public double getDynamicCost() {
        return this.dynamicCost;
    }

    @Deprecated
    public double getSetSpawnCost() {
        return this.setSpawnCost;
    }

    public boolean mayBeUsedDynamically(Player player) {
        if (!this.options.get((Object)WaypointOption.DYNAMIC).booleanValue()) {
            return false;
        }
        for (Condition condition : this.dynamicUseConditions) {
            if (condition.isMet(new ConditionInstance((Entity)player))) continue;
            return false;
        }
        return true;
    }

    public double getDirectCost(@NotNull Waypoint waypoint) {
        return this.destinations.isEmpty() ? this.normalCost : this.destinations.getOrDefault(waypoint, Double.POSITIVE_INFINITY);
    }

    public boolean hasOption(WaypointOption option) {
        return this.options.get((Object)option);
    }

    public boolean isOnWaypoint(Player player) {
        return player.getWorld().equals((Object)this.loc.getWorld()) && player.getLocation().distanceSquared(this.loc) < this.radiusSquared;
    }

    @NotNull
    public Map<Waypoint, Double> getDestinations() {
        return this.destinations;
    }

    public String toString() {
        return this.id;
    }

    @Override
    public String getUnlockNamespacedKey() {
        return "waypoint:" + this.getId();
    }

    @Override
    public boolean isUnlockedByDefault() {
        return this.hasOption(WaypointOption.DEFAULT);
    }

    @Override
    public void whenLocked(PlayerData playerData) {
    }

    @Override
    public void whenUnlocked(PlayerData playerData) {
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Waypoint waypoint = (Waypoint)o;
        return this.id.equals(waypoint.id);
    }
}

