/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.util;

import io.lumine.mythic.lib.UtilityMethods;
import java.util.Objects;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Icon {
    private final Material material;
    private final int modelData;

    public Material getMaterial() {
        return this.material;
    }

    public int getModelData() {
        return this.modelData;
    }

    public Icon(@NotNull Material material, int modelData) {
        this.material = material;
        this.modelData = modelData;
    }

    public ItemStack toItem() {
        ItemStack stack = new ItemStack(this.material);
        if (this.modelData > 0) {
            ItemMeta meta = stack.getItemMeta();
            meta.setCustomModelData(Integer.valueOf(this.modelData));
            stack.setItemMeta(meta);
        }
        return stack;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Icon icon = (Icon)o;
        return this.modelData == icon.modelData && this.material == icon.material;
    }

    public int hashCode() {
        return Objects.hash(this.material, this.modelData);
    }

    public String toString() {
        return "Icon{material=" + this.material + ", customModelData=" + this.modelData + '}';
    }

    @NotNull
    public static Icon from(@Nullable Object object) {
        Validate.notNull((Object)object, (String)"Could not read icon");
        if (object instanceof ConfigurationSection) {
            ConfigurationSection config = (ConfigurationSection)object;
            Material material = Material.valueOf((String)UtilityMethods.enumName((String)((ConfigurationSection)object).getString("item")));
            int modelData = config.getInt("model-data", config.getInt("custom-model-data"));
            return new Icon(material, modelData);
        }
        if (object instanceof String) {
            String[] split = ((String)object).split("[:.,]");
            Material mat = Material.valueOf((String)UtilityMethods.enumName((String)split[0]));
            int modelData = split.length == 1 ? 0 : Integer.parseInt(split[1]);
            return new Icon(mat, modelData);
        }
        throw new RuntimeException("Needs either a string or configuration section");
    }
}

