/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.skilltree.tree;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.logging.Level;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.api.util.MMOCoreUtils;
import net.Indyuce.mmocore.manager.registry.RegisteredObject;
import net.Indyuce.mmocore.skilltree.IntegerCoordinates;
import net.Indyuce.mmocore.skilltree.NodeState;
import net.Indyuce.mmocore.skilltree.NodeType;
import net.Indyuce.mmocore.skilltree.ParentInformation;
import net.Indyuce.mmocore.skilltree.ParentType;
import net.Indyuce.mmocore.skilltree.PathType;
import net.Indyuce.mmocore.skilltree.SkillTreeNode;
import net.Indyuce.mmocore.skilltree.SkillTreePath;
import net.Indyuce.mmocore.skilltree.display.DisplayInfo;
import net.Indyuce.mmocore.skilltree.display.NodeDisplayInfo;
import net.Indyuce.mmocore.skilltree.display.PathDisplayInfo;
import net.Indyuce.mmocore.util.Icon;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SkillTree
implements RegisteredObject {
    private final String id;
    private final String name;
    private final List<String> lore = new ArrayList<String>();
    private final Material item;
    private final int customModelData;
    protected final Map<String, SkillTreeNode> nodes = new HashMap<String, SkillTreeNode>();
    protected final int maxPointSpent;
    protected final List<SkillTreeNode> roots = new ArrayList<SkillTreeNode>();
    protected final Map<DisplayInfo, Icon> icons = new HashMap<DisplayInfo, Icon>();
    protected final Map<IntegerCoordinates, SkillTreeNode> coordNodes = new HashMap<IntegerCoordinates, SkillTreeNode>();
    protected final Map<IntegerCoordinates, SkillTreePath> coordPaths = new HashMap<IntegerCoordinates, SkillTreePath>();

    public SkillTree(@NotNull ConfigurationSection config) {
        ConfigurationSection section;
        this.id = Objects.requireNonNull(config.getString("id"), "Could not find skill tree id");
        this.name = MythicLib.plugin.parseColors(Objects.requireNonNull(config.getString("name"), "Could not find skill tree name"));
        Objects.requireNonNull(config.getStringList("lore"), "Could not find skill tree lore").forEach(str -> this.lore.add(MythicLib.plugin.parseColors(str)));
        this.item = Material.valueOf((String)UtilityMethods.enumName((String)Objects.requireNonNull(config.getString("item"), "Could not find item")));
        this.customModelData = config.getInt("custom-model-data", 0);
        Validate.isTrue((boolean)config.isConfigurationSection("nodes"), (String)"Could not find any nodes in the tree");
        this.maxPointSpent = config.getInt("max-point-spent", Integer.MAX_VALUE);
        for (String key : config.getConfigurationSection("nodes").getKeys(false)) {
            try {
                section = config.getConfigurationSection("nodes." + key);
                SkillTreeNode node = new SkillTreeNode(this, section);
                this.nodes.put(node.getId(), node);
                this.coordNodes.put(node.getCoordinates(), node);
                if (!node.isRoot()) continue;
                this.roots.add(node);
            }
            catch (Exception e) {
                MMOCore.log("Couldn't load skill tree node " + this.id + "." + key + ": " + e.getMessage());
            }
        }
        for (String from : config.getConfigurationSection("nodes").getKeys(false)) {
            section = config.getConfigurationSection("nodes." + from);
            if (!section.contains("paths")) continue;
            for (String string : section.getConfigurationSection("paths").getKeys(false)) {
                SkillTreeNode node1 = this.nodes.get(string);
                if (node1 == null) {
                    MMOCore.log("Couldn't find node " + string + " for path in node " + from + ".");
                    continue;
                }
                for (String string2 : section.getConfigurationSection("paths." + string).getKeys(false)) {
                    IntegerCoordinates coordinates = IntegerCoordinates.from(section.get("paths." + string + "." + string2));
                    this.coordPaths.put(coordinates, new SkillTreePath(this, coordinates, this.nodes.get(from), node1));
                }
            }
        }
        for (NodeState status : NodeState.values()) {
            for (PathType pathType : PathType.values()) {
                try {
                    String configPath2 = "display.paths." + MMOCoreUtils.ymlName(status.name()) + "." + MMOCoreUtils.ymlName(pathType.name());
                    this.icons.put(new PathDisplayInfo(pathType, status), Icon.from(config.get(configPath2)));
                }
                catch (Exception configPath2) {
                    // empty catch block
                }
            }
        }
        for (NodeState status : NodeState.values()) {
            for (NodeType nodeType : NodeType.values()) {
                try {
                    String configPath3 = "display.nodes." + MMOCoreUtils.ymlName(status.name()) + "." + MMOCoreUtils.ymlName(nodeType.name());
                    this.icons.put(new NodeDisplayInfo(nodeType, status), Icon.from(config.get(configPath3)));
                }
                catch (Exception configPath3) {
                    // empty catch block
                }
            }
        }
        for (SkillTreeNode node : this.nodes.values()) {
            try {
                if (!config.isConfigurationSection("nodes." + node.getId() + ".parents")) continue;
                for (String key : config.getConfigurationSection("nodes." + node.getId() + ".parents").getKeys(false)) {
                    ConfigurationSection configurationSection = config.getConfigurationSection("nodes." + node.getId() + ".parents." + key);
                    if (configurationSection == null) continue;
                    ParentType parentType = ParentType.valueOf(UtilityMethods.enumName((String)key));
                    for (String string : configurationSection.getKeys(false)) {
                        SkillTreeNode parent = this.getNode(string);
                        int level = configurationSection.getInt(string);
                        node.addParent(parent, parentType, level);
                        parent.addChild(node, parentType, level);
                    }
                }
            }
            catch (RuntimeException exception) {
                MMOCore.plugin.getLogger().log(Level.WARNING, "Could not load parents of skill tree node '" + node.getId() + "': " + exception.getMessage());
            }
        }
    }

    public List<String> getLore() {
        return this.lore;
    }

    public int getMaxPointSpent() {
        return this.maxPointSpent;
    }

    public int getCustomModelData() {
        return this.customModelData;
    }

    @Deprecated
    public static SkillTree loadSkillTree(ConfigurationSection config) {
        return MMOCore.plugin.skillTreeManager.loadSkillTree(config);
    }

    public void addRoot(@NotNull SkillTreeNode node) {
        this.roots.add(node);
    }

    @NotNull
    public List<SkillTreeNode> getRoots() {
        return this.roots;
    }

    public void setupNodeStates(@NotNull PlayerData playerData) {
        playerData.clearNodeStates(this);
        boolean skillTreeLocked = playerData.getPointsSpent(this) >= this.maxPointSpent;
        NodeState lockState = skillTreeLocked ? NodeState.FULLY_LOCKED : NodeState.LOCKED;
        for (SkillTreeNode node : this.nodes.values()) {
            playerData.setNodeState(node, playerData.getNodeLevel(node) > 0 ? NodeState.UNLOCKED : lockState);
        }
        if (skillTreeLocked) {
            return;
        }
        Stack<SkillTreeNode> unreachable = new Stack<SkillTreeNode>();
        HashSet<SkillTreeNode> updated = new HashSet<SkillTreeNode>();
        for (SkillTreeNode skillTreeNode : this.nodes.values()) {
            int maxChildren;
            for (ParentInformation parent : skillTreeNode.getParents()) {
                if (parent.getType() != ParentType.INCOMPATIBLE || playerData.getNodeState(parent.getNode()) != NodeState.UNLOCKED) continue;
                unreachable.add(skillTreeNode);
                break;
            }
            if ((maxChildren = skillTreeNode.getMaxChildren()) <= 0) continue;
            int unlocked = 0;
            ArrayList<SkillTreeNode> locked = new ArrayList<SkillTreeNode>();
            for (ParentInformation child : skillTreeNode.getChildren()) {
                switch (playerData.getNodeState(child.getNode())) {
                    case LOCKED: {
                        locked.add(child.getNode());
                        break;
                    }
                    case UNLOCKED: {
                        ++unlocked;
                    }
                }
            }
            if (unlocked < maxChildren) continue;
            unreachable.addAll(locked);
        }
        while (!unreachable.empty()) {
            SkillTreeNode node = (SkillTreeNode)unreachable.pop();
            updated.add(node);
            playerData.setNodeState(node, NodeState.FULLY_LOCKED);
            for (ParentInformation child : node.getChildren()) {
                if (updated.contains(child.getNode()) || !this.isUnreachable(child.getNode(), playerData)) continue;
                unreachable.push(child.getNode());
            }
        }
        block10: for (SkillTreeNode skillTreeNode : this.nodes.values()) {
            if (playerData.getNodeState(skillTreeNode) != NodeState.LOCKED) continue;
            if (skillTreeNode.isRoot()) {
                playerData.setNodeState(skillTreeNode, NodeState.UNLOCKABLE);
                continue;
            }
            boolean soft = false;
            boolean hasSoft = false;
            for (ParentInformation parent : skillTreeNode.getParents()) {
                if (parent.getType() == ParentType.STRONG && playerData.getNodeLevel(parent.getNode()) < parent.getLevel()) continue block10;
                if (soft || parent.getType() != ParentType.SOFT) continue;
                hasSoft = true;
                if (playerData.getNodeLevel(parent.getNode()) < parent.getLevel()) continue;
                soft = true;
            }
            if (hasSoft && !soft) continue;
            playerData.setNodeState(skillTreeNode, NodeState.UNLOCKABLE);
        }
    }

    private boolean isUnreachable(@NotNull SkillTreeNode node, @NotNull PlayerData playerData) {
        boolean soft = false;
        boolean hasSoft = false;
        for (ParentInformation parent : node.getParents()) {
            if (parent.getType() == ParentType.STRONG && playerData.getNodeState(parent.getNode()) == NodeState.FULLY_LOCKED) {
                return true;
            }
            if (soft || parent.getType() != ParentType.SOFT) continue;
            hasSoft = true;
            if (playerData.getNodeState(parent.getNode()) == NodeState.FULLY_LOCKED) continue;
            soft = true;
        }
        return hasSoft && !soft;
    }

    public boolean isNode(@NotNull IntegerCoordinates coordinates) {
        return this.coordNodes.containsKey(coordinates);
    }

    public boolean isPath(@NotNull IntegerCoordinates coordinates) {
        return this.coordPaths.containsKey(coordinates);
    }

    public boolean isPathOrNode(IntegerCoordinates coordinates) {
        return this.isNode(coordinates) || this.isPath(coordinates);
    }

    public Material getItem() {
        return this.item;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Collection<SkillTreeNode> getNodes() {
        return this.nodes.values();
    }

    @NotNull
    public SkillTreeNode getNode(@NotNull IntegerCoordinates coords) {
        return Objects.requireNonNull(this.coordNodes.get(coords), "Could not find node in tree '" + this.id + "' with coordinates '" + coords + "'");
    }

    @Nullable
    public SkillTreeNode getNodeOrNull(@NotNull IntegerCoordinates coords) {
        return this.coordNodes.get(coords);
    }

    @NotNull
    public SkillTreePath getPath(@NotNull IntegerCoordinates coords) {
        return Objects.requireNonNull(this.coordPaths.get(coords), "Could not find path in tree '" + this.id + "' with coordinates '" + coords + "'");
    }

    @NotNull
    public SkillTreeNode getNode(@NotNull String name) {
        return Objects.requireNonNull(this.nodes.get(name), "Could not find node in tree '" + this.id + "' with name '" + name + "'");
    }

    public boolean hasIcon(DisplayInfo displayInfo) {
        return this.icons.containsKey(displayInfo);
    }

    public Icon getIcon(DisplayInfo displayInfo) {
        return this.icons.get(displayInfo);
    }

    public boolean isNode(String name) {
        return this.nodes.containsKey(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SkillTree skillTree = (SkillTree)o;
        return this.id.equals(skillTree.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

