/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.skilltree;

import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.skilltree.IntegerCoordinates;
import net.Indyuce.mmocore.skilltree.NodeState;
import net.Indyuce.mmocore.skilltree.PathType;
import net.Indyuce.mmocore.skilltree.SkillTreeNode;
import net.Indyuce.mmocore.skilltree.tree.SkillTree;

public class SkillTreePath {
    private final SkillTree tree;
    private final IntegerCoordinates coordinates;
    private final SkillTreeNode from;
    private final SkillTreeNode to;

    public SkillTreePath(SkillTree tree, IntegerCoordinates coordinates, SkillTreeNode from, SkillTreeNode skillTreeNode) {
        this.tree = tree;
        this.coordinates = coordinates;
        this.from = from;
        this.to = skillTreeNode;
    }

    public NodeState getStatus(PlayerData playerData) {
        NodeState fromStatus = playerData.getNodeState(this.from);
        NodeState toStatus = playerData.getNodeState(this.to);
        if (fromStatus == NodeState.UNLOCKED && toStatus == NodeState.UNLOCKED) {
            return NodeState.UNLOCKED;
        }
        if (fromStatus == NodeState.UNLOCKABLE && toStatus == NodeState.UNLOCKED || fromStatus == NodeState.UNLOCKED && toStatus == NodeState.UNLOCKABLE) {
            return NodeState.UNLOCKABLE;
        }
        if (fromStatus == NodeState.FULLY_LOCKED || toStatus == NodeState.FULLY_LOCKED) {
            return NodeState.FULLY_LOCKED;
        }
        return NodeState.LOCKED;
    }

    public PathType getPathType() {
        boolean hasLeft;
        IntegerCoordinates upCoor = new IntegerCoordinates(this.coordinates.getX(), this.coordinates.getY() - 1);
        IntegerCoordinates downCoor = new IntegerCoordinates(this.coordinates.getX(), this.coordinates.getY() + 1);
        IntegerCoordinates rightCoor = new IntegerCoordinates(this.coordinates.getX() + 1, this.coordinates.getY());
        IntegerCoordinates leftCoor = new IntegerCoordinates(this.coordinates.getX() - 1, this.coordinates.getY());
        boolean hasUp = this.tree.isPath(upCoor) || upCoor.equals(this.from.getCoordinates()) || upCoor.equals(this.to.getCoordinates());
        boolean hasDown = this.tree.isPath(downCoor) || downCoor.equals(this.from.getCoordinates()) || downCoor.equals(this.to.getCoordinates());
        boolean hasRight = this.tree.isPath(rightCoor) || rightCoor.equals(this.from.getCoordinates()) || rightCoor.equals(this.to.getCoordinates());
        boolean bl = hasLeft = this.tree.isPath(leftCoor) || leftCoor.equals(this.from.getCoordinates()) || leftCoor.equals(this.to.getCoordinates());
        if ((hasUp || hasDown) && !hasLeft && !hasRight) {
            return PathType.UP;
        }
        if ((hasRight || hasLeft) && !hasUp && !hasDown) {
            return PathType.RIGHT;
        }
        if (hasUp && hasRight) {
            return PathType.UP_RIGHT;
        }
        if (hasUp && hasLeft) {
            return PathType.UP_LEFT;
        }
        if (hasDown && hasRight) {
            return PathType.DOWN_RIGHT;
        }
        if (hasDown && hasLeft) {
            return PathType.DOWN_LEFT;
        }
        return PathType.DEFAULT;
    }
}

