/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.skill.cast;

import java.util.Objects;
import java.util.function.Function;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.skill.cast.SkillCastingHandler;
import net.Indyuce.mmocore.skill.cast.handler.KeyCombos;
import net.Indyuce.mmocore.skill.cast.handler.SkillBar;
import net.Indyuce.mmocore.skill.cast.handler.SkillCastingDisabled;
import net.Indyuce.mmocore.skill.cast.handler.SkillScroller;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public enum SkillCastingMode {
    SKILL_BAR(config -> new SkillBar((ConfigurationSection)config)),
    SKILL_SCROLLER(config -> new SkillScroller((ConfigurationSection)config)),
    KEY_COMBOS(config -> new KeyCombos((ConfigurationSection)config)),
    NONE(config -> new SkillCastingDisabled((ConfigurationSection)config));

    private final Function<ConfigurationSection, SkillCastingHandler> listenerLoader;
    private static SkillCastingHandler current;

    private SkillCastingMode(Function<ConfigurationSection, SkillCastingHandler> listenerLoader) {
        this.listenerLoader = listenerLoader;
    }

    public void setCurrent(@NotNull ConfigurationSection config) {
        Validate.isTrue((current == null ? 1 : 0) != 0, (String)"Skill casting mode already initialized");
        current = this.listenerLoader.apply(config);
        Bukkit.getPluginManager().registerEvents((Listener)current, (Plugin)MMOCore.plugin);
    }

    @NotNull
    public static SkillCastingHandler getInstance() {
        return Objects.requireNonNull(current, "Skill casting mode hasn't been initialized yet");
    }

    @Deprecated
    public static SkillCastingHandler getCurrent() {
        return SkillCastingMode.getInstance();
    }
}

