/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.party.compat;

import com.civious.obteam.mechanics.Team;
import com.civious.obteam.mechanics.TeamManager;
import com.civious.obteam.mechanics.TeamMember;
import java.util.ArrayList;
import java.util.List;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.party.AbstractParty;
import net.Indyuce.mmocore.party.PartyModule;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.Nullable;

public class OBTeamPartyModule
implements PartyModule,
Listener {
    @Override
    @Nullable
    public AbstractParty getParty(PlayerData playerData) {
        @Nullable Team team = TeamManager.getInstance().getTeam((OfflinePlayer)playerData.getPlayer());
        return team == null ? null : new CustomParty(team);
    }

    private static class CustomParty
    implements AbstractParty {
        private final Team team;

        public CustomParty(Team team) {
            this.team = team;
        }

        @Override
        public boolean hasMember(Player player) {
            for (TeamMember member : this.team.getMembers()) {
                if (!member.getOfflinePlayer().getUniqueId().equals(player.getUniqueId())) continue;
                return true;
            }
            return false;
        }

        @Override
        public List<PlayerData> getOnlineMembers() {
            ArrayList<PlayerData> list = new ArrayList<PlayerData>();
            for (TeamMember member : this.team.getMembersAndOwner()) {
                try {
                    list.add(PlayerData.get(member.getOfflinePlayer()));
                }
                catch (Exception exception) {}
            }
            return list;
        }

        @Override
        public int countMembers() {
            return this.team.getMembersAndOwner().size();
        }
    }
}

