/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.manager;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.ConfigFile;
import net.Indyuce.mmocore.manager.MMOCoreManager;
import net.Indyuce.mmocore.skill.RegisteredSkill;
import net.Indyuce.mmocore.skill.list.Ambers;
import net.Indyuce.mmocore.skill.list.Neptune_Gift;
import net.Indyuce.mmocore.skill.list.Sneaky_Picky;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkillManager
implements MMOCoreManager {
    private final Map<String, RegisteredSkill> skills = new LinkedHashMap<String, RegisteredSkill>();

    public void registerSkill(RegisteredSkill skill) {
        this.skills.put(skill.getHandler().getId().toUpperCase(), skill);
    }

    @Nullable
    public RegisteredSkill getSkill(String id) {
        return this.skills.get(id.toUpperCase());
    }

    @NotNull
    public RegisteredSkill getSkillOrThrow(String id) {
        return Objects.requireNonNull(this.skills.get(id), "Could not find skill with ID '" + id + "'");
    }

    public Collection<RegisteredSkill> getAll() {
        return this.skills.values();
    }

    @Override
    public void initialize(boolean clearBefore) {
        if (clearBefore) {
            MythicLib.plugin.getSkills().initialize(true);
            this.skills.clear();
        }
        MythicLib.plugin.getSkills().registerSkillHandler((SkillHandler)new Ambers());
        MythicLib.plugin.getSkills().registerSkillHandler((SkillHandler)new Neptune_Gift());
        MythicLib.plugin.getSkills().registerSkillHandler((SkillHandler)new Sneaky_Picky());
        File skillFolder = FileUtils.getFile((Plugin)MMOCore.plugin, (String)"skills");
        if (!skillFolder.exists()) {
            try {
                skillFolder.mkdir();
                for (SkillHandler handler : MythicLib.plugin.getSkills().getHandlers()) {
                    InputStream res = MMOCore.plugin.getResource("default/skills/" + handler.getLowerCaseId() + ".yml");
                    if (res == null) continue;
                    Files.copy(res, new File(MMOCore.plugin.getDataFolder() + "/skills/" + handler.getLowerCaseId() + ".yml").getAbsoluteFile().toPath(), new CopyOption[0]);
                }
            }
            catch (IOException exception) {
                MMOCore.plugin.getLogger().log(Level.WARNING, "Could not save default skill configs: " + exception.getMessage());
            }
        }
        ConfigFile generated = new ConfigFile((Plugin)MMOCore.plugin, "", "_generated_skill_configs");
        List generatedSkillHandlerIds = generated.getConfig().getStringList("list");
        for (SkillHandler handler : MythicLib.plugin.getSkills().getHandlers()) {
            if (generatedSkillHandlerIds.contains(handler.getId())) continue;
            generatedSkillHandlerIds.add(handler.getId());
            ConfigFile config2 = new ConfigFile("/skills", handler.getLowerCaseId());
            if (config2.exists()) continue;
            config2.getConfig().set("name", (Object)UtilityMethods.caseOnWords((String)handler.getId().replace("_", " ").replace("-", " ").toLowerCase()));
            config2.getConfig().set("lore", Arrays.asList("This is the default skill description", "", "&e{cooldown}s Cooldown", "&9Costs {mana} {mana_name}"));
            config2.getConfig().set("material", (Object)"BOOK");
            for (Object param : handler.getParameters()) {
                config2.getConfig().set(param + ".base", (Object)0);
                config2.getConfig().set(param + ".per-level", (Object)0);
                config2.getConfig().set(param + ".min", (Object)0);
                config2.getConfig().set(param + ".max", (Object)0);
            }
            config2.save();
        }
        generated.getConfig().set("list", (Object)generatedSkillHandlerIds);
        generated.save();
        FileUtils.loadObjectsFromFolder((Plugin)MMOCore.plugin, (String)"skills", (boolean)true, (name, config) -> {
            SkillHandler handler = MythicLib.plugin.getSkills().getHandler(UtilityMethods.enumName((String)name));
            Validate.notNull((Object)handler, (String)("Could not find skill handler with ID '" + UtilityMethods.enumName((String)name) + "'"));
            RegisteredSkill skill = new RegisteredSkill((SkillHandler<?>)handler, (ConfigurationSection)config);
            this.skills.put(handler.getId(), skill);
        }, (String)"Could not load skill from file '%s': %s");
    }
}

