/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.manager;

import io.lumine.mythic.lib.util.FileUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.player.profess.ClassOption;
import net.Indyuce.mmocore.api.player.profess.PlayerClass;
import net.Indyuce.mmocore.api.player.profess.event.EventTriggerHandler;
import net.Indyuce.mmocore.api.player.profess.event.trigger.AttackEventTrigger;
import net.Indyuce.mmocore.api.player.profess.event.trigger.BlockBrokenTrigger;
import net.Indyuce.mmocore.api.player.profess.event.trigger.BlockPlacedTrigger;
import net.Indyuce.mmocore.api.player.profess.event.trigger.ClassChosenEventTrigger;
import net.Indyuce.mmocore.api.player.profess.event.trigger.LevelUpEventTrigger;
import net.Indyuce.mmocore.api.player.profess.event.trigger.MultipleLevelUpEventTrigger;
import net.Indyuce.mmocore.manager.MMOCoreManager;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ClassManager
implements MMOCoreManager {
    private final Map<String, PlayerClass> map = new HashMap<String, PlayerClass>();
    private PlayerClass defaultClass;
    private final Set<EventTriggerHandler> triggerHandlers = new HashSet<EventTriggerHandler>();

    public ClassManager() {
        this.registerEvent(new LevelUpEventTrigger());
        this.registerEvent(new AttackEventTrigger());
        this.registerEvent(new ClassChosenEventTrigger());
        this.registerEvent(new BlockBrokenTrigger());
        this.registerEvent(new BlockPlacedTrigger());
        this.registerEvent(new MultipleLevelUpEventTrigger());
    }

    @Deprecated
    public void registerEvent(EventTriggerHandler handler) {
        this.triggerHandlers.add(handler);
    }

    public void register(PlayerClass playerClass) {
        this.map.put(playerClass.getId(), playerClass);
        MMOCore.plugin.statManager.getRegistered().addAll(playerClass.getStats());
    }

    public boolean has(String id) {
        return this.map.containsKey(id);
    }

    public PlayerClass get(String id) {
        return this.map.get(id);
    }

    public PlayerClass getOrThrow(String id) {
        PlayerClass found = this.map.get(id);
        Validate.notNull((Object)found, (String)("Could not find class with ID '" + id + "'"));
        return found;
    }

    public Collection<PlayerClass> getAll() {
        return this.map.values();
    }

    public PlayerClass getDefaultClass() {
        return this.defaultClass;
    }

    @Override
    public void initialize(boolean clearBefore) {
        if (clearBefore) {
            this.map.clear();
            this.triggerHandlers.forEach(HandlerList::unregisterAll);
        }
        FileUtils.loadObjectsFromFolder((Plugin)MMOCore.plugin, (String)"classes", (boolean)true, (name, config) -> this.register(new PlayerClass((String)name, (ConfigurationSection)config)), (String)"Could not load class from file '%s': %s");
        for (PlayerClass profess2 : this.map.values()) {
            try {
                profess2.getPostLoadAction().performAction();
            }
            catch (IllegalArgumentException exception) {
                MMOCore.plugin.getLogger().log(Level.WARNING, "Could not post-load class '" + profess2.getId() + "': " + exception.getMessage());
            }
        }
        this.defaultClass = this.map.values().stream().filter(profess -> profess.hasOption(ClassOption.DEFAULT)).findFirst().orElse(new PlayerClass("HUMAN", "Human", Material.LEATHER_BOOTS));
        this.triggerHandlers.forEach(handler -> Bukkit.getPluginManager().registerEvents((Listener)handler, (Plugin)MMOCore.plugin));
    }
}

