/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.loot.chest.particle;

import io.lumine.mythic.lib.UtilityMethods;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.lang.Validate;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;

public class CastingParticle {
    private final Consumer<Location> display;

    public CastingParticle(@NotNull ConfigurationSection config) {
        Validate.notNull((Object)config, (String)"Casting particle config cannot be null");
        Particle particle = Particle.valueOf((String)UtilityMethods.enumName((String)Objects.requireNonNull(config.getString("particle"), "Could not find particle name")));
        if (particle.getDataType() == Particle.DustOptions.class) {
            float size = Math.max((float)config.getDouble("size", 1.0), 0.0f);
            Color color = Color.fromRGB((int)config.getInt("color.red"), (int)config.getInt("color.green"), (int)config.getInt("color.blue"));
            this.display = loc -> loc.getWorld().spawnParticle(particle, loc, 1, (Object)new Particle.DustOptions(color, size));
        } else if (particle.getDataType() == BlockData.class) {
            Material material = Material.valueOf((String)UtilityMethods.enumName((String)Objects.requireNonNull(config.getString("material"), "Particle requires a block")));
            this.display = loc -> loc.getWorld().spawnParticle(particle, loc, 1, (Object)material.createBlockData());
        } else {
            this.display = loc -> loc.getWorld().spawnParticle(particle, loc, 0);
        }
    }

    public CastingParticle(Particle particle) {
        this.display = loc -> loc.getWorld().spawnParticle(particle, loc, 0);
    }

    public void display(Location loc) {
        this.display.accept(loc);
    }
}

