/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.loot.chest.condition;

import io.lumine.mythic.lib.api.MMOLineConfig;
import net.Indyuce.mmocore.loot.chest.condition.Condition;
import net.Indyuce.mmocore.loot.chest.condition.ConditionInstance;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Location;

public class DistanceCondition
extends Condition {
    private final Location location;
    private final double distance;

    public DistanceCondition(MMOLineConfig config) {
        super(config);
        Validate.isTrue((boolean)config.contains("world"));
        Validate.isTrue((boolean)config.contains("x"));
        Validate.isTrue((boolean)config.contains("y"));
        Validate.isTrue((boolean)config.contains("z"));
        Validate.isTrue((boolean)config.contains("distance"));
        Validate.isTrue((Bukkit.getWorld((String)config.getString("world")) != null ? 1 : 0) != 0, (String)"This world doesn't exist");
        this.location = new Location(Bukkit.getWorld((String)config.getString("world")), config.getDouble("x"), config.getDouble("y"), config.getDouble("z"));
        this.distance = config.getDouble("distance");
    }

    @Override
    public boolean isMet(ConditionInstance instance) {
        return instance.getLocation().getWorld().equals((Object)this.location.getWorld()) && this.location.distance(instance.getLocation()) < this.distance;
    }
}

