/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.guild.provided;

import java.io.File;
import java.util.ArrayList;
import java.util.UUID;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.ConfigFile;
import net.Indyuce.mmocore.guild.provided.Guild;
import net.Indyuce.mmocore.manager.data.GuildDataManager;
import org.bukkit.configuration.file.YamlConfiguration;

public class YAMLGuildDataManager
extends GuildDataManager {
    @Override
    public void save(Guild guild) {
        ConfigFile config = new ConfigFile(guild);
        config.getConfig().set("name", (Object)guild.getName());
        config.getConfig().set("tag", (Object)guild.getTag());
        config.getConfig().set("owner", (Object)guild.getOwner().toString());
        ArrayList memberList = new ArrayList();
        guild.forEachMember(uuid -> memberList.add(uuid.toString()));
        config.getConfig().set("members", memberList);
        config.save();
    }

    @Override
    public void load() {
        File guildsFolder = new File(MMOCore.plugin.getDataFolder(), "guilds");
        if (!guildsFolder.exists()) {
            guildsFolder.mkdirs();
        }
        for (File file : guildsFolder.listFiles()) {
            if (file.isDirectory() || !file.getName().substring(file.getName().lastIndexOf(46)).equalsIgnoreCase(".yml")) continue;
            YamlConfiguration c = YamlConfiguration.loadConfiguration((File)file);
            Guild guild = this.newRegisteredGuild(UUID.fromString(c.getString("owner")), c.getString("name"), c.getString("tag"));
            for (String m : c.getStringList("members")) {
                guild.registerMember(UUID.fromString(m));
            }
        }
    }

    @Override
    public void delete(Guild guild) {
        new ConfigFile(guild).delete();
    }
}

