/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.gui.social.guild;

import java.util.List;
import java.util.UUID;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.ConfigMessage;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.api.util.input.ChatInput;
import net.Indyuce.mmocore.api.util.input.PlayerInput;
import net.Indyuce.mmocore.api.util.math.format.DelayFormat;
import net.Indyuce.mmocore.gui.api.EditableInventory;
import net.Indyuce.mmocore.gui.api.GeneratedInventory;
import net.Indyuce.mmocore.gui.api.InventoryClickContext;
import net.Indyuce.mmocore.gui.api.item.InventoryItem;
import net.Indyuce.mmocore.gui.api.item.Placeholders;
import net.Indyuce.mmocore.gui.api.item.SimplePlaceholderItem;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Consumer;

public class EditableGuildAdmin
extends EditableInventory {
    private static final NamespacedKey UUID_NAMESPACEDKEY = new NamespacedKey((Plugin)MMOCore.plugin, "Uuid");

    public EditableGuildAdmin() {
        super("guild-admin");
    }

    @Override
    public InventoryItem load(String function, ConfigurationSection config) {
        return function.equals("member") ? new MemberItem(config) : new SimplePlaceholderItem(config);
    }

    public GeneratedInventory newInventory(PlayerData data) {
        return new GuildViewInventory(data, this);
    }

    public static class MemberItem
    extends SimplePlaceholderItem<GuildViewInventory> {
        private final InventoryItem empty;
        private final MemberDisplayItem member;

        public MemberItem(ConfigurationSection config) {
            super(config);
            Validate.notNull((Object)config.contains("empty"), (String)"Could not load empty config");
            Validate.notNull((Object)config.contains("member"), (String)"Could not load member config");
            this.empty = new SimplePlaceholderItem(config.getConfigurationSection("empty"));
            this.member = new MemberDisplayItem(this, config.getConfigurationSection("member"));
        }

        @Override
        public ItemStack display(GuildViewInventory inv, int n) {
            return inv.getPlayerData().getGuild().countMembers() > n ? this.member.display(inv, n) : this.empty.display(inv, n);
        }

        @Override
        public boolean hasDifferentDisplay() {
            return true;
        }
    }

    public class GuildViewInventory
    extends GeneratedInventory {
        private final int max;
        private List<UUID> members;

        public GuildViewInventory(PlayerData playerData, EditableInventory editable) {
            super(playerData, editable);
            this.max = editable.getByFunction("member").getSlots().size();
        }

        @Override
        public void open() {
            this.members = this.playerData.getGuild().listMembers();
            super.open();
        }

        @Override
        public String calculateName() {
            return EditableGuildAdmin.this.getName().replace("{max}", "" + this.max).replace("{players}", "" + this.getPlayerData().getGuild().countMembers());
        }

        @Override
        public void whenClicked(InventoryClickContext context, InventoryItem item) {
            if (item.getFunction().equals("leave")) {
                this.playerData.getGuild().removeMember(this.playerData.getUniqueId());
                this.player.playSound(this.player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                this.player.closeInventory();
                return;
            }
            if (item.getFunction().equals("invite")) {
                if (this.playerData.getGuild().countMembers() >= this.max) {
                    ConfigMessage.fromKey("guild-is-full", new Object[0]).send(this.player);
                    this.player.playSound(this.player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                    return;
                }
                new ChatInput(this.player, PlayerInput.InputType.GUILD_INVITE, context.getInventoryHolder(), (Consumer<String>)((Consumer)input -> {
                    Player target = Bukkit.getPlayer((String)input);
                    if (target == null) {
                        ConfigMessage.fromKey("not-online-player", "player", input).send(this.player);
                        this.player.playSound(this.player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                        this.open();
                        return;
                    }
                    long remaining = this.playerData.getGuild().getLastInvite(target) + 120000L - System.currentTimeMillis();
                    if (remaining > 0L) {
                        ConfigMessage.fromKey("guild-invite-cooldown", "player", target.getName(), "cooldown", new DelayFormat().format(remaining)).send(this.player);
                        this.open();
                        return;
                    }
                    PlayerData targetData = PlayerData.get((OfflinePlayer)target);
                    if (this.playerData.getGuild().hasMember(target.getUniqueId())) {
                        ConfigMessage.fromKey("already-in-guild", "player", target.getName()).send(this.player);
                        this.player.playSound(this.player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                        this.open();
                        return;
                    }
                    this.playerData.getGuild().sendGuildInvite(this.playerData, targetData);
                    ConfigMessage.fromKey("sent-guild-invite", "player", target.getName()).send(this.player);
                    this.player.playSound(this.player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                    this.open();
                }));
            }
            if (item.getFunction().equals("member") && context.getClickType() == ClickType.RIGHT) {
                if (!this.playerData.getGuild().getOwner().equals(this.playerData.getUniqueId())) {
                    return;
                }
                OfflinePlayer target = Bukkit.getOfflinePlayer((UUID)UUID.fromString((String)context.getClickedItem().getItemMeta().getPersistentDataContainer().get(UUID_NAMESPACEDKEY, PersistentDataType.STRING)));
                if (target.equals((Object)this.player)) {
                    return;
                }
                this.playerData.getGuild().removeMember(target.getUniqueId());
                ConfigMessage.fromKey("kick-from-guild", "player", target.getName()).send(this.player);
                this.player.playSound(this.player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
            }
        }
    }

    public static class MemberDisplayItem
    extends InventoryItem<GuildViewInventory> {
        public MemberDisplayItem(MemberItem memberItem, ConfigurationSection config) {
            super(memberItem, config);
        }

        @Override
        public boolean hasDifferentDisplay() {
            return true;
        }

        @Override
        public Placeholders getPlaceholders(GuildViewInventory inv, int n) {
            PlayerData member = PlayerData.get((UUID)inv.members.get(n));
            Placeholders holders = new Placeholders();
            if (member.isOnline()) {
                holders.register("name", member.getPlayer().getName());
            }
            holders.register("class", member.getProfess().getName());
            holders.register("level", "" + member.getLevel());
            holders.register("since", new DelayFormat(2).format(System.currentTimeMillis() - member.getLastLogin()));
            return holders;
        }

        @Override
        public ItemStack display(GuildViewInventory inv, int n) {
            UUID uuid = (UUID)inv.members.get(n);
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
            ItemStack disp = super.display(inv, n);
            ItemMeta meta = disp.getItemMeta();
            meta.getPersistentDataContainer().set(UUID_NAMESPACEDKEY, PersistentDataType.STRING, (Object)uuid.toString());
            if (meta instanceof SkullMeta && offlinePlayer != null) {
                inv.asyncUpdate(this, n, disp, current -> {
                    ((SkullMeta)meta).setOwningPlayer(offlinePlayer);
                    current.setItemMeta(meta);
                });
            }
            disp.setItemMeta(meta);
            return disp;
        }
    }
}

