/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.gui.eco;

import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import net.Indyuce.mmocore.api.util.MMOCoreUtils;
import net.Indyuce.mmocore.gui.api.InventoryClickContext;
import net.Indyuce.mmocore.gui.api.PluginInventory;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class GoldPouch
extends PluginInventory {
    private final boolean mob;
    private final NBTItem nbt;

    public GoldPouch(Player player, NBTItem nbt) {
        super(player);
        this.nbt = nbt;
        this.mob = nbt.getBoolean("RpgPouchMob");
    }

    public Inventory getInventory() {
        Inventory inv = Bukkit.createInventory((InventoryHolder)this, (int)18, (String)(ChatColor.UNDERLINE + "Gold Pouch"));
        inv.setContents(MMOCoreUtils.itemStackArrayFromBase64(this.nbt.getString("RpgPouchInventory")));
        return inv;
    }

    @Override
    public void whenClicked(InventoryClickContext context) {
        ItemStack item = context.getClickedItem();
        if (item == null || item.getType() == Material.AIR) {
            context.setCancelled(true);
            return;
        }
        NBTItem nbt = NBTItem.get((ItemStack)item);
        if (!nbt.hasTag("RpgWorth")) {
            context.setCancelled(true);
            return;
        }
        if (this.mob) {
            context.setCancelled(true);
            if (context.getSlot() < 18) {
                int empty = this.player.getInventory().firstEmpty();
                if (empty < 0) {
                    return;
                }
                this.player.playSound(this.player.getLocation(), Sound.ENTITY_SHULKER_TELEPORT, 1.0f, 2.0f);
                this.player.getInventory().addItem(new ItemStack[]{context.getClickedItem()});
                context.getInventory().setItem(context.getSlot(), null);
            }
            return;
        }
        if (nbt.hasTag("RpgPouchInventory")) {
            context.setCancelled(true);
        }
    }

    @Override
    public void whenClosed(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        if (this.mob && this.isEmpty(event.getInventory())) {
            player.getEquipment().setItemInMainHand(null);
            return;
        }
        ItemStack updated = NBTItem.get((ItemStack)player.getEquipment().getItemInMainHand()).addTag(new ItemTag[]{new ItemTag("RpgPouchInventory", (Object)MMOCoreUtils.toBase64(event.getInventory().getContents()))}).toItem();
        player.getEquipment().setItemInMainHand(updated);
    }

    private boolean isEmpty(Inventory inv) {
        for (ItemStack item : inv.getContents()) {
            if (item == null || item.getType() == Material.AIR) continue;
            return false;
        }
        return true;
    }
}

