/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.gui.eco;

import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.util.SmartGive;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.ConfigMessage;
import net.Indyuce.mmocore.api.util.MMOCoreUtils;
import net.Indyuce.mmocore.gui.api.InventoryClickContext;
import net.Indyuce.mmocore.gui.api.PluginInventory;
import net.Indyuce.mmocore.util.item.SimpleItemBuilder;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DepositMenu
extends PluginInventory {
    private ItemStack depositItem;
    private int deposit;
    private BukkitRunnable updateRunnable;

    public DepositMenu(Player player) {
        super(player);
    }

    public Inventory getInventory() {
        Inventory inv = Bukkit.createInventory((InventoryHolder)this, (int)27, (String)"Deposit");
        this.updateDeposit(inv);
        return inv;
    }

    @Override
    public void whenClicked(InventoryClickContext event) {
        if (event.getClickedItem().isSimilar(this.depositItem)) {
            event.setCancelled(true);
            this.updateDeposit(event.getInventory());
            if (this.deposit <= 0) {
                return;
            }
            EconomyResponse response = MMOCore.plugin.economy.getEconomy().depositPlayer((OfflinePlayer)this.player, (double)this.deposit);
            if (!response.transactionSuccess()) {
                return;
            }
            event.getInventory().clear();
            this.player.closeInventory();
            this.player.playSound(this.player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 2.0f);
            ConfigMessage.fromKey("deposit", "worth", String.valueOf(this.deposit)).send(this.player);
            return;
        }
        int worth = NBTItem.get((ItemStack)event.getClickedItem()).getInteger("RpgWorth");
        if (worth < 1) {
            event.setCancelled(true);
        } else {
            this.scheduleUpdate(event.getInventory());
        }
    }

    @Override
    public void whenClosed(InventoryCloseEvent event) {
        if (this.updateRunnable != null) {
            this.updateRunnable.cancel();
        }
        SmartGive smart = new SmartGive(this.player);
        for (int j = 0; j < 26; ++j) {
            ItemStack item = event.getInventory().getItem(j);
            if (item == null) continue;
            smart.give(new ItemStack[]{item});
        }
    }

    private BukkitRunnable newUpdateRunnable(final Inventory inv) {
        return new BukkitRunnable(){

            public void run() {
                DepositMenu.this.updateDeposit(inv);
            }
        };
    }

    private void scheduleUpdate(final Inventory inv) {
        if (this.updateRunnable != null) {
            this.updateRunnable.cancel();
        }
        this.updateRunnable = new BukkitRunnable(){

            public void run() {
                DepositMenu.this.updateRunnable = null;
                DepositMenu.this.updateDeposit(inv);
            }
        };
        this.updateRunnable.runTaskLater((Plugin)MMOCore.plugin, 10L);
    }

    private void updateDeposit(Inventory inv) {
        if (this.updateRunnable != null) {
            this.updateRunnable.cancel();
            this.updateRunnable = null;
        }
        this.deposit = MMOCoreUtils.getWorth(inv.getContents());
        this.depositItem = new SimpleItemBuilder("DEPOSIT_ITEM").addPlaceholders("worth", String.valueOf(this.deposit)).build();
        inv.setItem(26, this.depositItem);
    }
}

