/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.gui.api.adaptor;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import io.lumine.mythic.lib.api.util.TemporaryListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.gui.api.GeneratedInventory;
import net.Indyuce.mmocore.gui.api.InventoryClickContext;
import net.Indyuce.mmocore.gui.api.adaptor.Adaptor;
import net.Indyuce.mmocore.gui.api.item.InventoryItem;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ThreeDimAdaptor
extends Adaptor {
    private final double INITIAL_PERCENTAGE = 0.2;
    private final double INCREMENT_PERCENTAGE = 0.2;
    private SpawnPacketListener packetListener;
    private InteractListener interactListener;
    private final HashMap<Integer, ArmorStand> armorStands = new HashMap();
    private final HashSet<ArmorStand> loreArmorStand = new HashSet();
    private final HashMap<ItemStack, ArmorStand> hiddenArmorStand = new HashMap();
    protected double radius;
    protected double angleGap;
    protected double verticalGap;
    protected double curvature;
    protected double verticalOffset;
    protected double interactSensitivity;
    private boolean firstTime = true;
    private final Vector direction = this.generated.getPlayer().getEyeLocation().getDirection().setY(0);
    private final Location location;
    private int zoomed = -1;

    public ThreeDimAdaptor(GeneratedInventory generated) {
        super(generated);
        this.radius = generated.getEditable().getConfig().getDouble("radius", 2.0);
        this.angleGap = generated.getEditable().getConfig().getDouble("angle-gap", 10.0);
        this.verticalGap = generated.getEditable().getConfig().getDouble("vertical-gap", 1.0);
        this.curvature = generated.getEditable().getConfig().getDouble("curvature", 1.0);
        this.verticalOffset = generated.getEditable().getConfig().getDouble("vertical-offset", 0.0);
        this.interactSensitivity = generated.getEditable().getConfig().getDouble("interact-sensitivity", 0.97);
        this.location = generated.getPlayer().getLocation().add(new Vector(0.0, this.verticalOffset, 0.0));
    }

    @Override
    public void open() {
        if (!this.firstTime) {
            this.fastClose();
            this.fastOpen();
            return;
        }
        this.firstTime = false;
        this.interactListener = new InteractListener();
        for (InventoryItem item : this.generated.getEditable().getItems()) {
            if (!item.canDisplay(this.generated)) continue;
            this.setInventoryItem(item, 0.2);
        }
        new BukkitRunnable(){
            double total_percentage = 0.2;

            public void run() {
                if (this.total_percentage < 1.0) {
                    this.total_percentage += 0.2;
                    Iterator iterator = ThreeDimAdaptor.this.armorStands.keySet().iterator();
                    while (iterator.hasNext()) {
                        int slot = (Integer)iterator.next();
                        ((ArmorStand)ThreeDimAdaptor.this.armorStands.get(slot)).teleport(ThreeDimAdaptor.this.getLocation(slot, this.total_percentage));
                    }
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)MMOCore.plugin, 0L, 1L);
    }

    @Override
    public void close() {
        this.interactListener.close();
        this.removeLore();
        new BukkitRunnable(){
            double total_percentage = 1.0;

            public void run() {
                if (this.total_percentage > 0.2) {
                    this.total_percentage -= 0.2;
                    Iterator iterator = ThreeDimAdaptor.this.armorStands.keySet().iterator();
                    while (iterator.hasNext()) {
                        int slot = (Integer)iterator.next();
                        ((ArmorStand)ThreeDimAdaptor.this.armorStands.get(slot)).teleport(ThreeDimAdaptor.this.getLocation(slot, this.total_percentage));
                    }
                } else {
                    for (ArmorStand armorStand : ThreeDimAdaptor.this.armorStands.values()) {
                        armorStand.remove();
                    }
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)MMOCore.plugin, 0L, 1L);
    }

    public void fastOpen() {
        this.interactListener = new InteractListener();
        for (InventoryItem item : this.generated.getEditable().getItems()) {
            if (!item.canDisplay(this.generated)) continue;
            this.setInventoryItem(item, 1.0);
        }
        if (this.zoomed != -1) {
            this.displayLore(this.zoomed);
            this.armorStands.get(this.zoomed).teleport(this.getLocation(this.zoomed, 0.75));
        }
    }

    public void fastClose() {
        this.interactListener.close();
        for (ArmorStand armorStand : this.armorStands.values()) {
            armorStand.remove();
        }
        this.removeLore();
    }

    private void setInventoryItem(InventoryItem item, double percentage) {
        this.generated.addLoaded(item);
        List<Integer> slots = item.getSlots();
        if (item.hasDifferentDisplay()) {
            for (int i : slots) {
                this.setItem(item.display(this.generated, i), i, percentage);
            }
        } else {
            ItemStack itemStack = item.display(this.generated);
            for (int i : slots) {
                this.setItem(itemStack, i, percentage);
            }
        }
    }

    private void setItem(ItemStack item, int n, double percentage) {
        Location location = this.getLocation(n, percentage);
        if (item.getType().toString().contains("SKULL") || item.getType().toString().contains("HEAD")) {
            location.add(new Vector(0.0, 4.9, 0.0));
        }
        ArmorStand armorStand = (ArmorStand)this.generated.getPlayer().getWorld().spawnEntity(location, EntityType.ARMOR_STAND);
        armorStand.setVisible(true);
        armorStand.setSmall(false);
        armorStand.setArms(true);
        armorStand.setGravity(false);
        armorStand.getEquipment().setItem(EquipmentSlot.HEAD, item);
        if (item.hasItemMeta() && item.getItemMeta().getDisplayName() != null) {
            armorStand.setCustomName(item.getItemMeta().getDisplayName());
        }
        armorStand.setCustomNameVisible(true);
        PersistentDataContainer container = armorStand.getPersistentDataContainer();
        container.set(new NamespacedKey((Plugin)MMOCore.plugin, "slot"), PersistentDataType.INTEGER, (Object)n);
        this.armorStands.put(n, armorStand);
    }

    public void displayLore(int n) {
        ArmorStand armorStand = this.armorStands.get(n);
        ItemStack itemStack = armorStand.getEquipment().getItem(EquipmentSlot.HEAD);
        Location initalLocation = this.getLocation(n, 1.0);
        for (ArmorStand armorStand1 : this.armorStands.values()) {
            armorStand1.setCustomNameVisible(false);
        }
        Vector xAxis = initalLocation.clone().toVector().subtract(this.generated.getPlayer().getLocation().toVector()).setY(0).normalize();
        Vector yAxis = new Vector(0, 1, 0);
        Vector zAxis = xAxis.clone().rotateAroundAxis(yAxis, -1.5707963267948966);
        double lineHeight = 0.25;
        double charSize = 0.09;
        int max = 0;
        for (String line : itemStack.getItemMeta().getLore()) {
            if (line.length() <= max) continue;
            max = line.length();
        }
        initalLocation.add(zAxis.clone().multiply((double)max * charSize / 2.0 + 0.8)).add(yAxis.clone().multiply(2.0 + 0.125 * (double)itemStack.getItemMeta().getLore().size()));
        for (String line : itemStack.getItemMeta().getLore()) {
            if (line.length() != 0) {
                ArmorStand as = (ArmorStand)initalLocation.getWorld().spawnEntity(initalLocation, EntityType.ARMOR_STAND);
                as.setSmall(false);
                as.setMarker(true);
                as.setVisible(false);
                as.setCustomNameVisible(true);
                as.setCustomName(line);
                this.loreArmorStand.add(as);
            }
            initalLocation.add(yAxis.clone().multiply(-lineHeight));
        }
        double totalHeight = lineHeight * (double)itemStack.getItemMeta().getLore().size();
        double totalLength = (double)max * charSize;
        Location topCorner = this.getLocation(n, 1.0).add(yAxis.clone().multiply(armorStand.getHeight() * 0.25 + totalHeight / 2.0));
        for (int slot : this.armorStands.keySet()) {
            ArmorStand otherArmorStand = this.armorStands.get(slot);
            if (otherArmorStand.equals((Object)armorStand)) continue;
            Vector direction = otherArmorStand.getLocation().add(new Vector(0.0, 0.25 * otherArmorStand.getHeight(), 0.0)).subtract(this.generated.getPlayer().getLocation()).toVector().normalize();
            double t = xAxis.clone().dot(topCorner.clone().subtract(this.generated.getPlayer().getLocation()).toVector()) / xAxis.clone().dot(direction);
            Vector relativeProjection = this.generated.getPlayer().getLocation().toVector().add(direction.multiply(t)).subtract(topCorner.toVector());
            double z = zAxis.dot(relativeProjection);
            double y = (double)(n / 9 - slot / 9) * lineHeight + totalHeight / 2.0;
            if (!(z > 0.0) || !(z < totalLength) || !(y > 0.0) || !(y < totalHeight)) continue;
            this.hideArmorStand(otherArmorStand);
        }
    }

    public void hideArmorStand(ArmorStand armorStand) {
        this.hiddenArmorStand.put(armorStand.getEquipment().getItem(EquipmentSlot.HEAD), armorStand);
        armorStand.getEquipment().setItem(EquipmentSlot.HEAD, null);
    }

    public void reestablishHiddenArmorStand() {
        for (ItemStack item : this.hiddenArmorStand.keySet()) {
            this.hiddenArmorStand.get(item).getEquipment().setItem(EquipmentSlot.HEAD, item);
        }
        this.hiddenArmorStand.clear();
    }

    public void removeLore() {
        for (ArmorStand armorStand : this.loreArmorStand) {
            armorStand.remove();
        }
        this.loreArmorStand.clear();
        for (ArmorStand armorStand1 : this.armorStands.values()) {
            armorStand1.setCustomNameVisible(true);
        }
        this.reestablishHiddenArmorStand();
    }

    public Location getLocation(int n, double percentage) {
        Location cloneLocation = this.location.clone();
        Vector cloneDirection = this.direction.clone().rotateAroundAxis(new Vector(0, 1, 0), (double)(-(n % 9 - 4)) * this.angleGap * Math.PI / 180.0);
        double radius = percentage * this.radius / Math.cos((1.0 - this.curvature) * (double)(-(n % 9 - 4)) * this.angleGap * Math.PI / 180.0);
        cloneDirection = cloneDirection.normalize().multiply(radius);
        cloneDirection.add(new Vector(0.0, percentage * this.verticalGap * (double)((this.generated.getEditable().getSlots() - n - 1) / 9), 1.0));
        cloneLocation.add(cloneDirection);
        cloneLocation.setDirection(new Vector(-cloneDirection.getX(), 0.0, -cloneDirection.getZ()));
        return cloneLocation;
    }

    @Override
    public void asyncUpdate(InventoryItem<?> item, int n, ItemStack placed, Consumer<ItemStack> update) {
    }

    @Override
    public <T> void asyncUpdate(CompletableFuture<T> future, InventoryItem<?> item, int n, ItemStack placed, BiConsumer<T, ItemStack> update) {
    }

    private class InteractListener
    extends TemporaryListener {
        public InteractListener() {
            super((JavaPlugin)MMOCore.plugin, new HandlerList[]{PlayerInteractAtEntityEvent.getHandlerList(), PlayerMoveEvent.getHandlerList(), PlayerInteractEvent.getHandlerList(), PlayerInteractAtEntityEvent.getHandlerList()});
        }

        @EventHandler
        public void onMove(PlayerMoveEvent e) {
            if (e.getPlayer().equals((Object)ThreeDimAdaptor.this.generated.getPlayer())) {
                if (!e.getFrom().getBlock().getLocation().equals((Object)e.getTo().getBlock().getLocation())) {
                    ThreeDimAdaptor.this.close();
                } else {
                    int closest = -1;
                    double closestScalar = 1.0;
                    Iterator iterator = ThreeDimAdaptor.this.armorStands.keySet().iterator();
                    while (iterator.hasNext()) {
                        int n = (Integer)iterator.next();
                        ArmorStand as = (ArmorStand)ThreeDimAdaptor.this.armorStands.get(n);
                        Location asLocation = as.getLocation().add(new Vector(0.0, 0.25 * as.getHeight(), 0.0));
                        double scalar = ThreeDimAdaptor.this.generated.getPlayer().getLocation().getDirection().normalize().dot(asLocation.subtract(ThreeDimAdaptor.this.generated.getPlayer().getLocation()).toVector().normalize());
                        if (!(scalar > ThreeDimAdaptor.this.interactSensitivity) || !(scalar < closestScalar)) continue;
                        closestScalar = scalar;
                        closest = n;
                    }
                    if (closest != ThreeDimAdaptor.this.zoomed) {
                        if (ThreeDimAdaptor.this.zoomed != -1) {
                            ThreeDimAdaptor.this.removeLore();
                            ((ArmorStand)ThreeDimAdaptor.this.armorStands.get(ThreeDimAdaptor.this.zoomed)).teleport(ThreeDimAdaptor.this.getLocation(ThreeDimAdaptor.this.zoomed, 1.0));
                        }
                        if (closest != -1) {
                            ((ArmorStand)ThreeDimAdaptor.this.armorStands.get(ThreeDimAdaptor.this.zoomed)).teleport(ThreeDimAdaptor.this.getLocation(closest, 0.75));
                            ThreeDimAdaptor.this.zoomed = closest;
                            ThreeDimAdaptor.this.displayLore(closest);
                        }
                    }
                }
            }
        }

        @EventHandler
        public void onInteract(PlayerInteractAtEntityEvent event) {
            if (event.getPlayer().equals((Object)ThreeDimAdaptor.this.generated.getPlayer()) && event.getRightClicked() instanceof ArmorStand) {
                event.setCancelled(true);
            }
        }

        @EventHandler
        public void onInteract(PlayerInteractEvent event) {
            if (event.getPlayer().equals((Object)ThreeDimAdaptor.this.generated.getPlayer())) {
                Player player = event.getPlayer();
                for (ArmorStand armorStand : ThreeDimAdaptor.this.armorStands.values()) {
                    ClickType clickType;
                    Vector vector = new Vector(0.0, 0.25 * armorStand.getHeight(), 0.0);
                    if (!(player.getLocation().getDirection().normalize().dot(armorStand.getLocation().add(vector).subtract(player.getLocation()).toVector().normalize()) > 0.96)) continue;
                    PersistentDataContainer container = armorStand.getPersistentDataContainer();
                    int slot = (Integer)container.get(new NamespacedKey((Plugin)MMOCore.plugin, "slot"), PersistentDataType.INTEGER);
                    if (event.getAction() == Action.LEFT_CLICK_AIR) {
                        clickType = event.getPlayer().isSneaking() ? ClickType.SHIFT_LEFT : ClickType.LEFT;
                    } else if (event.getAction() == Action.RIGHT_CLICK_AIR) {
                        clickType = event.getPlayer().isSneaking() ? ClickType.SHIFT_RIGHT : ClickType.RIGHT;
                    } else {
                        return;
                    }
                    ThreeDimAdaptor.this.generated.whenClicked(new InventoryClickContext(slot, armorStand.getEquipment().getItem(EquipmentSlot.HEAD), clickType, (Cancellable)event));
                    return;
                }
            }
        }

        @EventHandler
        public void onDamage(EntityDamageByEntityEvent event) {
            Player player;
            if (event.getDamager() instanceof Player && (player = (Player)event.getDamager()).equals((Object)ThreeDimAdaptor.this.generated.getPlayer()) && event.getEntity() instanceof ArmorStand && ThreeDimAdaptor.this.armorStands.values().contains(event.getEntity())) {
                event.setCancelled(true);
            }
        }

        public void whenClosed() {
        }
    }

    private class SpawnPacketListener
    extends PacketAdapter {
        public SpawnPacketListener() {
            super((Plugin)MMOCore.plugin, new PacketType[]{PacketType.Play.Server.SPAWN_ENTITY_LIVING});
        }

        public void onPacketSending(PacketEvent event) {
            PacketContainer packet = event.getPacket();
            Entity entity = ProtocolLibrary.getProtocolManager().getEntityFromID(event.getPlayer().getWorld(), ((Integer)packet.getIntegers().read(0)).intValue());
            if (entity instanceof ArmorStand && ThreeDimAdaptor.this.armorStands.values().contains(entity)) {
                event.setCancelled(true);
            }
        }
    }
}

