/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.gui.api;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import java.text.DecimalFormat;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.gui.api.adaptor.AdaptorType;
import net.Indyuce.mmocore.gui.api.item.InventoryItem;
import net.Indyuce.mmocore.gui.api.item.TriggerItem;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public abstract class EditableInventory {
    private final String id;
    private FileConfiguration config;
    private AdaptorType adaptorType;
    private String name;
    private int slots;
    private final Set<InventoryItem> items = new LinkedHashSet<InventoryItem>();
    protected static final DecimalFormat decimal = MythicLib.plugin.getMMOConfig().decimal;

    public EditableInventory(String id) {
        this.id = id;
        Validate.notNull((Object)id, (String)"ID must not be null");
    }

    public void reload(FileConfiguration config) {
        this.config = config;
        this.adaptorType = AdaptorType.valueOf(UtilityMethods.enumName((String)config.getString("adaptor-type", "classic-adaptor")));
        Validate.notNull((Object)((Object)this.adaptorType), (String)(config.getString("adaptor-type") + " does not correspond to an adaptor-type."));
        this.name = config.getString("name");
        Validate.notNull((Object)this.name, (String)"Name must not be null");
        this.slots = Math.min(Math.max(9, config.getInt("slots")), 54);
        Validate.isTrue((this.slots % 9 == 0 ? 1 : 0) != 0, (String)"Slots must be a multiple of 9");
        this.items.clear();
        if (config.contains("items")) {
            Validate.notNull((Object)config.getConfigurationSection("items"), (String)"Could not load item list");
            for (String key : config.getConfigurationSection("items").getKeys(false)) {
                try {
                    ConfigurationSection section = config.getConfigurationSection("items." + key);
                    Validate.notNull((Object)section, (String)"Could not load config");
                    InventoryItem loaded = this.loadInventoryItem(section);
                    this.items.add(loaded);
                }
                catch (IllegalArgumentException exception) {
                    MMOCore.log(Level.WARNING, "Could not load item '" + key + "' from inventory '" + this.getId() + "': " + exception.getMessage());
                }
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public Set<InventoryItem> getItems() {
        return this.items;
    }

    public String getName() {
        return this.name;
    }

    public int getSlots() {
        return this.slots;
    }

    public AdaptorType getAdaptorType() {
        return this.adaptorType;
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public InventoryItem getByFunction(String function) {
        for (InventoryItem item : this.items) {
            if (!item.getFunction().equals(function)) continue;
            return item;
        }
        return null;
    }

    public abstract InventoryItem load(String var1, ConfigurationSection var2);

    private InventoryItem loadInventoryItem(ConfigurationSection config) {
        String function;
        String string = function = config.contains("function") ? config.getString("function").toLowerCase() : "";
        if (function.startsWith("trigger:")) {
            return new TriggerItem(config, function.substring(8));
        }
        return this.load(function, config);
    }
}

