/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.ConfigMessage;
import net.Indyuce.mmocore.api.player.PlayerActivity;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.api.util.MMOCoreUtils;
import net.Indyuce.mmocore.gui.api.EditableInventory;
import net.Indyuce.mmocore.gui.api.GeneratedInventory;
import net.Indyuce.mmocore.gui.api.InventoryClickContext;
import net.Indyuce.mmocore.gui.api.item.InventoryItem;
import net.Indyuce.mmocore.gui.api.item.Placeholders;
import net.Indyuce.mmocore.gui.api.item.SimplePlaceholderItem;
import net.Indyuce.mmocore.waypoint.Waypoint;
import net.Indyuce.mmocore.waypoint.WaypointPath;
import net.Indyuce.mmocore.waypoint.WaypointPathCalculation;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class WaypointViewer
extends EditableInventory {
    public WaypointViewer() {
        super("waypoints");
    }

    @Override
    public InventoryItem load(String function, ConfigurationSection config) {
        if (function.equals("waypoint")) {
            return new WaypointItem(config);
        }
        if (function.equals("previous")) {
            return new SimplePlaceholderItem<WaypointViewerInventory>(config){

                @Override
                public boolean canDisplay(WaypointViewerInventory inv) {
                    return inv.page > 0;
                }
            };
        }
        if (function.equals("next")) {
            return new SimplePlaceholderItem<WaypointViewerInventory>(config){

                @Override
                public boolean canDisplay(WaypointViewerInventory inv) {
                    return inv.getEditable().getByFunction("waypoint").getSlots().size() * (inv.page + 1) < inv.waypoints.size();
                }
            };
        }
        return new SimplePlaceholderItem(config);
    }

    public GeneratedInventory newInventory(PlayerData data) {
        return this.newInventory(data, null);
    }

    public GeneratedInventory newInventory(PlayerData data, Waypoint waypoint) {
        return new WaypointViewerInventory(data, this, waypoint);
    }

    public class WaypointItem
    extends SimplePlaceholderItem<WaypointViewerInventory> {
        private final SimplePlaceholderItem noWaypoint;
        private final SimplePlaceholderItem locked;
        private final WaypointItemHandler availWaypoint;
        private final WaypointItemHandler noStellium;
        private final WaypointItemHandler notLinked;
        private final WaypointItemHandler currentWayPoint;

        public WaypointItem(ConfigurationSection config) {
            super(Material.BARRIER, config);
            Validate.notNull((Object)config.getConfigurationSection("no-waypoint"), (String)"Could not load 'no-waypoint' config");
            Validate.notNull((Object)config.getConfigurationSection("locked"), (String)"Could not load 'locked' config");
            Validate.notNull((Object)config.getConfigurationSection("not-a-destination"), (String)"Could not load 'not-a-destination' config");
            Validate.notNull((Object)config.getConfigurationSection("current-waypoint"), (String)"Could not load 'current-waypoint' config");
            Validate.notNull((Object)config.getConfigurationSection("not-enough-stellium"), (String)"Could not load 'not-enough-stellium' config");
            Validate.notNull((Object)config.getConfigurationSection("display"), (String)"Could not load 'display' config");
            this.noWaypoint = new SimplePlaceholderItem(config.getConfigurationSection("no-waypoint"));
            this.locked = new SimplePlaceholderItem(config.getConfigurationSection("locked"));
            this.notLinked = new WaypointItemHandler(config.getConfigurationSection("not-a-destination"), true);
            this.currentWayPoint = new WaypointItemHandler(config.getConfigurationSection("current-waypoint"), true);
            this.noStellium = new WaypointItemHandler(config.getConfigurationSection("not-enough-stellium"), false);
            this.availWaypoint = new WaypointItemHandler(config.getConfigurationSection("display"), false);
        }

        @Override
        public boolean hasDifferentDisplay() {
            return true;
        }

        @Override
        public ItemStack display(WaypointViewerInventory inv, int n) {
            int index = inv.page * inv.getEditable().getByFunction("waypoint").getSlots().size() + n;
            if (index >= inv.waypoints.size()) {
                return this.noWaypoint.display(inv, n);
            }
            Waypoint waypoint = (Waypoint)inv.waypoints.get(index);
            if (inv.current != null && inv.current.equals(waypoint)) {
                return this.currentWayPoint.display(inv, n);
            }
            if (!inv.getPlayerData().hasWaypoint(waypoint)) {
                return this.locked.display(inv, n);
            }
            if (!inv.paths.containsKey(waypoint)) {
                return this.notLinked.display(inv, n);
            }
            if (((WaypointPath)inv.paths.get(waypoint)).getCost() > inv.getPlayerData().getStellium()) {
                return this.noStellium.display(inv, n);
            }
            return this.availWaypoint.display(inv, n);
        }
    }

    public class WaypointViewerInventory
    extends GeneratedInventory {
        private final List<Waypoint> waypoints;
        @Nullable
        private final Waypoint current;
        private Map<Waypoint, WaypointPath> paths;
        private int page;

        public WaypointViewerInventory(PlayerData playerData, EditableInventory editable, Waypoint current) {
            super(playerData, editable);
            this.waypoints = new ArrayList<Waypoint>(MMOCore.plugin.waypointManager.getAll());
            this.current = current;
            this.paths = new WaypointPathCalculation(playerData).run(current).getPaths();
        }

        @Override
        public String calculateName() {
            return WaypointViewer.this.getName();
        }

        public boolean isDynamicUse() {
            return this.current == null;
        }

        @Override
        public void whenClicked(InventoryClickContext context, InventoryItem item) {
            if (item.getFunction().equals("next")) {
                ++this.page;
                this.open();
                return;
            }
            if (item.getFunction().equals("previous")) {
                --this.page;
                this.open();
                return;
            }
            if (item.getFunction().equals("waypoint")) {
                String tag;
                PersistentDataContainer container = context.getClickedItem().getItemMeta().getPersistentDataContainer();
                String string = tag = container.has(new NamespacedKey((Plugin)MMOCore.plugin, "waypointId"), PersistentDataType.STRING) ? (String)container.get(new NamespacedKey((Plugin)MMOCore.plugin, "waypointId"), PersistentDataType.STRING) : "";
                if (tag.isEmpty()) {
                    return;
                }
                Waypoint waypoint = MMOCore.plugin.waypointManager.get(tag);
                if (!this.playerData.hasWaypoint(waypoint)) {
                    ConfigMessage.fromKey("not-unlocked-waypoint", new Object[0]).send(this.player);
                    return;
                }
                if (waypoint.equals(this.current)) {
                    ConfigMessage.fromKey("standing-on-waypoint", new Object[0]).send(this.player);
                    return;
                }
                if (this.paths.get(waypoint) == null) {
                    ConfigMessage.fromKey("cannot-teleport-to", new Object[0]).send(this.player);
                    return;
                }
                double withdraw = this.paths.get(waypoint).getCost();
                double left = withdraw - this.playerData.getStellium();
                if (left > 0.0) {
                    ConfigMessage.fromKey("not-enough-stellium", "more", decimal.format(left)).send(this.player);
                    return;
                }
                if (this.playerData.getActivityTimeOut(PlayerActivity.USE_WAYPOINT) > 0L) {
                    return;
                }
                this.player.closeInventory();
                this.playerData.warp(waypoint, withdraw);
            }
        }
    }

    public class WaypointItemHandler
    extends InventoryItem<WaypointViewerInventory> {
        private final boolean onlyName;
        private final String splitter;
        private final String none;

        public WaypointItemHandler(ConfigurationSection config, boolean onlyName) {
            super(config);
            this.onlyName = onlyName;
            this.splitter = config.getString("format_path.splitter", ", ");
            this.none = config.getString("format_path.none", "None");
        }

        @Override
        public ItemStack display(WaypointViewerInventory inv, int n) {
            Placeholders placeholders = this.getPlaceholders(inv, n);
            OfflinePlayer effectivePlayer = this.getEffectivePlayer(inv, n);
            ItemStack item = new ItemStack(this.getMaterial());
            ItemMeta meta = item.getItemMeta();
            meta.setCustomModelData(Integer.valueOf(this.getModelData()));
            if (this.hasName()) {
                meta.setDisplayName(placeholders.apply(effectivePlayer, this.getName()));
            }
            if (this.hideFlags()) {
                MMOCoreUtils.addAllItemFlags(meta);
            }
            if (this.hideTooltip()) {
                meta.setHideTooltip(true);
            }
            Waypoint waypoint = (Waypoint)inv.waypoints.get(inv.page * inv.getEditable().getByFunction("waypoint").getSlots().size() + n);
            if (this.hasLore()) {
                ArrayList lore = new ArrayList();
                this.getLore().forEach(line -> {
                    if (line.equals("{lore}")) {
                        for (String added : waypoint.getLore()) {
                            lore.add(ChatColor.GRAY + placeholders.apply(effectivePlayer, added));
                        }
                    } else {
                        lore.add(ChatColor.GRAY + placeholders.apply(effectivePlayer, (String)line));
                    }
                });
                meta.setLore(lore);
            }
            item.setItemMeta(meta);
            PersistentDataContainer container = meta.getPersistentDataContainer();
            container.set(new NamespacedKey((Plugin)MMOCore.plugin, "waypointId"), PersistentDataType.STRING, (Object)waypoint.getId());
            item.setItemMeta(meta);
            return item;
        }

        @Override
        public Placeholders getPlaceholders(WaypointViewerInventory inv, int n) {
            Placeholders holders = new Placeholders();
            Waypoint waypoint = (Waypoint)inv.waypoints.get(inv.page * inv.getByFunction("waypoint").getSlots().size() + n);
            holders.register("name", waypoint.getName());
            if (!this.onlyName) {
                holders.register("current_cost", ((WaypointPath)inv.paths.get(waypoint)).getCost());
                holders.register("normal_cost", decimal.format(inv.paths.containsKey(waypoint) ? ((WaypointPath)inv.paths.get(waypoint)).getCost() : Double.POSITIVE_INFINITY));
                holders.register("dynamic_cost", decimal.format(waypoint.getDynamicCost()));
                holders.register("intermediary_waypoints", inv.paths.containsKey(waypoint) ? ((WaypointPath)inv.paths.get(waypoint)).displayIntermediaryWayPoints(this.splitter, this.none) : this.none);
            }
            return holders;
        }
    }
}

