/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.gui;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.ConfigMessage;
import net.Indyuce.mmocore.api.SoundEvent;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.api.quest.Quest;
import net.Indyuce.mmocore.api.util.math.format.DelayFormat;
import net.Indyuce.mmocore.experience.Profession;
import net.Indyuce.mmocore.gui.api.EditableInventory;
import net.Indyuce.mmocore.gui.api.GeneratedInventory;
import net.Indyuce.mmocore.gui.api.InventoryClickContext;
import net.Indyuce.mmocore.gui.api.item.InventoryItem;
import net.Indyuce.mmocore.gui.api.item.Placeholders;
import net.Indyuce.mmocore.gui.api.item.SimplePlaceholderItem;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class QuestViewer
extends EditableInventory {
    public QuestViewer() {
        super("quest-list");
    }

    @Override
    public InventoryItem load(String function, ConfigurationSection config) {
        if (function.equals("quest")) {
            return new QuestItem(config);
        }
        if (function.equals("previous")) {
            return new SimplePlaceholderItem<QuestInventory>(config){

                @Override
                public boolean canDisplay(QuestInventory inv) {
                    return inv.page > 0;
                }
            };
        }
        if (function.equals("next")) {
            return new SimplePlaceholderItem<QuestInventory>(config){

                @Override
                public boolean canDisplay(QuestInventory inv) {
                    return inv.perPage * (inv.page + 1) < inv.quests.size();
                }
            };
        }
        return new SimplePlaceholderItem(config);
    }

    public GeneratedInventory newInventory(PlayerData data) {
        return new QuestInventory(data, this);
    }

    public class QuestItem
    extends SimplePlaceholderItem {
        private final SimplePlaceholderItem noQuest;
        private final SimplePlaceholderItem locked;
        private final String mainHit;
        private final String mainNotHit;
        private final String professionHit;
        private final String professionNotHit;
        private final SimpleDateFormat dateFormat;

        public QuestItem(ConfigurationSection config) {
            super(config);
            Validate.isTrue((boolean)config.contains("no-quest"), (String)"Could not load config 'no-quest'");
            Validate.isTrue((boolean)config.contains("locked"), (String)"Could not load config 'locked'");
            this.locked = new SimplePlaceholderItem(config.getConfigurationSection("locked"));
            this.noQuest = new SimplePlaceholderItem(config.getConfigurationSection("no-quest"));
            Validate.isTrue((boolean)config.contains("date-format"), (String)"Could not find date-format");
            this.dateFormat = new SimpleDateFormat(config.getString("date-format"));
            this.mainHit = config.getString("level-requirement.main.hit");
            Validate.notNull((Object)this.mainHit, (String)"Could not load 'level-requirement.main.hit'");
            this.mainNotHit = config.getString("level-requirement.main.not-hit");
            Validate.notNull((Object)this.mainNotHit, (String)"Could not load 'level-requirement.main.not-hit'");
            this.professionHit = config.getString("level-requirement.profession.hit");
            Validate.notNull((Object)this.professionHit, (String)"Could not load 'level-requirement.profession.hit'");
            this.professionNotHit = config.getString("level-requirement.profession.not-hit");
            Validate.notNull((Object)this.professionNotHit, (String)"Could not load 'level-requirement.profession.not-hit'");
        }

        @Override
        public boolean hasDifferentDisplay() {
            return true;
        }

        @Override
        public ItemStack display(GeneratedInventory inv, int itemIndex) {
            QuestInventory list = (QuestInventory)inv;
            int index = list.page * list.perPage + itemIndex;
            if (index >= list.quests.size()) {
                return this.noQuest.display(inv, itemIndex);
            }
            Quest quest = (Quest)list.quests.get(index);
            if (quest.hasParent() && !inv.getPlayerData().getQuestData().checkParentAvailability(quest)) {
                return this.locked.display(inv, itemIndex);
            }
            ArrayList<String> lore = new ArrayList<String>(this.getLore());
            int loreIndex = lore.indexOf("{lore}");
            if (loreIndex >= 0) {
                lore.remove(loreIndex);
                for (int j = 0; j < quest.getLore().size(); ++j) {
                    lore.add(loreIndex + j, quest.getLore().get(j));
                }
            }
            int reqCount = quest.countLevelRestrictions();
            boolean started = inv.getPlayerData().getQuestData().hasCurrent(quest);
            boolean completed = inv.getPlayerData().getQuestData().hasFinished(quest);
            boolean cooldown = completed && inv.getPlayerData().getQuestData().checkCooldownAvailability(quest);
            lore.removeIf(next -> next.startsWith("{level_req}") && reqCount < 1 || next.startsWith("{started}") && !started || next.startsWith("{!started}") && started || next.startsWith("{completed}") && !completed || next.startsWith("{completed_cannot_redo}") && (!completed || quest.isRedoable()) || next.startsWith("{completed_can_redo}") && (!cooldown || !quest.isRedoable()) || next.startsWith("{completed_delay}") && (!completed || cooldown));
            loreIndex = lore.indexOf("{level_req}{level_requirements}");
            if (loreIndex >= 0) {
                lore.remove(loreIndex);
                int mainRequired = quest.getLevelRestriction(null);
                if (mainRequired > 0) {
                    lore.add(loreIndex, (inv.getPlayerData().getLevel() >= mainRequired ? this.mainHit : this.mainNotHit).replace("{level}", "" + mainRequired));
                }
                for (Profession profession : quest.getLevelRestrictions()) {
                    int required = quest.getLevelRestriction(profession);
                    lore.add(loreIndex + (mainRequired > 0 ? 1 : 0), (inv.getPlayerData().getCollectionSkills().getLevel(profession) >= required ? this.professionHit : this.professionNotHit).replace("{level}", "" + required).replace("{profession}", profession.getName()));
                }
            }
            Placeholders holders = this.getPlaceholders(inv, itemIndex);
            for (int j = 0; j < lore.size(); ++j) {
                lore.set(j, ChatColor.GRAY + holders.apply((OfflinePlayer)inv.getPlayer(), (String)lore.get(j)));
            }
            ItemStack item = super.display(inv, itemIndex);
            ItemMeta meta = item.getItemMeta();
            meta.setLore(lore);
            meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)MMOCore.plugin, "quest_id"), PersistentDataType.STRING, (Object)quest.getId());
            item.setItemMeta(meta);
            return item;
        }

        @Override
        public Placeholders getPlaceholders(GeneratedInventory inv, int itemIndex) {
            QuestInventory list = (QuestInventory)inv;
            Quest quest = (Quest)((QuestInventory)inv).quests.get(list.page * list.perPage + itemIndex);
            PlayerData data = inv.getPlayerData();
            Placeholders holders = new Placeholders();
            holders.register("name", quest.getName());
            holders.register("total_level_req", quest.getLevelRestrictions().size() + (quest.getLevelRestriction(null) > 0 ? 1 : 0));
            holders.register("current_level_req", (data.getLevel() >= quest.getLevelRestriction(null) ? 1 : 0) + quest.getLevelRestrictions().stream().filter(type -> data.getCollectionSkills().getLevel((Profession)type) >= quest.getLevelRestriction((Profession)type)).collect(Collectors.toSet()).size());
            if (data.getQuestData().hasCurrent(quest)) {
                holders.register("objective", data.getQuestData().getCurrent().getFormattedLore());
                holders.register("progress", (int)((double)data.getQuestData().getCurrent().getObjectiveNumber() / (double)quest.getObjectives().size() * 100.0));
            }
            if (data.getQuestData().hasFinished(quest)) {
                holders.register("date", this.dateFormat.format(data.getQuestData().getFinishDate(quest)));
                holders.register("delay", new DelayFormat(2).format(data.getQuestData().getDelayFeft(quest)));
            }
            return holders;
        }
    }

    public class QuestInventory
    extends GeneratedInventory {
        private final List<Quest> quests;
        private final int perPage;
        private int page;

        public QuestInventory(PlayerData playerData, EditableInventory editable) {
            super(playerData, editable);
            this.quests = new ArrayList<Quest>(MMOCore.plugin.questManager.getAll());
            this.perPage = editable.getByFunction("quest").getSlots().size();
        }

        @Override
        public String calculateName() {
            return QuestViewer.this.getName();
        }

        @Override
        public void whenClicked(InventoryClickContext context, InventoryItem item) {
            if (item.getFunction().equals("previous")) {
                --this.page;
                this.open();
                return;
            }
            if (item.getFunction().equals("next")) {
                ++this.page;
                this.open();
                return;
            }
            if (item.getFunction().equals("quest")) {
                String questId = (String)context.getClickedItem().getItemMeta().getPersistentDataContainer().get(new NamespacedKey((Plugin)MMOCore.plugin, "quest_id"), PersistentDataType.STRING);
                if (questId == null || questId.equals("")) {
                    return;
                }
                Quest quest = MMOCore.plugin.questManager.get(questId);
                if (this.playerData.getQuestData().hasCurrent()) {
                    if (this.playerData.getQuestData().hasCurrent(quest)) {
                        if (context.getClickType() == ClickType.RIGHT) {
                            this.playerData.getQuestData().start(null);
                            MMOCore.plugin.soundManager.getSound(SoundEvent.CANCEL_QUEST).playTo(this.player);
                            ConfigMessage.fromKey("cancel-quest", new Object[0]).send(this.player);
                            this.open();
                        }
                        return;
                    }
                    ConfigMessage.fromKey("already-on-quest", new Object[0]).send(this.player);
                    return;
                }
                int level = quest.getLevelRestriction(null);
                if (this.playerData.getLevel() < level) {
                    ConfigMessage.fromKey("quest-level-restriction", "level", "Lvl", "count", "" + level).send(this.player);
                    return;
                }
                for (Profession profession : quest.getLevelRestrictions()) {
                    level = quest.getLevelRestriction(profession);
                    if (this.playerData.getCollectionSkills().getLevel(profession) >= level) continue;
                    ConfigMessage.fromKey("quest-level-restriction", "level", profession.getName() + " Lvl", "count", "" + level).send(this.player);
                    return;
                }
                if (this.playerData.getQuestData().hasFinished(quest)) {
                    if (!quest.isRedoable()) {
                        ConfigMessage.fromKey("cant-redo-quest", new Object[0]).send(this.player);
                        return;
                    }
                    if (!this.playerData.getQuestData().checkCooldownAvailability(quest)) {
                        ConfigMessage.fromKey("quest-cooldown", "delay", new DelayFormat(2).format(this.playerData.getQuestData().getDelayFeft(quest))).send(this.player);
                        return;
                    }
                }
                ConfigMessage.fromKey("start-quest", "quest", quest.getName()).send(this.player);
                MMOCore.plugin.soundManager.getSound(SoundEvent.START_QUEST).playTo(this.player);
                this.playerData.getQuestData().start(quest);
                this.open();
            }
        }
    }
}

